import React from "react";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { componentOuiaProps } from "../../ouiaTools";
export const PageTitle = ({ title, extra, ouiaId, ouiaSafe }) => {
    return (React.createElement(Flex, Object.assign({}, componentOuiaProps(ouiaId, "page-title", ouiaSafe)),
        React.createElement(FlexItem, { spacer: { default: "spacerSm" } },
            React.createElement(Title, { headingLevel: "h1", size: "4xl" }, title)),
        extra ? React.createElement(FlexItem, { spacer: { default: "spacerSm" } }, extra) : null));
};
//# sourceMappingURL=PageTitle.js.map