var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { AssociationPath, AuthorityRequirementPath, InformationRequirementPath, KnowledgeRequirementPath, } from "../diagram/edges/Edges";
import { EdgeMarkers } from "../diagram/edges/EdgeMarkers";
import { EDGE_TYPES } from "../diagram/edges/EdgeTypes";
import { getSnappedMultiPointAnchoredEdgePath } from "../diagram/edges/getSnappedMultiPointAnchoredEdgePath";
import { InputDataNodeSvg, DecisionNodeSvg, BkmNodeSvg, KnowledgeSourceNodeSvg, DecisionServiceNodeSvg, GroupNodeSvg, TextAnnotationNodeSvg, UnknownNodeSvg, AlternativeInputDataNodeSvg, } from "../diagram/nodes/NodeSvgs";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { useMemo } from "react";
import { assertUnreachable, getDmnFontStyle, getNodeLabelPosition, getNodeShapeFillColor, getNodeShapeStrokeColor, getNodeStyle, } from "../diagram/nodes/NodeStyle";
import { buildFeelQNameFromXmlQName } from "../feel/buildFeelQName";
import { Text } from "@visx/text";
export function DmnDiagramSvg(_a) {
    var nodes = _a.nodes, edges = _a.edges, snapGrid = _a.snapGrid, thisDmn = _a.thisDmn, importsByNamespace = _a.importsByNamespace, isAlternativeInputDataShape = _a.isAlternativeInputDataShape, allDataTypesById = _a.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _a.allTopLevelItemDefinitionUniqueNames;
    var _b = useMemo(function () {
        var nodesById = new Map();
        var nodesSvg = nodes.map(function (node) {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9;
            var _10 = getNodeStyle({
                fillColor: getNodeShapeFillColor({
                    dmnStyle: node.data.shape["di:Style"],
                    nodeType: node.type,
                    isEnabled: true,
                }),
                strokeColor: getNodeShapeStrokeColor({ dmnStyle: node.data.shape["di:Style"], isEnabled: true }),
                dmnFontStyle: getDmnFontStyle({ dmnStyle: node.data.shape["di:Style"], isEnabled: true }),
            }), fontStyle = _10.fontCssProperties, shapeStyle = _10.shapeStyle;
            nodesById.set(node.id, node);
            var _11 = node.style, height = _11.height, width = _11.width, style = __rest(_11, ["height", "width"]);
            var isCollection = ((_b = (_a = node.data) === null || _a === void 0 ? void 0 : _a.dmnObject) === null || _b === void 0 ? void 0 : _b.__$$element) === "inputData"
                ? (_h = (_g = (_f = allDataTypesById.get((_e = allTopLevelItemDefinitionUniqueNames.get((_d = (_c = node.data.dmnObject.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"]) !== null && _d !== void 0 ? _d : "")) !== null && _e !== void 0 ? _e : "")) === null || _f === void 0 ? void 0 : _f.itemDefinition) === null || _g === void 0 ? void 0 : _g["@_isCollection"]) !== null && _h !== void 0 ? _h : false
                : ((_k = (_j = node.data) === null || _j === void 0 ? void 0 : _j.dmnObject) === null || _k === void 0 ? void 0 : _k.__$$element) === "decision"
                    ? (_r = (_q = (_p = allDataTypesById.get((_o = allTopLevelItemDefinitionUniqueNames.get((_m = (_l = node.data.dmnObject.variable) === null || _l === void 0 ? void 0 : _l["@_typeRef"]) !== null && _m !== void 0 ? _m : "")) !== null && _o !== void 0 ? _o : "")) === null || _p === void 0 ? void 0 : _p.itemDefinition) === null || _q === void 0 ? void 0 : _q["@_isCollection"]) !== null && _r !== void 0 ? _r : false
                    : false;
            var label = ((_t = (_s = node.data) === null || _s === void 0 ? void 0 : _s.dmnObject) === null || _t === void 0 ? void 0 : _t.__$$element) === "group"
                ? (_y = (_v = (_u = node.data.dmnObject) === null || _u === void 0 ? void 0 : _u["@_label"]) !== null && _v !== void 0 ? _v : (_x = (_w = node.data) === null || _w === void 0 ? void 0 : _w.dmnObject) === null || _x === void 0 ? void 0 : _x["@_name"]) !== null && _y !== void 0 ? _y : "<Empty>"
                : ((_0 = (_z = node.data) === null || _z === void 0 ? void 0 : _z.dmnObject) === null || _0 === void 0 ? void 0 : _0.__$$element) === "textAnnotation"
                    ? (_6 = (_2 = (_1 = node.data.dmnObject) === null || _1 === void 0 ? void 0 : _1["@_label"]) !== null && _2 !== void 0 ? _2 : (_5 = (_4 = (_3 = node.data) === null || _3 === void 0 ? void 0 : _3.dmnObject) === null || _4 === void 0 ? void 0 : _4.text) === null || _5 === void 0 ? void 0 : _5.__$$text) !== null && _6 !== void 0 ? _6 : "<Empty>"
                    : buildFeelQNameFromXmlQName({
                        namedElement: node.data.dmnObject,
                        importsByNamespace: importsByNamespace,
                        model: thisDmn.model.definitions,
                        namedElementQName: node.data.dmnObjectQName,
                        relativeToNamespace: thisDmn.model.definitions["@_namespace"],
                    }).full;
            return (_jsxs("g", __assign({ "data-kie-dmn-node-id": node.id }, { children: [node.type === NODE_TYPES.inputData &&
                        (isAlternativeInputDataShape ? (_jsx(AlternativeInputDataNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle, { isIcon: false, isCollection: isCollection }))) : (_jsx(InputDataNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle, { isCollection: isCollection })))), node.type === NODE_TYPES.decision && (_jsx(DecisionNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle, { isCollection: isCollection, hasHiddenRequirements: (_7 = node.data.hasHiddenRequirements) !== null && _7 !== void 0 ? _7 : false }))), node.type === NODE_TYPES.bkm && (_jsx(BkmNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle, { hasHiddenRequirements: (_8 = node.data.hasHiddenRequirements) !== null && _8 !== void 0 ? _8 : false }))), node.type === NODE_TYPES.knowledgeSource && (_jsx(KnowledgeSourceNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle, { hasHiddenRequirements: (_9 = node.data.hasHiddenRequirements) !== null && _9 !== void 0 ? _9 : false }))), node.type === NODE_TYPES.decisionService && (_jsx(DecisionServiceNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y, showSectionLabels: false, isReadonly: true }, style, shapeStyle))), node.type === NODE_TYPES.group && (_jsx(GroupNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle))), node.type === NODE_TYPES.textAnnotation && (_jsx(TextAnnotationNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle))), node.type === NODE_TYPES.unknown && (_jsx(UnknownNodeSvg, __assign({ width: node.width, height: node.height, x: node.positionAbsolute.x, y: node.positionAbsolute.y }, style, shapeStyle))), _jsx(_Fragment, { children: label.split("\n").map(function (labelLine, i) { return (_jsx(Text, __assign({ lineHeight: fontStyle.lineHeight, style: __assign({}, fontStyle), dy: "calc(1.5em * ".concat(i, ")") }, getNodeLabelSvgTextAlignmentProps(node, getNodeLabelPosition({ nodeType: node.type, isAlternativeInputDataShape: isAlternativeInputDataShape })), { children: labelLine }), i)); }) })] }), node.id));
        });
        return { nodesSvg: nodesSvg, nodesById: nodesById };
    }, [
        allDataTypesById,
        allTopLevelItemDefinitionUniqueNames,
        importsByNamespace,
        isAlternativeInputDataShape,
        nodes,
        thisDmn.model.definitions,
    ]), nodesSvg = _b.nodesSvg, nodesById = _b.nodesById;
    return (_jsxs(_Fragment, { children: [_jsx(EdgeMarkers, {}), edges.map(function (e) {
                var _a, _b, _c, _d, _e, _f, _g;
                var s = nodesById === null || nodesById === void 0 ? void 0 : nodesById.get(e.source);
                var t = nodesById === null || nodesById === void 0 ? void 0 : nodesById.get(e.target);
                var path = getSnappedMultiPointAnchoredEdgePath({
                    snapGrid: snapGrid,
                    dmnEdge: (_a = e.data) === null || _a === void 0 ? void 0 : _a.dmnEdge,
                    dmnShapeSource: (_b = e.data) === null || _b === void 0 ? void 0 : _b.dmnShapeSource,
                    dmnShapeTarget: (_c = e.data) === null || _c === void 0 ? void 0 : _c.dmnShapeTarget,
                    sourceNodeBounds: {
                        x: (_d = s === null || s === void 0 ? void 0 : s.positionAbsolute) === null || _d === void 0 ? void 0 : _d.x,
                        y: (_e = s === null || s === void 0 ? void 0 : s.positionAbsolute) === null || _e === void 0 ? void 0 : _e.y,
                        width: s === null || s === void 0 ? void 0 : s.width,
                        height: s === null || s === void 0 ? void 0 : s.height,
                    },
                    targetNodeBounds: {
                        x: (_f = t === null || t === void 0 ? void 0 : t.positionAbsolute) === null || _f === void 0 ? void 0 : _f.x,
                        y: (_g = t === null || t === void 0 ? void 0 : t.positionAbsolute) === null || _g === void 0 ? void 0 : _g.y,
                        width: t === null || t === void 0 ? void 0 : t.width,
                        height: t === null || t === void 0 ? void 0 : t.height,
                    },
                }).path;
                return (_jsxs(React.Fragment, { children: [e.type === EDGE_TYPES.informationRequirement && _jsx(InformationRequirementPath, { d: path }), e.type === EDGE_TYPES.knowledgeRequirement && _jsx(KnowledgeRequirementPath, { d: path }), e.type === EDGE_TYPES.authorityRequirement && (_jsx(AuthorityRequirementPath, { d: path, centerToConnectionPoint: true })), e.type === EDGE_TYPES.association && _jsx(AssociationPath, { d: path })] }, e.id));
            }), nodesSvg] }));
}
var SVG_NODE_LABEL_TEXT_PADDING_ALL = 10;
var SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT = 8;
export function getNodeLabelSvgTextAlignmentProps(n, labelPosition) {
    switch (labelPosition) {
        case "center-bottom":
            var cbTx = n.position.x + n.width / 2;
            var cbTy = n.position.y + n.height + 4;
            var cbWidth = n.width;
            return {
                verticalAnchor: "start",
                textAnchor: "middle",
                transform: "translate(".concat(cbTx, ",").concat(cbTy, ")"),
                width: cbWidth,
            };
        case "center-center":
            var ccTx = n.position.x + n.width / 2;
            var ccTy = n.position.y + n.height / 2;
            var ccWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL;
            return {
                verticalAnchor: "middle",
                textAnchor: "middle",
                transform: "translate(".concat(ccTx, ",").concat(ccTy, ")"),
                width: ccWidth,
            };
        case "top-center":
            var tcTx = n.position.x + n.width / 2;
            var tcTy = n.position.y + SVG_NODE_LABEL_TEXT_PADDING_ALL;
            var tcWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL;
            return {
                verticalAnchor: "start",
                textAnchor: "middle",
                transform: "translate(".concat(tcTx, ",").concat(tcTy, ")"),
                width: tcWidth,
            };
        case "center-left":
            var clTx = n.position.x + SVG_NODE_LABEL_TEXT_PADDING_ALL;
            var clTy = n.position.y + n.height / 2;
            var clWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL;
            return {
                verticalAnchor: "middle",
                textAnchor: "start",
                transform: "translate(".concat(clTx, ",").concat(clTy, ")"),
                width: clWidth,
            };
        case "top-left":
            var tlTx = n.position.x + SVG_NODE_LABEL_TEXT_PADDING_ALL + SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT;
            var tlTy = n.position.y + SVG_NODE_LABEL_TEXT_PADDING_ALL + SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT;
            var tlWidth = n.width - 2 * SVG_NODE_LABEL_TEXT_PADDING_ALL - 2 * SVG_NODE_LABEL_TEXT_ADDITIONAL_PADDING_TOP_LEFT;
            return {
                verticalAnchor: "start",
                textAnchor: "start",
                transform: "translate(".concat(tlTx, ",").concat(tlTy, ")"),
                width: tlWidth,
            };
        default:
            assertUnreachable(labelPosition);
    }
}
//# sourceMappingURL=DmnDiagramSvg.js.map