var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { computeDiagramData } from "../store/computed/computeDiagramData";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { parseXmlHref } from "../xml/xmlHrefs";
import { computeIndexedDrd } from "../store/computed/computeIndexes";
import { getDefaultDrdName } from "../mutations/addOrGetDrd";
import { addShape } from "../mutations/addShape";
import { addEdge } from "../mutations/addEdge";
import { PositionalNodeHandleId } from "../diagram/connections/PositionalNodeHandles";
export function autoGenerateDrd(args) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var definedNamespaces, updateIndexedDrdWithNodes, _b, updatedNodesByIdWithNodes, updatedDrgEdgesWithNodes, externalNodesHref, updatedIndexedDrdWithExternalNodes, _c, updatedNodesByIdWithExternalNodes, updatedEdgesByIdWithExternalNodes, updatedDrgEdgesWithExternalNodes, updatedDrgEdgesWithExternalNodes_1, updatedDrgEdgesWithExternalNodes_1_1, drgEdge, edge, sourceNode, targetNode;
        var e_1, _d;
        return __generator(this, function (_e) {
            args.model.definitions["dmndi:DMNDI"] = __assign(__assign({}, args.model.definitions["dmndi:DMNDI"]), { "dmndi:DMNDiagram": [
                    {
                        "@_id": generateUuid(),
                        "@_name": getDefaultDrdName({ drdIndex: 0 }),
                        "@_useAlternativeInputDataShape": false,
                        "dmndi:DMNDiagramElement": [],
                        "di:extension": { "kie:ComponentsWidthsExtension": { "kie:ComponentWidths": [{}] } },
                    },
                ] });
            (_a = args.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a.forEach(function (drgElement) {
                var _a;
                var nodeType = (_a = getNodeTypeFromDmnObject(drgElement)) !== null && _a !== void 0 ? _a : "node_unknown";
                var minNodeSize = MIN_NODE_SIZES[nodeType]({
                    snapGrid: {
                        isEnabled: true,
                        x: 20,
                        y: 20,
                    },
                    isAlternativeInputDataShape: false,
                });
                addShape({
                    definitions: args.model.definitions,
                    drdIndex: 0,
                    nodeType: nodeType,
                    shape: {
                        "@_id": generateUuid(),
                        "@_dmnElementRef": drgElement["@_id"],
                        "dc:Bounds": __assign({ "@_x": 0, "@_y": 0 }, minNodeSize),
                    },
                });
            });
            definedNamespaces = new Map(Object.keys(args.model.definitions)
                .filter(function (keys) { return String(keys).startsWith("@_xmlns:"); })
                .map(function (xmlnsKey) { return [
                args.model.definitions[xmlnsKey],
                xmlnsKey.split("@_xmlns:")[1],
            ]; }));
            updateIndexedDrdWithNodes = computeIndexedDrd(args.model.definitions["@_namespace"], args.model.definitions, 0);
            _b = computeDiagramData(args.diagram, args.model.definitions, args.externalModelTypesByNamespace, updateIndexedDrdWithNodes, false), updatedNodesByIdWithNodes = _b.nodesById, updatedDrgEdgesWithNodes = _b.drgEdges;
            externalNodesHref = updatedDrgEdgesWithNodes.reduce(function (acc, drgEdge) {
                if (!updatedNodesByIdWithNodes.has(drgEdge.sourceId)) {
                    acc.add(drgEdge.sourceId);
                }
                if (!updatedNodesByIdWithNodes.has(drgEdge.targetId)) {
                    acc.add(drgEdge.targetId);
                }
                return acc;
            }, new Set());
            externalNodesHref.forEach(function (href) {
                var _a, _b;
                var _c = parseXmlHref(href), namespace = _c.namespace, id = _c.id;
                if (namespace) {
                    var externalModel = (_a = args.externalModelsByNamespace) === null || _a === void 0 ? void 0 : _a[namespace];
                    if (externalModel && externalModel.model.definitions) {
                        var drgElements = externalModel.model.definitions.drgElement;
                        var drgElement = drgElements === null || drgElements === void 0 ? void 0 : drgElements.filter(function (drgElement) { return drgElement["@_id"] === id; });
                        var nodeType = (_b = getNodeTypeFromDmnObject(drgElement[0])) !== null && _b !== void 0 ? _b : "node_unknown";
                        var minNodeSize = MIN_NODE_SIZES[nodeType]({
                            snapGrid: {
                                isEnabled: true,
                                x: 20,
                                y: 20,
                            },
                            isAlternativeInputDataShape: false,
                        });
                        addShape({
                            definitions: args.model.definitions,
                            drdIndex: 0,
                            nodeType: nodeType,
                            shape: {
                                "@_id": generateUuid(),
                                "@_dmnElementRef": "".concat(definedNamespaces.get(namespace), ":").concat(id),
                                "dc:Bounds": __assign({ "@_x": 0, "@_y": 0 }, minNodeSize),
                            },
                        });
                    }
                }
            });
            updatedIndexedDrdWithExternalNodes = computeIndexedDrd(args.model.definitions["@_namespace"], args.model.definitions, 0);
            _c = computeDiagramData(args.diagram, args.model.definitions, args.externalModelTypesByNamespace, updatedIndexedDrdWithExternalNodes, false), updatedNodesByIdWithExternalNodes = _c.nodesById, updatedEdgesByIdWithExternalNodes = _c.edgesById, updatedDrgEdgesWithExternalNodes = _c.drgEdges;
            try {
                for (updatedDrgEdgesWithExternalNodes_1 = __values(updatedDrgEdgesWithExternalNodes), updatedDrgEdgesWithExternalNodes_1_1 = updatedDrgEdgesWithExternalNodes_1.next(); !updatedDrgEdgesWithExternalNodes_1_1.done; updatedDrgEdgesWithExternalNodes_1_1 = updatedDrgEdgesWithExternalNodes_1.next()) {
                    drgEdge = updatedDrgEdgesWithExternalNodes_1_1.value;
                    edge = updatedEdgesByIdWithExternalNodes.get(drgEdge.id);
                    sourceNode = updatedNodesByIdWithExternalNodes.get(drgEdge.sourceId);
                    targetNode = updatedNodesByIdWithExternalNodes.get(drgEdge.targetId);
                    if (!edge || !sourceNode || !targetNode) {
                        continue;
                    }
                    addEdge({
                        definitions: args.model.definitions,
                        drdIndex: 0,
                        keepWaypoints: false,
                        edge: {
                            autoPositionedEdgeMarker: undefined,
                            type: edge.type,
                            targetHandle: PositionalNodeHandleId.Bottom,
                            sourceHandle: PositionalNodeHandleId.Top,
                        },
                        sourceNode: {
                            type: sourceNode.type,
                            href: sourceNode.id,
                            data: sourceNode.data,
                            bounds: sourceNode.data.shape["dc:Bounds"],
                            shapeId: sourceNode.data.shape["@_id"],
                        },
                        targetNode: {
                            type: targetNode.type,
                            href: targetNode.id,
                            data: targetNode.data,
                            bounds: targetNode.data.shape["dc:Bounds"],
                            index: targetNode.data.index,
                            shapeId: targetNode.data.shape["@_id"],
                        },
                    });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (updatedDrgEdgesWithExternalNodes_1_1 && !updatedDrgEdgesWithExternalNodes_1_1.done && (_d = updatedDrgEdgesWithExternalNodes_1.return)) _d.call(updatedDrgEdgesWithExternalNodes_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return [2];
        });
    });
}
//# sourceMappingURL=autoGenerateDrd.js.map