/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.perf;

import com.google.common.reflect.ClassPath;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.hugegraph.func.TriFunction;
import org.apache.hugegraph.perf.LightStopwatch;
import org.apache.hugegraph.perf.NormalStopwatch;
import org.apache.hugegraph.perf.Stopwatch;
import org.apache.hugegraph.testutil.Assert;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.ReflectionUtil;
import org.slf4j.Logger;

public final class PerfUtil {
    private static final Logger LOG = Log.logger(PerfUtil.class);
    private static final int DEFAULT_CAPACITY = 1024;
    private static final ThreadLocal<PerfUtil> INSTANCE = new ThreadLocal();
    private static PerfUtil SINGLE_INSTANCE = null;
    private static Thread SINGLE_THREAD = null;
    private static LocalTimer LOCAL_TIMER = null;
    private static boolean LIGHT_WATCH = false;
    private final Map<Stopwatch.Path, Stopwatch> stopwatches = new HashMap<Stopwatch.Path, Stopwatch>(1024);
    private final LocalStack<Stopwatch> callStack = new LocalStack(1024);
    private final Stopwatch root = PerfUtil.newStopwatch("root", Stopwatch.Path.EMPTY);

    private PerfUtil() {
    }

    public static PerfUtil instance() {
        if (SINGLE_INSTANCE != null && SINGLE_THREAD == Thread.currentThread()) {
            return SINGLE_INSTANCE;
        }
        PerfUtil p = INSTANCE.get();
        if (p == null) {
            p = new PerfUtil();
            INSTANCE.set(p);
        }
        return p;
    }

    public static void profileSingleThread(boolean yes) {
        SINGLE_INSTANCE = yes ? PerfUtil.instance() : null;
        SINGLE_THREAD = yes ? Thread.currentThread() : null;
    }

    public static void useLocalTimer(boolean yes) {
        if (yes) {
            if (LOCAL_TIMER != null) {
                return;
            }
            LOCAL_TIMER = new LocalTimer();
            try {
                LOCAL_TIMER.startTimeUpdateLoop();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!LIGHT_WATCH) {
                NormalStopwatch.initEachWastedLost();
            }
        } else {
            if (LOCAL_TIMER == null) {
                return;
            }
            try {
                LOCAL_TIMER.stop();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                LOCAL_TIMER = null;
            }
        }
    }

    public static void useLightStopwatch(boolean yes) {
        if (yes != LIGHT_WATCH) {
            PerfUtil instance = INSTANCE.get();
            boolean empty = instance == null || instance.empty();
            String message = "Please call clear() before switching light-stopwatch due to there is dirty watch";
            E.checkArgument(empty, message, new Object[0]);
        }
        LIGHT_WATCH = yes;
    }

    protected static long now() {
        if (LOCAL_TIMER != null) {
            return LOCAL_TIMER.now();
        }
        return System.nanoTime();
    }

    protected static Stopwatch newStopwatch(String name, Stopwatch.Path parent) {
        return LIGHT_WATCH ? new LightStopwatch(name, parent) : new NormalStopwatch(name, parent);
    }

    protected static Stopwatch newStopwatch(String name, Stopwatch parent) {
        return LIGHT_WATCH ? new LightStopwatch(name, parent) : new NormalStopwatch(name, parent);
    }

    public Stopwatch start(String name) {
        long start = PerfUtil.now();
        Stopwatch parent = this.callStack.empty() ? this.root : this.callStack.peek();
        Stopwatch watch = parent.child(name);
        if (watch == null) {
            watch = PerfUtil.newStopwatch(name, parent);
            assert (!this.stopwatches.containsKey(watch.id())) : watch;
            this.stopwatches.put(watch.id(), watch);
        }
        this.callStack.push(watch);
        watch.startTime(start);
        return watch;
    }

    public Stopwatch start2(String name) {
        long start = PerfUtil.now();
        Stopwatch.Path parent = this.callStack.empty() ? Stopwatch.Path.EMPTY : this.callStack.peek().id();
        Stopwatch.Path id = Stopwatch.id(parent, name);
        Stopwatch watch = this.stopwatches.get(id);
        if (watch == null) {
            watch = PerfUtil.newStopwatch(name, parent);
            this.stopwatches.put(watch.id(), watch);
        }
        this.callStack.push(watch);
        watch.startTime(start);
        return watch;
    }

    public void end(String name) {
        long start = LIGHT_WATCH ? 0L : PerfUtil.now();
        Stopwatch watch = this.callStack.pop();
        if (watch == null || watch.name() != name) {
            throw new IllegalArgumentException("Invalid watch name: " + name);
        }
        watch.endTime(start);
    }

    public boolean empty() {
        return this.stopwatches.isEmpty() && this.root.empty();
    }

    public void clear() {
        String error = "Can't be cleared when the call has not ended yet";
        E.checkState(this.callStack.empty(), error, new Object[0]);
        this.stopwatches.clear();
        this.root.clear();
    }

    public void profilePackage(String ... packages) throws Throwable {
        HashSet loadedClasses = new HashSet();
        Function<String, Boolean> inPackage = cls -> {
            for (String pkg : packages) {
                if (!cls.startsWith(pkg)) continue;
                return true;
            }
            return false;
        };
        Assert.ThrowableConsumer<String> profileClassIfPresent = cls -> {
            if (!loadedClasses.contains(cls)) {
                for (String s : ReflectionUtil.superClasses(cls)) {
                    if (loadedClasses.contains(s) || !((Boolean)inPackage.apply(s)).booleanValue()) continue;
                    this.profileClass(s);
                    loadedClasses.add(s);
                }
                this.profileClass((String)cls);
                loadedClasses.add(cls);
            }
        };
        Iterator<ClassPath.ClassInfo> classes = ReflectionUtil.classes(packages);
        while (classes.hasNext()) {
            String cls2 = classes.next().getName();
            profileClassIfPresent.accept(cls2);
            for (String s : ReflectionUtil.nestedClasses(cls2)) {
                profileClassIfPresent.accept(s);
            }
        }
    }

    public void profileClass(String ... classes) throws Throwable {
        ClassPool classPool = ClassPool.getDefault();
        for (String cls : classes) {
            CtClass ctClass = classPool.get(cls);
            List<CtMethod> methods = ReflectionUtil.getMethodsAnnotatedWith(ctClass, Watched.class, false);
            for (CtMethod method : methods) {
                this.profile(method);
            }
            if (methods.isEmpty()) continue;
            ctClass.toClass();
        }
    }

    private void profile(CtMethod ctMethod) throws CannotCompileException, ClassNotFoundException {
        String START = "org.apache.hugegraph.perf.PerfUtil.instance().start(\"%s\");";
        String END = "org.apache.hugegraph.perf.PerfUtil.instance().end(\"%s\");";
        Watched annotation = (Watched)ctMethod.getAnnotation(Watched.class);
        String name = annotation.value();
        if (name.isEmpty()) {
            name = ctMethod.getName();
        }
        if (!annotation.prefix().isEmpty()) {
            name = annotation.prefix() + "." + name;
        }
        ctMethod.insertBefore(String.format("org.apache.hugegraph.perf.PerfUtil.instance().start(\"%s\");", name));
        ctMethod.insertAfter(String.format("org.apache.hugegraph.perf.PerfUtil.instance().end(\"%s\");", name), true);
        LOG.debug("Profiled for: '{}' [{}]", (Object)name, (Object)ctMethod.getLongName());
    }

    public String toString() {
        return this.stopwatches.toString();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder(8 + this.stopwatches.size() * 96);
        sb.append('{');
        for (Map.Entry<Stopwatch.Path, Stopwatch> w : this.stopwatches.entrySet()) {
            sb.append('\"');
            sb.append(w.getKey());
            sb.append('\"');
            sb.append(':');
            sb.append(w.getValue().toJson());
            sb.append(',');
        }
        if (!this.stopwatches.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }

    public String toECharts() {
        TriFunction<Integer, Integer, List, String> formatLevel = (totalDepth, depth, items) -> {
            float factor = 100.0f / (float)(totalDepth + 1);
            float showFactor = 1.0f + (float)(totalDepth - depth) / (float)depth.intValue();
            float radiusFrom = (float)depth.intValue() * factor;
            float radiusTo = (float)depth.intValue() * factor + factor;
            if (depth == 1) {
                radiusFrom = 0.0f;
            }
            StringBuilder sb = new StringBuilder(8 + items.size() * 128);
            sb.append('{');
            sb.append("name: 'Total Cost',");
            sb.append("type: 'pie',");
            sb.append(String.format("radius: ['%s%%', '%s%%'],", Float.valueOf(radiusFrom), Float.valueOf(radiusTo)));
            sb.append(String.format("label: {normal: {position: 'inner', formatter:function(params) {  if (params.percent > %s) return params.data.name;  else return '';}}},", Float.valueOf(showFactor)));
            sb.append("data: [");
            items.sort((i, j) -> i.id().compareTo(j.id()));
            for (Stopwatch w : items) {
                sb.append('{');
                sb.append("id:'");
                sb.append(w.id());
                sb.append("',");
                sb.append("name:'");
                sb.append(w.name());
                sb.append("',");
                sb.append("value:");
                sb.append(w.totalCost());
                sb.append(',');
                sb.append("cost:");
                sb.append((double)w.totalCost() / 1000000.0);
                sb.append(',');
                sb.append("minCost:");
                sb.append(w.minCost());
                sb.append(',');
                sb.append("maxCost:");
                sb.append(w.maxCost());
                sb.append(',');
                sb.append("wasted:");
                sb.append((double)w.totalWasted() / 1000000.0);
                sb.append(',');
                sb.append("selfWasted:");
                sb.append((double)w.totalSelfWasted() / 1000000.0);
                sb.append(',');
                sb.append("times:");
                sb.append(w.times());
                sb.append(',');
                sb.append("totalTimes:");
                sb.append(w.totalTimes());
                sb.append('}');
                sb.append(',');
            }
            if (!items.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]}");
            return sb.toString();
        };
        BiConsumer<List, List> fillChildrenTotal = (itemsOfLn, itemsOfLnParent) -> {
            for (Stopwatch parent : itemsOfLnParent) {
                List<Stopwatch> children = itemsOfLn.stream().filter(c -> c.parent().equals(parent.id())).collect(Collectors.toList());
                parent.fillChildrenTotal(children);
            }
        };
        BiConsumer<List, List> fillOther = (itemsOfLn, itemsOfLnParent) -> {
            for (Stopwatch parent : itemsOfLnParent) {
                Stream<Stopwatch> children = itemsOfLn.stream().filter(c -> c.parent().equals(parent.id()));
                long sumCost = children.mapToLong(Stopwatch::totalCost).sum();
                long otherCost = parent.totalCost() - sumCost;
                if (otherCost <= 0L) continue;
                Stopwatch other = PerfUtil.newStopwatch("~", parent.id());
                other.totalCost(otherCost);
                itemsOfLn.add(other);
            }
        };
        Map<Stopwatch.Path, Stopwatch> items2 = this.stopwatches;
        HashMap<Integer, LinkedList<Stopwatch>> levelItems = new HashMap<Integer, LinkedList<Stopwatch>>();
        int maxDepth = 0;
        for (Map.Entry<Stopwatch.Path, Stopwatch> e : items2.entrySet()) {
            int depth2 = e.getKey().toString().split("/").length;
            LinkedList<Stopwatch> levelItem = (LinkedList<Stopwatch>)levelItems.get(depth2);
            if (levelItem == null) {
                levelItem = new LinkedList<Stopwatch>();
                levelItems.putIfAbsent(depth2, levelItem);
            }
            levelItem.add(e.getValue().copy());
            if (depth2 <= maxDepth) continue;
            maxDepth = depth2;
        }
        for (int i = maxDepth; i > 0; --i) {
            assert (levelItems.containsKey(i)) : i;
            List itemsOfI = (List)levelItems.get(i);
            List itemsOfParent = (List)levelItems.get(i - 1);
            if (itemsOfParent == null) continue;
            fillChildrenTotal.accept(itemsOfI, itemsOfParent);
        }
        StringBuilder sb = new StringBuilder(8 + items2.size() * 128);
        sb.append("{");
        sb.append("tooltip: {trigger: 'item', formatter: function(params) {  return params.data.name + ' ' + params.percent + '% <br/>'    + 'cost: ' + params.data.cost + ' (ms) <br/>'    + 'min cost: ' + params.data.minCost + ' (ns) <br/>'    + 'max cost: ' + params.data.maxCost + ' (ns) <br/>'    + 'wasted: ' + params.data.wasted + ' (ms) <br/>'    + 'self wasted: ' + params.data.selfWasted + ' (ms) <br/>'    + 'times: ' + params.data.times + '<br/>'    + 'total times: ' + params.data.totalTimes + '<br/>'    + 'path: ' + params.data.id + '<br/>';}");
        sb.append("},");
        sb.append("series: [");
        for (int i = 1; i <= maxDepth; ++i) {
            assert (levelItems.containsKey(i)) : i;
            List itemsOfI = (List)levelItems.get(i);
            List itemsOfParent = (List)levelItems.get(i - 1);
            if (itemsOfParent != null) {
                fillOther.accept(itemsOfI, itemsOfParent);
            }
            sb.append(formatLevel.apply(maxDepth, i, itemsOfI));
            sb.append(',');
        }
        if (!items2.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
    public static @interface Watched {
        public String value() default "";

        public String prefix() default "";
    }

    public static final class FastMap<K, V> {
        private final Map<K, V> hashMap = new HashMap();
        private K key1;
        private K key2;
        private K key3;
        private V val1;
        private V val2;
        private V val3;

        public int size() {
            return this.hashMap.size();
        }

        public boolean containsKey(Object key) {
            return this.hashMap.containsKey(key);
        }

        public V get(Object key) {
            if (key == this.key1) {
                return this.val1;
            }
            if (key == this.key2) {
                return this.val2;
            }
            if (key == this.key3) {
                return this.val3;
            }
            return this.hashMap.get(key);
        }

        public V put(K key, V value) {
            if (this.key1 == null) {
                this.key1 = key;
                this.val1 = value;
            } else if (this.key2 == null) {
                this.key2 = key;
                this.val2 = value;
            } else if (this.key3 == null) {
                this.key3 = key;
                this.val3 = value;
            }
            return this.hashMap.put(key, value);
        }

        public V remove(Object key) {
            if (key == this.key1) {
                this.key1 = null;
                this.val1 = null;
            } else if (key == this.key2) {
                this.key2 = null;
                this.val2 = null;
            } else if (key == this.key3) {
                this.key3 = null;
                this.val3 = null;
            }
            return this.hashMap.remove(key);
        }

        public void clear() {
            this.key1 = null;
            this.key2 = null;
            this.key3 = null;
            this.val1 = null;
            this.val2 = null;
            this.val3 = null;
            this.hashMap.clear();
        }
    }

    public static final class LocalStack<E> {
        private final Object[] elementData;
        private int elementCount;

        public LocalStack(int capacity) {
            this.elementData = new Object[capacity];
            this.elementCount = 0;
        }

        int size() {
            return this.elementCount;
        }

        boolean empty() {
            return this.elementCount == 0;
        }

        public void push(E elem) {
            this.elementData[this.elementCount++] = elem;
        }

        public E pop() {
            if (this.elementCount == 0) {
                throw new EmptyStackException();
            }
            --this.elementCount;
            Object elem = this.elementData[this.elementCount];
            this.elementData[this.elementCount] = null;
            return (E)elem;
        }

        public E peek() {
            if (this.elementCount == 0) {
                throw new EmptyStackException();
            }
            Object elem = this.elementData[this.elementCount - 1];
            return (E)elem;
        }
    }

    public static final class LocalTimer {
        private volatile long padding11 = 0L;
        private volatile long padding12 = 0L;
        private volatile long padding13 = 0L;
        private volatile long padding14 = 0L;
        private volatile long padding15 = 0L;
        private volatile long padding16 = 0L;
        private volatile long time = 0L;
        private volatile long padding21 = 0L;
        private volatile long padding22 = 0L;
        private volatile long padding23 = 0L;
        private volatile long padding24 = 0L;
        private volatile long padding25 = 0L;
        private volatile long padding26 = 0L;
        private volatile long padding27 = 0L;
        private volatile boolean running = false;
        private Thread thread = null;

        public long now() {
            return this.time;
        }

        public void startTimeUpdateLoop() throws InterruptedException {
            assert (this.thread == null);
            assert (this.preventOptimizePadding() == 0L);
            this.running = true;
            CountDownLatch started = new CountDownLatch(1);
            this.thread = new Thread(() -> {
                started.countDown();
                while (this.running) {
                    this.time = System.nanoTime();
                    Thread.yield();
                }
            }, "LocalTimer");
            this.thread.setDaemon(true);
            this.thread.start();
            started.await();
        }

        public void stop() throws InterruptedException {
            this.running = false;
            if (this.thread != null) {
                this.thread.join();
            }
        }

        public long preventOptimizePadding() {
            long p1 = this.padding11 + this.padding12 + this.padding13 + this.padding14 + this.padding15 + this.padding16;
            long p2 = this.padding21 + this.padding22 + this.padding23 + this.padding24 + this.padding25 + this.padding26 + this.padding27;
            return p1 + p2;
        }
    }
}

