/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.seqfile;

import java.io.File;
import java.io.IOException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.store.file.seqfile.BitsFileReader;
import org.apache.hugegraph.computer.core.store.file.seqfile.ValueFileInput;

public class BitsFileReaderImpl
implements BitsFileReader {
    private static final int BUFFER_BITS = 64;
    private final ValueFileInput input;
    private boolean closed;
    private long byteBuffer;
    private int cursor;

    public BitsFileReaderImpl(Config config, String path) throws IOException {
        this(config, new File(path));
    }

    public BitsFileReaderImpl(Config config, File file) throws IOException {
        this.input = new ValueFileInput(config, file);
        this.closed = false;
        this.byteBuffer = this.input.readLong();
        this.cursor = 0;
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.cursor >= 64) {
            this.byteBuffer = this.input.readLong();
            this.cursor = 0;
        }
        return (this.byteBuffer >> this.cursor++ & 1L) == 1L;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.input.close();
    }
}

