/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BufferedFileInput;
import org.apache.hugegraph.computer.core.io.BufferedFileOutput;
import org.apache.hugegraph.computer.core.io.BufferedStreamInput;
import org.apache.hugegraph.computer.core.io.BufferedStreamOutput;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.CsvStructGraphOutput;
import org.apache.hugegraph.computer.core.io.GraphOutput;
import org.apache.hugegraph.computer.core.io.JsonStructGraphOutput;
import org.apache.hugegraph.computer.core.io.OptimizedBytesInput;
import org.apache.hugegraph.computer.core.io.OptimizedBytesOutput;
import org.apache.hugegraph.computer.core.io.OutputFormat;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.StreamGraphOutput;
import org.apache.hugegraph.computer.core.io.StructRandomAccessOutput;
import org.apache.hugegraph.computer.core.store.entry.EntryOutputImpl;

public final class IOFactory {
    public static BytesOutput createBytesOutput(int size) {
        return new OptimizedBytesOutput(size);
    }

    public static BytesInput createBytesInput(byte[] buffer) {
        return new OptimizedBytesInput(buffer);
    }

    public static BytesInput createBytesInput(byte[] buffer, int limit) {
        return new OptimizedBytesInput(buffer, limit);
    }

    public static BytesInput createBytesInput(byte[] buffer, int position, int limit) {
        return new OptimizedBytesInput(buffer, position, limit);
    }

    public static RandomAccessOutput createFileOutput(File file) throws IOException {
        return new OptimizedBytesOutput(new BufferedFileOutput(file));
    }

    public static RandomAccessInput createFileInput(File file) throws IOException {
        return new OptimizedBytesInput(new BufferedFileInput(file));
    }

    public static RandomAccessOutput createStreamOutput(OutputStream stream) throws IOException {
        return new OptimizedBytesOutput(new BufferedStreamOutput(stream));
    }

    public static RandomAccessInput createStreamInput(InputStream stream) throws IOException {
        return new OptimizedBytesInput(new BufferedStreamInput(stream));
    }

    public static GraphOutput createGraphOutput(ComputerContext context, OutputFormat format, RandomAccessOutput out) {
        switch (format) {
            case BIN: {
                EntryOutputImpl entryOutput = new EntryOutputImpl(out);
                return new StreamGraphOutput(context, entryOutput);
            }
            case CSV: {
                StructRandomAccessOutput srao = new StructRandomAccessOutput(out);
                return new CsvStructGraphOutput(context, srao);
            }
            case JSON: {
                StructRandomAccessOutput srao = new StructRandomAccessOutput(out);
                return new JsonStructGraphOutput(context, srao);
            }
        }
        throw new ComputerException("Can't create GraphOutput for %s", new Object[]{format});
    }
}

