/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConsulUtils {
    private static final Pattern META_KEY_PATTERN = Pattern.compile("[a-zA-Z0-9\\-_]+");

    public static boolean isValidMetaKey(String key) {
        return META_KEY_PATTERN.matcher(key).matches();
    }

    public static String buildServiceName(AbstractInterfaceConfig config) {
        String consulServiceName = config.getParameter("consulServiceName");
        if (consulServiceName != null) {
            return consulServiceName;
        }
        return config.getInterfaceId();
    }

    public static List<String> buildServiceIds(ProviderConfig<?> config) {
        List<ServerConfig> servers = config.getServer();
        if (CommonUtils.isEmpty(servers)) {
            return Collections.emptyList();
        }
        return servers.stream().map(server -> ConsulUtils.buildServiceId(config, server)).collect(Collectors.toList());
    }

    public static String buildServiceId(ProviderConfig config, ServerConfig server) {
        return String.join((CharSequence)"-", RegistryUtils.buildUniqueName(config, server.getProtocol()), RegistryUtils.getServerHost(server), String.valueOf(server.getPort()));
    }
}

