/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.BitInput;
import com.github.jinahya.bit.io.BitIoConstraints;
import java.io.IOException;

public abstract class AbstractBitInput
implements BitInput {
    int octet;
    int available;
    long count;

    protected abstract int read() throws IOException;

    protected int unsigned8(int size) throws IOException {
        int required;
        BitIoConstraints.requireValidSizeUnsigned8(size);
        if (this.available == 0) {
            this.octet = this.read();
            ++this.count;
            this.available = 8;
        }
        if ((required = size - this.available) > 0) {
            return this.unsigned8(this.available) << required | this.unsigned8(required);
        }
        return this.octet >> (this.available -= size) & (1 << size) - 1;
    }

    protected int unsigned16(int size) throws IOException {
        BitIoConstraints.requireValidSizeUnsigned16(size);
        int value = 0;
        int quotient = size / 8;
        for (int i = 0; i < quotient; ++i) {
            value <<= 8;
            value |= this.unsigned8(8);
        }
        int remainder = size % 8;
        if (remainder > 0) {
            value <<= remainder;
            value |= this.unsigned8(remainder);
        }
        return value;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readInt(true, 1) == 1;
    }

    @Override
    public byte readByte(boolean unsigned, int size) throws IOException {
        return (byte)this.readInt(unsigned, BitIoConstraints.requireValidSizeByte(unsigned, size));
    }

    @Override
    public short readShort(boolean unsigned, int size) throws IOException {
        return (short)this.readInt(unsigned, BitIoConstraints.requireValidSizeShort(unsigned, size));
    }

    @Override
    public int readInt(boolean unsigned, int size) throws IOException {
        BitIoConstraints.requireValidSizeInt(unsigned, size);
        if (!unsigned) {
            int value = 0 - this.readInt(true, 1);
            int usize = size - 1;
            if (usize > 0) {
                value <<= usize;
                value |= this.readInt(true, usize);
            }
            return value;
        }
        int value = 0;
        int quotient = size / 16;
        for (int i = 0; i < quotient; ++i) {
            value <<= 16;
            value |= this.unsigned16(16);
        }
        int remainder = size % 16;
        if (remainder > 0) {
            value <<= remainder;
            value |= this.unsigned16(remainder);
        }
        return value;
    }

    @Override
    public long readLong(boolean unsigned, int size) throws IOException {
        BitIoConstraints.requireValidSizeLong(unsigned, size);
        if (!unsigned) {
            long value = 0L - this.readLong(true, 1);
            int usize = size - 1;
            if (usize > 0) {
                value <<= usize;
                value |= this.readLong(true, usize);
            }
            return value;
        }
        long value = 0L;
        int quotient = size / 32;
        for (int i = 0; i < quotient; ++i) {
            value <<= 32;
            value |= (long)this.readInt(false, 32) & 0xFFFFFFFFL;
        }
        int remainder = size % 32;
        if (remainder > 0) {
            value <<= remainder;
            value |= (long)this.readInt(true, remainder);
        }
        return value;
    }

    @Override
    public char readChar(int size) throws IOException {
        return (char)this.readInt(true, BitIoConstraints.requireValidSizeChar(size));
    }

    @Override
    public long align(int bytes) throws IOException {
        if (bytes <= 0) {
            throw new IllegalArgumentException("bytes(" + bytes + ") <= 0");
        }
        long bits = 0L;
        if (this.available > 0) {
            bits += (long)this.available;
            this.readInt(true, this.available);
        }
        while (this.count % (long)bytes > 0L) {
            this.readInt(true, 8);
            bits += 8L;
        }
        return bits;
    }
}

