/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.s7.readwrite.TPKTPacket;
import org.apache.plc4x.java.s7.readwrite.configuration.S7Configuration;
import org.apache.plc4x.java.s7.readwrite.configuration.S7TcpTransportConfiguration;
import org.apache.plc4x.java.s7.readwrite.protocol.S7HPlcConnection;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7HGeneratedDriverBase
extends GeneratedDriverBase<TPKTPacket> {
    private static final Logger logger = LoggerFactory.getLogger(S7HGeneratedDriverBase.class);
    private static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>[a-z0-9\\-]*)(:(?<transportCode>[a-z0-9]*))?://(?<transportConfig>[^?^/]*)(\\?(?<paramString>.*))?");
    private static final Pattern URI_H_PATTERN = Pattern.compile("^(?<protocolCode>[a-z0-9\\-]*)(:(?<transportCode>[a-z0-9]*))?://(?<transportConfig>[^?]*)/(?<transportConfig2>[^?]*)\\?(?<paramString>.*)?");

    public PlcConnection getConnection(String connectionString) throws PlcConnectionException {
        ConfigurationFactory configurationFactory = new ConfigurationFactory();
        Matcher smatcher = URI_PATTERN.matcher(connectionString);
        Matcher hmatcher = URI_H_PATTERN.matcher(connectionString);
        if (!smatcher.matches() && !hmatcher.matches()) {
            throw new PlcConnectionException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-address}(?{parameter-string)?'");
        }
        Matcher matcher = smatcher.matches() ? smatcher : hmatcher;
        String protocolCode = matcher.group("protocolCode");
        String transportCode = matcher.group("transportCode") != null ? matcher.group("transportCode") : this.getDefaultTransportCode().get();
        String transportConfig = matcher.group("transportConfig");
        String transportConfig2 = hmatcher.matches() ? matcher.group("transportConfig2") : null;
        String paramString = matcher.group("paramString");
        if (!protocolCode.equals(this.getProtocolCode())) {
            throw new PlcConnectionException("This driver is not suited to handle this connection string");
        }
        PlcConnectionConfiguration configuration = configurationFactory.createConfiguration(this.getConfigurationClass(), protocolCode, transportCode, transportConfig, paramString);
        if (configuration == null) {
            throw new PlcConnectionException("Unsupported configuration");
        }
        Transport transport = null;
        ServiceLoader<Transport> transportLoader = ServiceLoader.load(Transport.class, Thread.currentThread().getContextClassLoader());
        for (Transport curTransport : transportLoader) {
            if (!curTransport.getTransportCode().equals(transportCode)) continue;
            transport = curTransport;
            break;
        }
        if (transport == null) {
            throw new PlcConnectionException("Unsupported transport " + transportCode);
        }
        Class<? extends PlcTransportConfiguration> transportConfigurationType = transport.getTransportConfigType();
        if (this.getTransportConfigurationClass(transportCode).isPresent()) {
            transportConfigurationType = this.getTransportConfigurationClass(transportCode).get();
        }
        PlcTransportConfiguration transportConfiguration = configurationFactory.createTransportConfiguration(transportConfigurationType, protocolCode, transportCode, transportConfig, paramString);
        ConfigurationFactory.configure((PlcConfiguration)transportConfiguration, (Object)transport);
        ChannelFactory channelFactory = transport.createChannelFactory(transportConfig);
        if (channelFactory == null) {
            throw new PlcConnectionException("Unable to get channel factory from url " + transportConfig);
        }
        ConfigurationFactory.configure((PlcConfiguration)configuration, (Object)channelFactory);
        ChannelFactory secondaryChannelFactory = null;
        if (hmatcher.matches() && (secondaryChannelFactory = transport.createChannelFactory(transportConfig2)) == null) {
            logger.info("Unable to get channel factory from url " + transportConfig2);
        }
        if (hmatcher.matches() && secondaryChannelFactory != null) {
            ConfigurationFactory.configure((PlcConfiguration)configuration, (Object)secondaryChannelFactory);
        }
        this.initializePipeline(channelFactory);
        if (hmatcher.matches()) {
            this.initializePipeline(secondaryChannelFactory);
        }
        boolean awaitSetupComplete = this.awaitSetupComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE") != null) {
            awaitSetupComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE"));
        }
        boolean awaitDisconnectComplete = this.awaitDisconnectComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE") != null) {
            awaitDisconnectComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE"));
        }
        boolean awaitDiscoverComplete = this.awaitDiscoverComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE") != null) {
            awaitDiscoverComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE"));
        }
        return new S7HPlcConnection(this.canPing(), this.canRead(), this.canWrite(), this.canSubscribe(), this.canBrowse(), this.getTagHandler(), this.getValueHandler(), configuration, channelFactory, secondaryChannelFactory, false, awaitSetupComplete, awaitDisconnectComplete, awaitDiscoverComplete, (ProtocolStackConfigurer<TPKTPacket>)this.getStackConfigurer(transport), this.getOptimizer(), this.getAuthentication());
    }

    protected PlcTagHandler getTagHandler() {
        throw new UnsupportedOperationException("getTagHandler, Not supported yet.");
    }

    protected PlcValueHandler getValueHandler() {
        throw new UnsupportedOperationException("getValueHandler, Not supported yet.");
    }

    protected ProtocolStackConfigurer<TPKTPacket> getStackConfigurer() {
        throw new UnsupportedOperationException("getStackConfigurer, Not supported yet.");
    }

    public String getProtocolCode() {
        throw new UnsupportedOperationException("getProtocolCode, Not supported yet.");
    }

    public String getProtocolName() {
        throw new UnsupportedOperationException("getProtocolName, Not supported yet.");
    }

    public PlcAuthentication getAuthentication() {
        return null;
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return S7Configuration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(S7TcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }
}

