/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.util.List;
import java.util.Objects;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.Lists;

@Evolving
public interface MetadataObjectChange {
    public static MetadataObjectChange rename(MetadataObject metadataObject, MetadataObject newMetadataObject, List<String> locations) {
        return new RenameMetadataObject(metadataObject, newMetadataObject, locations);
    }

    public static MetadataObjectChange remove(MetadataObject metadataObject, List<String> locations) {
        return new RemoveMetadataObject(metadataObject, locations);
    }

    public static final class RemoveMetadataObject
    implements MetadataObjectChange {
        private final MetadataObject metadataObject;
        private final List<String> locations;

        private RemoveMetadataObject(MetadataObject metadataObject, List<String> locations) {
            this.metadataObject = metadataObject;
            this.locations = locations;
        }

        public MetadataObject metadataObject() {
            return this.metadataObject;
        }

        public List<String> getLocations() {
            return this.locations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameMetadataObject that = (RenameMetadataObject)o;
            return this.metadataObject.equals(that.metadataObject);
        }

        public int hashCode() {
            return Objects.hash(this.metadataObject);
        }

        public String toString() {
            return "REMOVEMETADATAOBJECT " + this.metadataObject;
        }
    }

    public static final class RenameMetadataObject
    implements MetadataObjectChange {
        private final MetadataObject metadataObject;
        private final MetadataObject newMetadataObject;
        private final List<String> locations;

        private RenameMetadataObject(MetadataObject metadataObject, MetadataObject newMetadataObject) {
            this(metadataObject, newMetadataObject, null);
        }

        private RenameMetadataObject(MetadataObject metadataObject, MetadataObject newMetadataObject, List<String> locations) {
            Preconditions.checkArgument(!metadataObject.fullName().equals(newMetadataObject.fullName()), "The metadata object must be different!");
            Preconditions.checkArgument(metadataObject.type().equals((Object)newMetadataObject.type()), "The metadata object type must be same!");
            this.metadataObject = metadataObject;
            this.newMetadataObject = newMetadataObject;
            if (locations != null) {
                this.locations = Lists.newArrayList(locations);
                this.locations.sort(String::compareTo);
            } else {
                this.locations = null;
            }
        }

        public MetadataObject metadataObject() {
            return this.metadataObject;
        }

        public MetadataObject newMetadataObject() {
            return this.newMetadataObject;
        }

        public List<String> locations() {
            return this.locations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameMetadataObject that = (RenameMetadataObject)o;
            return this.metadataObject.equals(that.metadataObject) && this.newMetadataObject.equals(that.newMetadataObject) && this.locations.equals(that.locations);
        }

        public int hashCode() {
            return Objects.hash(this.metadataObject, this.newMetadataObject);
        }

        public String toString() {
            return "RENAMEMETADATAOBJECT " + this.metadataObject + " " + this.newMetadataObject;
        }
    }
}

