/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.trino.spi.connector.SortOrder;
import java.util.Locale;
import java.util.Objects;

@Immutable
public class SortingColumn {
    private final String columnName;
    private final Order order;

    @JsonCreator
    public SortingColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="order") Order order) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.order = Objects.requireNonNull(order, "order is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Order getOrder() {
        return this.order;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("order", (Object)this.order).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortingColumn)) {
            return false;
        }
        SortingColumn that = (SortingColumn)o;
        return Objects.equals(this.columnName, that.columnName) && this.order == that.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.order});
    }

    public static String sortingColumnToString(SortingColumn column) {
        return column.getColumnName() + (column.getOrder() == Order.DESCENDING ? " DESC" : "");
    }

    public static SortingColumn sortingColumnFromString(String name) {
        Order order = Order.ASCENDING;
        String lower = name.toUpperCase(Locale.ENGLISH);
        if (lower.endsWith(" ASC")) {
            name = name.substring(0, name.length() - 4).trim();
        } else if (lower.endsWith(" DESC")) {
            name = name.substring(0, name.length() - 5).trim();
            order = Order.DESCENDING;
        }
        return new SortingColumn(name, order);
    }

    public static enum Order {
        ASCENDING(SortOrder.ASC_NULLS_FIRST, 1),
        DESCENDING(SortOrder.DESC_NULLS_LAST, 0);

        private final SortOrder sortOrder;
        private final int hiveOrder;

        private Order(SortOrder sortOrder, int hiveOrder) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
            this.hiveOrder = hiveOrder;
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public int getHiveOrder() {
            return this.hiveOrder;
        }
    }
}

