/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.property;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertyConverter {
    protected static final String TRINO_PROPERTIES_PREFIX = "trino.bypass.";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyConverter.class);

    public abstract Map<String, String> engineToGravitinoMapping();

    Map<String, String> reverseMap(Map<String, String> map) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            res.put(entry.getValue(), entry.getKey());
        }
        return res;
    }

    public Map<String, String> gravitinoToEngineProperties(Map<String, String> gravitinoProperties) {
        HashMap<String, String> engineProperties = new HashMap<String, String>();
        Map<String, String> gravitinoToEngineMapping = this.reverseMap(this.engineToGravitinoMapping());
        for (Map.Entry<String, String> entry : gravitinoProperties.entrySet()) {
            String engineKey = gravitinoToEngineMapping.get(entry.getKey());
            if (engineKey != null) {
                engineProperties.put(engineKey, entry.getValue());
                continue;
            }
            LOG.info("Property {} is not supported by engine", (Object)entry.getKey());
        }
        return engineProperties;
    }

    public Map<String, Object> engineToGravitinoProperties(Map<String, Object> engineProperties) {
        HashMap<String, Object> gravitinoProperties = new HashMap<String, Object>();
        Map<String, String> engineToGravitinoMapping = this.engineToGravitinoMapping();
        for (Map.Entry<String, Object> entry : engineProperties.entrySet()) {
            String gravitinoKey = engineToGravitinoMapping.get(entry.getKey());
            if (gravitinoKey != null) {
                gravitinoProperties.put(gravitinoKey, entry.getValue());
                continue;
            }
            LOG.info("Property {} is not supported by Gravitino", (Object)entry.getKey());
        }
        return gravitinoProperties;
    }
}

