/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.SupportsMetalakes;
import org.apache.gravitino.client.AuthDataProvider;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GravitinoClientBase;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.dto.requests.MetalakeCreateRequest;
import org.apache.gravitino.dto.requests.MetalakeUpdateRequest;
import org.apache.gravitino.dto.requests.MetalakeUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.MetalakeListResponse;
import org.apache.gravitino.dto.responses.MetalakeResponse;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

public class GravitinoAdminClient
extends GravitinoClientBase
implements SupportsMetalakes {
    private GravitinoAdminClient(String uri, AuthDataProvider authDataProvider, boolean checkVersion, Map<String, String> headers) {
        super(uri, authDataProvider, checkVersion, headers);
    }

    public GravitinoMetalake[] listMetalakes() {
        MetalakeListResponse resp = this.restClient.get("api/metalakes", MetalakeListResponse.class, Collections.emptyMap(), ErrorHandlers.metalakeErrorHandler());
        resp.validate();
        return (GravitinoMetalake[])Arrays.stream(resp.getMetalakes()).map(o -> DTOConverters.toMetaLake(o, this.restClient)).toArray(GravitinoMetalake[]::new);
    }

    @Override
    public GravitinoMetalake createMetalake(String name, String comment, Map<String, String> properties) throws MetalakeAlreadyExistsException {
        this.checkMetalakeName(name);
        MetalakeCreateRequest req = new MetalakeCreateRequest(name, comment, properties);
        req.validate();
        MetalakeResponse resp = this.restClient.post("api/metalakes", (RESTRequest)req, MetalakeResponse.class, Collections.emptyMap(), ErrorHandlers.metalakeErrorHandler());
        resp.validate();
        return DTOConverters.toMetaLake(resp.getMetalake(), this.restClient);
    }

    @Override
    public GravitinoMetalake alterMetalake(String name, MetalakeChange ... changes) throws NoSuchMetalakeException, IllegalArgumentException {
        this.checkMetalakeName(name);
        List<MetalakeUpdateRequest> reqs = Arrays.stream(changes).map(DTOConverters::toMetalakeUpdateRequest).collect(Collectors.toList());
        MetalakeUpdatesRequest updatesRequest = new MetalakeUpdatesRequest(reqs);
        updatesRequest.validate();
        MetalakeResponse resp = this.restClient.put("api/metalakes/" + name, (RESTRequest)updatesRequest, MetalakeResponse.class, Collections.emptyMap(), ErrorHandlers.metalakeErrorHandler());
        resp.validate();
        return DTOConverters.toMetaLake(resp.getMetalake(), this.restClient);
    }

    @Override
    public boolean dropMetalake(String name) {
        this.checkMetalakeName(name);
        DropResponse resp = this.restClient.delete("api/metalakes/" + name, DropResponse.class, Collections.emptyMap(), ErrorHandlers.metalakeErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public static AdminClientBuilder builder(String uri) {
        return new AdminClientBuilder(uri);
    }

    public static class AdminClientBuilder
    extends GravitinoClientBase.Builder<GravitinoAdminClient> {
        protected AdminClientBuilder(String uri) {
            super(uri);
        }

        @Override
        public GravitinoAdminClient build() {
            Preconditions.checkArgument(this.uri != null && !this.uri.isEmpty(), "The argument 'uri' must be a valid URI");
            return new GravitinoAdminClient(this.uri, this.authDataProvider, this.checkVersion, this.headers);
        }
    }
}

