/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.MissingColumnException;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.exceptions.NoTableManagedException;
import org.datanucleus.store.rdbms.exceptions.NotATableException;
import org.datanucleus.store.rdbms.exceptions.UnexpectedColumnException;
import org.datanucleus.store.rdbms.exceptions.WrongPrimaryKeyException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.IndexInfo;
import org.datanucleus.store.rdbms.schema.PrimaryKeyInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.schema.RDBMSTableFKInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableIndexInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTablePKInfo;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class TableImpl
extends AbstractTable {
    public TableImpl(DatastoreIdentifier name, RDBMSStoreManager storeMgr) {
        super(name, storeMgr);
    }

    @Override
    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
    }

    @Override
    public void postInitialize(ClassLoaderResolver clr) {
        this.assertIsInitialized();
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKey pk = new PrimaryKey(this);
        for (Column col : this.columns) {
            if (!col.isPrimaryKey()) continue;
            pk.addColumn(col);
        }
        return pk;
    }

    @Override
    public boolean validate(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        this.assertIsInitialized();
        RDBMSSchemaHandler handler = (RDBMSSchemaHandler)this.storeMgr.getSchemaHandler();
        String tableType = handler.getTableType(conn, this);
        if (tableType == null) {
            throw new MissingTableException(this.getCatalogName(), this.getSchemaName(), this.toString());
        }
        if (!tableType.equals("TABLE")) {
            throw new NotATableException(this.toString(), tableType);
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"057032", (Object[])new Object[]{this}));
        }
        this.validateColumns(conn, validateColumnStructure, autoCreate, autoCreateErrors);
        try {
            this.validatePrimaryKey(conn);
        }
        catch (WrongPrimaryKeyException wpke) {
            if (autoCreateErrors != null) {
                autoCreateErrors.add(wpke);
            }
            throw wpke;
        }
        this.state = 4;
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"045000", (long)(System.currentTimeMillis() - startTime)));
        }
        return false;
    }

    public boolean validateColumns(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        HashMap unvalidated = new HashMap(this.columnsByIdentifier);
        List tableColInfo = this.storeMgr.getColumnInfoForTable(this, conn);
        for (RDBMSColumnInfo ci : tableColInfo) {
            DatastoreIdentifier colIdentifier = this.storeMgr.getIdentifierFactory().newColumnIdentifier(ci.getColumnName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(String.class), null, true);
            Column col = (Column)unvalidated.get(colIdentifier);
            if (col == null) continue;
            if (validateColumnStructure) {
                col.initializeColumnInfoFromDatastore(ci);
                col.validate(ci);
                unvalidated.remove(colIdentifier);
                continue;
            }
            unvalidated.remove(colIdentifier);
        }
        if (unvalidated.size() > 0) {
            if (autoCreate) {
                ArrayList<String> stmts = new ArrayList<String>();
                Set columnKeys = unvalidated.entrySet();
                for (Map.Entry entry : columnKeys) {
                    Column col = (Column)entry.getValue();
                    String addColStmt = this.dba.getAddColumnStatement(this, col);
                    stmts.add(addColStmt);
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"057031", (Object[])new Object[]{col.getIdentifier(), this.toString()}));
                }
                try {
                    this.executeDdlStatementList(stmts, conn);
                }
                catch (SQLException sqle) {
                    if (autoCreateErrors != null) {
                        autoCreateErrors.add(sqle);
                    }
                    throw sqle;
                }
                this.storeMgr.invalidateColumnInfoForTable(this);
            } else {
                MissingColumnException mce = new MissingColumnException(this, unvalidated.values());
                if (autoCreateErrors != null) {
                    autoCreateErrors.add(mce);
                } else {
                    throw mce;
                }
            }
        }
        this.state = 4;
        return true;
    }

    public void initializeColumnInfoForPrimaryKeyColumns(Connection conn) throws SQLException {
        for (Column col : this.columnsByIdentifier.values()) {
            RDBMSColumnInfo ci;
            if (!col.isPrimaryKey() || (ci = this.storeMgr.getColumnInfoForColumnName(this, conn, col.getIdentifier())) == null) continue;
            col.initializeColumnInfoFromDatastore(ci);
        }
    }

    public void initializeColumnInfoFromDatastore(Connection conn) throws SQLException {
        HashMap columns = new HashMap(this.columnsByIdentifier);
        for (RDBMSColumnInfo ci : this.storeMgr.getColumnInfoForTable(this, conn)) {
            DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, ci.getColumnName());
            Column col = (Column)columns.get(colName);
            if (col == null) continue;
            col.initializeColumnInfoFromDatastore(ci);
        }
    }

    protected boolean validatePrimaryKey(Connection conn) throws SQLException {
        Map actualPKs = this.getExistingPrimaryKeys(conn);
        PrimaryKey expectedPK = this.getPrimaryKey();
        if (expectedPK.size() == 0 ? !actualPKs.isEmpty() : actualPKs.size() != 1 || !actualPKs.values().contains(expectedPK)) {
            throw new WrongPrimaryKeyException(this.toString(), expectedPK.toString(), StringUtils.collectionToString(actualPKs.values()));
        }
        return true;
    }

    public boolean validateConstraints(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean cksWereModified;
        boolean fksWereModified;
        boolean idxsWereModified;
        this.assertIsInitialized();
        if (this.dba.supportsOption("CreateIndexesBeforeForeignKeys")) {
            idxsWereModified = this.validateIndices(conn, autoCreate, autoCreateErrors, clr);
            fksWereModified = this.validateForeignKeys(conn, autoCreate, autoCreateErrors, clr);
            cksWereModified = this.validateCandidateKeys(conn, autoCreate, autoCreateErrors);
        } else {
            cksWereModified = this.validateCandidateKeys(conn, autoCreate, autoCreateErrors);
            fksWereModified = this.validateForeignKeys(conn, autoCreate, autoCreateErrors, clr);
            idxsWereModified = this.validateIndices(conn, autoCreate, autoCreateErrors, clr);
        }
        return fksWereModified || idxsWereModified || cksWereModified;
    }

    public boolean createConstraints(Connection conn, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean cksWereModified;
        boolean fksWereModified;
        boolean idxsWereModified;
        this.assertIsInitialized();
        if (this.dba.supportsOption("CreateIndexesBeforeForeignKeys")) {
            idxsWereModified = this.createIndices(conn, autoCreateErrors, clr, Collections.EMPTY_MAP);
            fksWereModified = this.createForeignKeys(conn, autoCreateErrors, clr, Collections.EMPTY_MAP);
            cksWereModified = this.createCandidateKeys(conn, autoCreateErrors, Collections.EMPTY_MAP);
        } else {
            cksWereModified = this.createCandidateKeys(conn, autoCreateErrors, Collections.EMPTY_MAP);
            fksWereModified = this.createForeignKeys(conn, autoCreateErrors, clr, Collections.EMPTY_MAP);
            idxsWereModified = this.createIndices(conn, autoCreateErrors, clr, Collections.EMPTY_MAP);
        }
        return fksWereModified || idxsWereModified || cksWereModified;
    }

    private boolean validateForeignKeys(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean dbWasModified = false;
        Map actualForeignKeysByName = null;
        int numActualFKs = 0;
        if (this.storeMgr.getCompleteDDL()) {
            actualForeignKeysByName = new HashMap();
        } else {
            actualForeignKeysByName = this.getExistingForeignKeys(conn);
            numActualFKs = actualForeignKeysByName.size();
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058103", (Object[])new Object[]{"" + numActualFKs, this}));
            }
        }
        if (autoCreate) {
            dbWasModified = this.createForeignKeys(conn, autoCreateErrors, clr, actualForeignKeysByName);
        } else {
            Map stmtsByFKName = this.getSQLAddFKStatements(actualForeignKeysByName, clr);
            if (stmtsByFKName.isEmpty()) {
                if (numActualFKs > 0 && NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058104", (Object[])new Object[]{"" + numActualFKs, this}));
                }
            } else {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"058101", (Object[])new Object[]{this, stmtsByFKName.values()}));
            }
        }
        return dbWasModified;
    }

    /*
     * Exception decompiling
     */
    private boolean createForeignKeys(Connection conn, Collection autoCreateErrors, ClassLoaderResolver clr, Map actualForeignKeysByName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validateIndices(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean dbWasModified = false;
        Map actualIndicesByName = null;
        int numActualIdxs = 0;
        if (this.storeMgr.getCompleteDDL()) {
            actualIndicesByName = new HashMap();
        } else {
            actualIndicesByName = this.getExistingIndices(conn);
            for (Map.Entry entry : actualIndicesByName.entrySet()) {
                Index idx = (Index)entry.getValue();
                if (!idx.getTable().getIdentifier().toString().equals(this.identifier.toString())) continue;
                ++numActualIdxs;
            }
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058004", (Object[])new Object[]{"" + numActualIdxs, this}));
            }
        }
        if (autoCreate) {
            dbWasModified = this.createIndices(conn, autoCreateErrors, clr, actualIndicesByName);
        } else {
            Map stmtsByIdxName = this.getSQLCreateIndexStatements(actualIndicesByName, clr);
            if (stmtsByIdxName.isEmpty()) {
                if (numActualIdxs > 0 && NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058005", (Object[])new Object[]{"" + numActualIdxs, this}));
                }
            } else {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"058003", (Object[])new Object[]{this, stmtsByIdxName.values()}));
            }
        }
        return dbWasModified;
    }

    /*
     * Exception decompiling
     */
    private boolean createIndices(Connection conn, Collection autoCreateErrors, ClassLoaderResolver clr, Map actualIndicesByName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validateCandidateKeys(Connection conn, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        boolean dbWasModified = false;
        Map actualCandidateKeysByName = null;
        int numActualCKs = 0;
        if (this.storeMgr.getCompleteDDL()) {
            actualCandidateKeysByName = new HashMap();
        } else {
            actualCandidateKeysByName = this.getExistingCandidateKeys(conn);
            numActualCKs = actualCandidateKeysByName.size();
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058204", (Object[])new Object[]{"" + numActualCKs, this}));
            }
        }
        if (autoCreate) {
            dbWasModified = this.createCandidateKeys(conn, autoCreateErrors, actualCandidateKeysByName);
        } else {
            Map stmtsByCKName = this.getSQLAddCandidateKeyStatements(actualCandidateKeysByName);
            if (stmtsByCKName.isEmpty()) {
                if (numActualCKs > 0 && NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058205", (Object[])new Object[]{"" + numActualCKs, this}));
                }
            } else {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"058201", (Object[])new Object[]{this, stmtsByCKName.values()}));
            }
        }
        return dbWasModified;
    }

    /*
     * Exception decompiling
     */
    private boolean createCandidateKeys(Connection conn, Collection autoCreateErrors, Map actualCandidateKeysByName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConstraints(Connection conn) throws SQLException {
        this.assertIsInitialized();
        boolean drop_using_constraint = this.dba.supportsOption("AlterTableDropConstraint_Syntax");
        boolean drop_using_foreign_key = this.dba.supportsOption("AlterTableDropForeignKey_Syntax");
        if (!drop_using_constraint && !drop_using_foreign_key) {
            return;
        }
        HashSet<String> fkNames = new HashSet<String>();
        StoreSchemaHandler handler = this.storeMgr.getSchemaHandler();
        RDBMSTableFKInfo fkInfo = (RDBMSTableFKInfo)handler.getSchemaData((Object)conn, "foreign-keys", new Object[]{this});
        for (ForeignKeyInfo fki : fkInfo.getChildren()) {
            String fkName = (String)fki.getProperty("fk_name");
            if (fkName == null) continue;
            fkNames.add(fkName);
        }
        int numFKs = fkNames.size();
        if (numFKs > 0) {
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"058102", (Object[])new Object[]{"" + numFKs, this}));
            }
            Iterator iter = fkNames.iterator();
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            try (Statement stmt = conn.createStatement();){
                while (iter.hasNext()) {
                    String constraintName = (String)iter.next();
                    String stmtText = null;
                    stmtText = drop_using_constraint ? "ALTER TABLE " + this.toString() + " DROP CONSTRAINT " + idFactory.getIdentifierInAdapterCase(constraintName) : "ALTER TABLE " + this.toString() + " DROP FOREIGN KEY " + idFactory.getIdentifierInAdapterCase(constraintName);
                    this.executeDdlStatement(stmt, stmtText);
                }
            }
        }
    }

    public List<ForeignKey> getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashSet<Column> colsInFKs = new HashSet<Column>();
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        for (Column col : this.columns) {
            if (colsInFKs.contains(col)) continue;
            try {
                DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(col.getStoredJavaType(), clr);
                if (referencedTable == null) continue;
                for (int j = 0; j < col.getJavaTypeMapping().getNumberOfDatastoreMappings(); ++j) {
                    colsInFKs.add(col.getJavaTypeMapping().getDatastoreMapping(j).getColumn());
                }
                ForeignKey fk = new ForeignKey(col.getJavaTypeMapping(), this.dba, referencedTable, true);
                foreignKeys.add(fk);
            }
            catch (NoTableManagedException noTableManagedException) {}
        }
        return foreignKeys;
    }

    protected List<CandidateKey> getExpectedCandidateKeys() {
        this.assertIsInitialized();
        return new ArrayList<CandidateKey>();
    }

    protected Set<Index> getExpectedIndices(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashSet<Index> indices = new HashSet<Index>();
        PrimaryKey pk = this.getPrimaryKey();
        for (ForeignKey fk : this.getExpectedForeignKeys(clr)) {
            if (pk.getColumnList().equals(fk.getColumnList())) continue;
            indices.add(new Index(fk));
        }
        return indices;
    }

    private Map getExistingPrimaryKeys(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, PrimaryKey> primaryKeysByName = new HashMap<DatastoreIdentifier, PrimaryKey>();
        if (this.tableExistsInDatastore(conn)) {
            StoreSchemaHandler handler = this.storeMgr.getSchemaHandler();
            RDBMSTablePKInfo tablePkInfo = (RDBMSTablePKInfo)handler.getSchemaData((Object)conn, "primary-keys", new Object[]{this});
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            for (PrimaryKeyInfo pkInfo : tablePkInfo.getChildren()) {
                String pkName = (String)pkInfo.getProperty("pk_name");
                DatastoreIdentifier pkIdentifier = pkName == null ? idFactory.newPrimaryKeyIdentifier(this) : idFactory.newIdentifier(IdentifierType.COLUMN, pkName);
                PrimaryKey pk = (PrimaryKey)primaryKeysByName.get(pkIdentifier);
                if (pk == null) {
                    pk = new PrimaryKey(this);
                    pk.setName(pkIdentifier.getName());
                    primaryKeysByName.put(pkIdentifier, pk);
                }
                int keySeq = (Short)pkInfo.getProperty("key_seq") - 1;
                String colName = (String)pkInfo.getProperty("column_name");
                DatastoreIdentifier colIdentifier = idFactory.newIdentifier(IdentifierType.COLUMN, colName);
                Column col = (Column)this.columnsByIdentifier.get(colIdentifier);
                if (col == null) {
                    throw new UnexpectedColumnException(this.toString(), colIdentifier.getName(), this.getSchemaName(), this.getCatalogName());
                }
                pk.setColumn(keySeq, col);
            }
        }
        return primaryKeysByName;
    }

    private Map getExistingForeignKeys(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, ForeignKey> foreignKeysByName = new HashMap<DatastoreIdentifier, ForeignKey>();
        if (this.tableExistsInDatastore(conn)) {
            StoreSchemaHandler handler = this.storeMgr.getSchemaHandler();
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            RDBMSTableFKInfo tableFkInfo = (RDBMSTableFKInfo)handler.getSchemaData((Object)conn, "foreign-keys", new Object[]{this});
            for (ForeignKeyInfo fkInfo : tableFkInfo.getChildren()) {
                String pkTableName;
                DatastoreClass refTable;
                String fkName = (String)fkInfo.getProperty("fk_name");
                DatastoreIdentifier fkIdentifier = fkName == null ? idFactory.newForeignKeyIdentifier(this, foreignKeysByName.size()) : idFactory.newIdentifier(IdentifierType.FOREIGN_KEY, fkName);
                short deferrability = (Short)fkInfo.getProperty("deferrability");
                boolean initiallyDeferred = deferrability == 5;
                ForeignKey fk = (ForeignKey)foreignKeysByName.get(fkIdentifier);
                if (fk == null) {
                    fk = new ForeignKey(initiallyDeferred);
                    fk.setName(fkIdentifier.getName());
                    foreignKeysByName.put(fkIdentifier, fk);
                }
                if ((refTable = this.storeMgr.getDatastoreClass(idFactory.newTableIdentifier(pkTableName = (String)fkInfo.getProperty("pk_table_name")))) == null) continue;
                String fkColumnName = (String)fkInfo.getProperty("fk_column_name");
                String pkColumnName = (String)fkInfo.getProperty("pk_column_name");
                DatastoreIdentifier colName = idFactory.newIdentifier(IdentifierType.COLUMN, fkColumnName);
                DatastoreIdentifier refColName = idFactory.newIdentifier(IdentifierType.COLUMN, pkColumnName);
                Column col = (Column)this.columnsByIdentifier.get(colName);
                Column refCol = refTable.getColumn(refColName);
                if (col == null || refCol == null) continue;
                fk.addColumn(col, refCol);
            }
        }
        return foreignKeysByName;
    }

    private Map getExistingCandidateKeys(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, CandidateKey> candidateKeysByName = new HashMap<DatastoreIdentifier, CandidateKey>();
        if (this.tableExistsInDatastore(conn)) {
            StoreSchemaHandler handler = this.storeMgr.getSchemaHandler();
            RDBMSTableIndexInfo tableIndexInfo = (RDBMSTableIndexInfo)handler.getSchemaData((Object)conn, "indices", new Object[]{this});
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            for (IndexInfo indexInfo : tableIndexInfo.getChildren()) {
                short idxType;
                boolean isUnique = (Boolean)indexInfo.getProperty("non_unique") == false;
                if (!isUnique || (idxType = ((Short)indexInfo.getProperty("type")).shortValue()) == 0) continue;
                String keyName = (String)indexInfo.getProperty("index_name");
                DatastoreIdentifier idxName = idFactory.newIdentifier(IdentifierType.CANDIDATE_KEY, keyName);
                CandidateKey key = (CandidateKey)candidateKeysByName.get(idxName);
                if (key == null) {
                    key = new CandidateKey(this);
                    key.setName(keyName);
                    candidateKeysByName.put(idxName, key);
                }
                int colSeq = (Short)indexInfo.getProperty("ordinal_position") - 1;
                DatastoreIdentifier colName = idFactory.newIdentifier(IdentifierType.COLUMN, (String)indexInfo.getProperty("column_name"));
                Column col = (Column)this.columnsByIdentifier.get(colName);
                if (col == null) continue;
                key.setColumn(colSeq, col);
            }
        }
        return candidateKeysByName;
    }

    private Map getExistingIndices(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, Index> indicesByName = new HashMap<DatastoreIdentifier, Index>();
        if (this.tableExistsInDatastore(conn)) {
            StoreSchemaHandler handler = this.storeMgr.getSchemaHandler();
            RDBMSTableIndexInfo tableIndexInfo = (RDBMSTableIndexInfo)handler.getSchemaData((Object)conn, "indices", new Object[]{this});
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            for (IndexInfo indexInfo : tableIndexInfo.getChildren()) {
                short idxType = (Short)indexInfo.getProperty("type");
                if (idxType == 0) continue;
                String indexName = (String)indexInfo.getProperty("index_name");
                DatastoreIdentifier indexIdentifier = idFactory.newIdentifier(IdentifierType.CANDIDATE_KEY, indexName);
                Index idx = (Index)indicesByName.get(indexIdentifier);
                if (idx == null) {
                    boolean isUnique = (Boolean)indexInfo.getProperty("non_unique") == false;
                    idx = new Index(this, isUnique, null);
                    idx.setName(indexName);
                    indicesByName.put(indexIdentifier, idx);
                }
                int colSeq = (Short)indexInfo.getProperty("ordinal_position") - 1;
                DatastoreIdentifier colName = idFactory.newIdentifier(IdentifierType.COLUMN, (String)indexInfo.getProperty("column_name"));
                Column col = (Column)this.columnsByIdentifier.get(colName);
                if (col == null) continue;
                idx.setColumn(colSeq, col);
            }
        }
        return indicesByName;
    }

    @Override
    protected List getSQLCreateStatements(Properties props) {
        String pkStmt;
        Integer colPos;
        ColumnMetaData colmd;
        this.assertIsInitialized();
        Column[] cols = null;
        for (Column col : this.columns) {
            int index;
            colmd = col.getColumnMetaData();
            colPos = colmd != null ? colmd.getPosition() : null;
            if (colPos == null || (index = colPos.intValue()) >= this.columns.size() || index < 0) continue;
            if (cols == null) {
                cols = new Column[this.columns.size()];
            }
            if (cols[index] != null) {
                throw new NucleusUserException("Column index " + index + " has been specified multiple times : " + cols[index] + " and " + col);
            }
            cols[index] = col;
        }
        if (cols != null) {
            for (Column col : this.columns) {
                colmd = col.getColumnMetaData();
                colPos = colmd != null ? colmd.getPosition() : null;
                if (colPos != null) continue;
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != null) continue;
                    cols[i] = col;
                }
            }
        } else {
            cols = this.columns.toArray(new Column[this.columns.size()]);
        }
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getCreateTableStatement(this, cols, props, this.storeMgr.getIdentifierFactory()));
        PrimaryKey pk = this.getPrimaryKey();
        if (pk.size() > 0 && (pkStmt = this.dba.getAddPrimaryKeyStatement(pk, this.storeMgr.getIdentifierFactory())) != null) {
            stmts.add(pkStmt);
        }
        return stmts;
    }

    protected Map getSQLAddFKStatements(Map actualForeignKeysByName, ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashMap<String, String> stmtsByFKName = new HashMap<String, String>();
        List<ForeignKey> expectedForeignKeys = this.getExpectedForeignKeys(clr);
        Iterator<ForeignKey> i = expectedForeignKeys.iterator();
        int n = 1;
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        while (i.hasNext()) {
            String stmtText;
            ForeignKey fk = i.next();
            if (actualForeignKeysByName.containsValue(fk)) continue;
            if (fk.getName() == null) {
                DatastoreIdentifier fkName;
                while (actualForeignKeysByName.containsKey(fkName = idFactory.newForeignKeyIdentifier(this, n++))) {
                }
                fk.setName(fkName.getName());
            }
            if ((stmtText = this.dba.getAddForeignKeyStatement(fk, idFactory)) == null) continue;
            stmtsByFKName.put(fk.getName(), stmtText);
        }
        return stmtsByFKName;
    }

    protected Map getSQLAddCandidateKeyStatements(Map actualCandidateKeysByName) {
        this.assertIsInitialized();
        HashMap<String, String> stmtsByCKName = new HashMap<String, String>();
        List<CandidateKey> expectedCandidateKeys = this.getExpectedCandidateKeys();
        Iterator<CandidateKey> i = expectedCandidateKeys.iterator();
        int n = 1;
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        while (i.hasNext()) {
            String stmtText;
            CandidateKey ck = i.next();
            if (actualCandidateKeysByName.containsValue(ck)) continue;
            if (ck.getName() == null) {
                DatastoreIdentifier ckName;
                while (actualCandidateKeysByName.containsKey(ckName = idFactory.newCandidateKeyIdentifier(this, n++))) {
                }
                ck.setName(ckName.getName());
            }
            if ((stmtText = this.dba.getAddCandidateKeyStatement(ck, idFactory)) == null) continue;
            stmtsByCKName.put(ck.getName(), stmtText);
        }
        return stmtsByCKName;
    }

    private boolean isIndexReallyNeeded(Index requiredIdx, Collection actualIndices) {
        Iterator i = actualIndices.iterator();
        if (requiredIdx.getName() != null) {
            IdentifierFactory idFactory = requiredIdx.getTable().getStoreManager().getIdentifierFactory();
            String reqdName = idFactory.getIdentifierInAdapterCase(requiredIdx.getName());
            while (i.hasNext()) {
                Index actualIdx = (Index)i.next();
                String actualName = idFactory.getIdentifierInAdapterCase(actualIdx.getName());
                if (!actualName.equals(reqdName) || !actualIdx.getTable().getIdentifier().toString().equals(requiredIdx.getTable().getIdentifier().toString())) continue;
                return false;
            }
        } else {
            while (i.hasNext()) {
                Index actualIdx = (Index)i.next();
                if (!actualIdx.toString().equals(requiredIdx.toString()) || !actualIdx.getTable().getIdentifier().toString().equals(requiredIdx.getTable().getIdentifier().toString())) continue;
                return false;
            }
        }
        return true;
    }

    protected Map getSQLCreateIndexStatements(Map actualIndicesByName, ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashMap<String, String> stmtsByIdxName = new HashMap<String, String>();
        Set<Index> expectedIndices = this.getExpectedIndices(clr);
        int n = 1;
        Iterator<Index> indexIter = expectedIndices.iterator();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        while (indexIter.hasNext()) {
            Index idx = indexIter.next();
            if (!this.isIndexReallyNeeded(idx, actualIndicesByName.values())) continue;
            if (idx.getName() == null) {
                DatastoreIdentifier idxName;
                do {
                    idxName = idFactory.newIndexIdentifier(this, idx.getUnique(), n++);
                    idx.setName(idxName.getName());
                } while (actualIndicesByName.containsKey(idxName));
            }
            String stmtText = this.dba.getCreateIndexStatement(idx, idFactory);
            stmtsByIdxName.put(idx.getName(), stmtText);
        }
        return stmtsByIdxName;
    }

    @Override
    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getDropTableStatement(this));
        return stmts;
    }

    protected void logMapping(String memberName, JavaTypeMapping mapping) {
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            StringBuilder columnsStr = new StringBuilder();
            for (int i = 0; i < mapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    columnsStr.append(",");
                }
                columnsStr.append(mapping.getDatastoreMapping(i).getColumn());
            }
            if (mapping.getNumberOfDatastoreMappings() == 0) {
                columnsStr.append("[none]");
            }
            StringBuilder datastoreMappingTypes = new StringBuilder();
            for (int i = 0; i < mapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    datastoreMappingTypes.append(',');
                }
                datastoreMappingTypes.append(mapping.getDatastoreMapping(i).getClass().getName());
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"057010", (Object[])new Object[]{memberName, columnsStr.toString(), mapping.getClass().getName(), datastoreMappingTypes.toString()}));
        }
    }
}

