/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergPropertiesUtils;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.server.web.JettyServerConfig;
import org.apache.gravitino.server.web.OverwriteDefaultConfig;

public class IcebergConfig
extends Config
implements OverwriteDefaultConfig {
    public static final String ICEBERG_CONFIG_PREFIX = "gravitino.iceberg-rest.";
    public static final ConfigEntry<String> CATALOG_BACKEND = new ConfigBuilder("catalog-backend").doc("Catalog backend of Gravitino Iceberg catalog").version("0.2.0").stringConf().createWithDefault((Object)"memory");
    public static final ConfigEntry<String> CATALOG_WAREHOUSE = new ConfigBuilder("warehouse").doc("Warehouse directory of catalog").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> CATALOG_URI = new ConfigBuilder("uri").doc("The uri config of the Iceberg catalog").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_USER = new ConfigBuilder("jdbc-user").doc("The username of the Jdbc connection").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_PASSWORD = new ConfigBuilder("jdbc-password").doc("The password of the Jdbc connection").version("0.2.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> JDBC_DRIVER = new ConfigBuilder("jdbc-driver").doc("The driver of the Jdbc connection").version("0.3.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<Boolean> JDBC_INIT_TABLES = new ConfigBuilder("jdbc-initialize").doc("Whether to initialize meta tables when create Jdbc catalog").version("0.2.0").booleanConf().createWithDefault((Object)true);
    public static final ConfigEntry<String> IO_IMPL = new ConfigBuilder("io-impl").doc("The io implementation for `FileIO` in Iceberg").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> S3_ENDPOINT = new ConfigBuilder("s3-endpoint").doc("An alternative endpoint of the S3 service, This could be used to for S3FileIO with any s3-compatible object storage service that has a different endpoint, or access a private S3 endpoint in a virtual private cloud").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> S3_REGION = new ConfigBuilder("s3-region").doc("The region of the S3 service").version("0.6.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> S3_ACCESS_KEY_ID = new ConfigBuilder("s3-access-key-id").doc("The static access key ID used to access S3 data").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> S3_SECRET_ACCESS_KEY = new ConfigBuilder("s3-secret-access-key").doc("The static secret access key used to access S3 data").version("0.6.0").stringConf().create();
    public static final ConfigEntry<String> ICEBERG_METRICS_STORE = new ConfigBuilder("metricsStore").doc("The store to save Iceberg metrics").version("0.4.0").stringConf().create();
    public static final ConfigEntry<Integer> ICEBERG_METRICS_STORE_RETAIN_DAYS = new ConfigBuilder("metricsStoreRetainDays").doc("The retain days of Iceberg metrics, the value not greater than 0 means retain forever").version("0.4.0").intConf().createWithDefault((Object)-1);
    public static final ConfigEntry<Integer> ICEBERG_METRICS_QUEUE_CAPACITY = new ConfigBuilder("metricsQueueCapacity").doc("The capacity for Iceberg metrics queues, should greater than 0").version("0.4.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)1000);
    public static final ConfigEntry<String> CATALOG_BACKEND_NAME = new ConfigBuilder("catalog-backend-name").doc("The catalog name for Iceberg catalog backend").version("0.5.2").stringConf().create();

    public String getJdbcDriver() {
        return (String)this.get(JDBC_DRIVER);
    }

    public String getCatalogBackendName(String defaultCatalogBackendName) {
        return Optional.ofNullable((String)this.get(CATALOG_BACKEND_NAME)).orElse(defaultCatalogBackendName);
    }

    public IcebergConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public IcebergConfig() {
        super(false);
    }

    public Map<String, String> getIcebergCatalogProperties() {
        Map config = this.getAllConfig();
        Map transformedConfig = IcebergPropertiesUtils.toIcebergCatalogProperties((Map)config);
        transformedConfig.putAll(config);
        return transformedConfig;
    }

    public Map<String, String> getOverwriteDefaultConfig() {
        return ImmutableMap.of((Object)JettyServerConfig.WEBSERVER_HTTP_PORT.getKey(), (Object)String.valueOf(9001), (Object)JettyServerConfig.WEBSERVER_HTTPS_PORT.getKey(), (Object)String.valueOf(9433));
    }
}

