/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import org.apache.gravitino.Namespace;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.Fileset;
import org.apache.gravitino.proto.ProtoSerDe;

public class FilesetEntitySerDe
implements ProtoSerDe<FilesetEntity, Fileset> {
    @Override
    public Fileset serialize(FilesetEntity filesetEntity) {
        Fileset.Builder builder = Fileset.newBuilder().setId(filesetEntity.id().longValue()).setName(filesetEntity.name()).setStorageLocation(filesetEntity.storageLocation()).setAuditInfo(new AuditInfoSerDe().serialize(filesetEntity.auditInfo()));
        if (filesetEntity.comment() != null) {
            builder.setComment(filesetEntity.comment());
        }
        if (filesetEntity.properties() != null && !filesetEntity.properties().isEmpty()) {
            builder.putAllProperties(filesetEntity.properties());
        }
        Fileset.Type type = Fileset.Type.valueOf((String)filesetEntity.filesetType().name());
        builder.setType(type);
        return builder.build();
    }

    @Override
    public FilesetEntity deserialize(Fileset p, Namespace namespace) {
        FilesetEntity.Builder builder = FilesetEntity.builder().withId(p.getId()).withName(p.getName()).withNamespace(namespace).withStorageLocation(p.getStorageLocation()).withAuditInfo(new AuditInfoSerDe().deserialize(p.getAuditInfo(), namespace)).withFilesetType(Fileset.Type.valueOf((String)p.getType().name()));
        if (p.hasComment()) {
            builder.withComment(p.getComment());
        }
        if (p.getPropertiesCount() > 0) {
            builder.withProperties(p.getPropertiesMap());
        }
        return builder.build();
    }
}

