/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.meta.AuditInfo;

@Evolving
public abstract class BaseFileset
implements Fileset {
    protected String name;
    @Nullable
    protected String comment;
    protected Fileset.Type type;
    protected String storageLocation;
    @Nullable
    protected Map<String, String> properties;
    protected AuditInfo auditInfo;

    public String name() {
        return this.name;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Fileset.Type type() {
        return this.type;
    }

    public String storageLocation() {
        return this.storageLocation;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Nullable
    public Map<String, String> properties() {
        return this.properties;
    }

    public static abstract class BaseFilesetBuilder<SELF extends Builder<SELF, T>, T extends BaseFileset>
    implements Builder<SELF, T> {
        protected String name;
        protected String comment;
        protected Fileset.Type type;
        protected String storageLocation;
        protected Map<String, String> properties;
        protected AuditInfo auditInfo;

        @Override
        public SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        @Override
        public SELF withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        @Override
        public SELF withType(Fileset.Type type) {
            this.type = type;
            return this.self();
        }

        @Override
        public SELF withStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this.self();
        }

        @Override
        public SELF withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        @Override
        public SELF withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this.self();
        }

        @Override
        public T build() {
            T t = this.internalBuild();
            return t;
        }

        private SELF self() {
            return (SELF)this;
        }

        @Evolving
        protected abstract T internalBuild();
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends BaseFileset> {
        public SELF withName(String var1);

        public SELF withComment(String var1);

        public SELF withType(Fileset.Type var1);

        public SELF withStorageLocation(String var1);

        public SELF withProperties(Map<String, String> var1);

        public SELF withAuditInfo(AuditInfo var1);

        public T build();
    }
}

