/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.util.index.INode;
import org.apache.bifromq.util.index.ValueRef;
import org.apache.bifromq.util.index.ValueStrategy;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public class Branch<V> {
    final INode<V> iNode;
    private final ValueStrategy<V> strategy;
    PSet<ValueRef<V>> values;

    Branch(INode<V> iNode, ValueStrategy<V> strategy) {
        this.iNode = iNode;
        this.strategy = strategy;
        this.values = HashTreePSet.empty();
    }

    Branch(V value, ValueStrategy<V> strategy) {
        this.iNode = null;
        this.strategy = strategy;
        this.values = HashTreePSet.empty();
        this.values = this.values.plus(ValueRef.of(value, strategy));
    }

    private Branch(INode<V> iNode, PSet<ValueRef<V>> values, ValueStrategy<V> strategy) {
        this.iNode = iNode;
        this.values = values;
        this.strategy = strategy;
    }

    Branch<V> updated(INode<V> iNode) {
        return new Branch<V>(iNode, this.values, this.strategy);
    }

    Branch<V> updated(V value) {
        PSet newSubs = this.values;
        newSubs = newSubs.plus(ValueRef.of(value, this.strategy));
        return new Branch<V>(this.iNode, newSubs, this.strategy);
    }

    Branch<V> removed(V sub) {
        PSet newSubs = this.values;
        newSubs = newSubs.minus(ValueRef.of(sub, this.strategy));
        return new Branch<V>(this.iNode, newSubs, this.strategy);
    }

    Set<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator it = Branch.this.values.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((ValueRef)it.next()).value;
                    }
                };
            }

            @Override
            public int size() {
                return Branch.this.values.size();
            }

            @Override
            public boolean contains(Object o) {
                Object v = o;
                return Branch.this.values.contains(ValueRef.of(v, Branch.this.strategy));
            }
        };
    }

    boolean contains(V value) {
        return this.values.contains(ValueRef.of(value, this.strategy));
    }

    @Generated
    public String toString() {
        return "Branch(iNode=" + String.valueOf(this.iNode) + ", strategy=" + String.valueOf(this.strategy) + ", values=" + String.valueOf(this.values) + ")";
    }
}

