/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.util;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.BootstrapCommand;
import org.apache.bifromq.basekv.balance.command.ChangeConfigCommand;
import org.apache.bifromq.basekv.balance.command.MergeCommand;
import org.apache.bifromq.basekv.balance.command.SplitCommand;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.EffectiveRoute;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class CommandUtil {
    public static BalanceCommand quit(String localStoreId, KVRangeDescriptor rangeDescriptor) {
        ClusterConfig config = rangeDescriptor.getConfig();
        if (config.getVotersCount() > 1 || config.getLearnersCount() > 0) {
            return ((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)ChangeConfigCommand.builder().toStore(localStoreId)).kvRangeId(rangeDescriptor.getId())).expectedVer(rangeDescriptor.getVer())).voters(Set.of(localStoreId))).learners(Collections.emptySet())).build();
        }
        return ((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)ChangeConfigCommand.builder().toStore(localStoreId)).kvRangeId(rangeDescriptor.getId())).expectedVer(rangeDescriptor.getVer())).voters(Collections.emptySet())).learners(Collections.emptySet())).build();
    }

    public static BalanceCommand diffBy(NavigableMap<Boundary, ClusterConfig> expectedRouteLayout, EffectiveRoute effectiveRoute) {
        assert (BoundaryUtil.isValidSplitSet(expectedRouteLayout.keySet()));
        Iterator currentItr = effectiveRoute.leaderRanges().keySet().iterator();
        for (Boundary expectedRange : expectedRouteLayout.keySet()) {
            ClusterConfig expectedRangeLayout = (ClusterConfig)expectedRouteLayout.get(expectedRange);
            if (currentItr.hasNext()) {
                Boundary currentRange = (Boundary)currentItr.next();
                RangeLeader currentRangeLeader = (RangeLeader)effectiveRoute.leaderRanges().get(currentRange);
                ClusterConfig currentRangeLayout = currentRangeLeader.descriptor().getConfig();
                if (!currentRangeLayout.getNextVotersList().isEmpty() || !currentRangeLayout.getNextLearnersList().isEmpty()) {
                    return null;
                }
                if (expectedRange.equals((Object)currentRange)) {
                    if (CommandUtil.isSame(expectedRangeLayout, currentRangeLayout)) continue;
                    return ((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)ChangeConfigCommand.builder().toStore(currentRangeLeader.storeId())).kvRangeId(currentRangeLeader.descriptor().getId())).expectedVer(currentRangeLeader.descriptor().getVer())).voters(CommandUtil.setOf((Collection<String>)expectedRangeLayout.getVotersList()))).learners(CommandUtil.setOf((Collection<String>)expectedRangeLayout.getLearnersList()))).build();
                }
                if (BoundaryUtil.inRange((Boundary)expectedRange, (Boundary)currentRange)) {
                    return ((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)SplitCommand.builder().toStore(currentRangeLeader.storeId())).kvRangeId(currentRangeLeader.descriptor().getId())).expectedVer(currentRangeLeader.descriptor().getVer())).splitKey(expectedRange.getEndKey())).build();
                }
                if (BoundaryUtil.compare((Boundary)expectedRange, (Boundary)currentRange) < 0) {
                    return ((BootstrapCommand.BootstrapCommandBuilder)((BalanceCommand.BalanceCommandBuilder)((BootstrapCommand.BootstrapCommandBuilder)BootstrapCommand.builder().toStore(CommandUtil.bootstrapStore(expectedRangeLayout))).boundary(BoundaryUtil.toBoundary((ByteString)BoundaryUtil.startKey((Boundary)expectedRange), (ByteString)BoundaryUtil.startKey((Boundary)currentRange)))).kvRangeId(KVRangeIdUtil.next((long)effectiveRoute.epoch()))).build();
                }
                if (!currentItr.hasNext()) {
                    return ((BootstrapCommand.BootstrapCommandBuilder)((BalanceCommand.BalanceCommandBuilder)((BootstrapCommand.BootstrapCommandBuilder)BootstrapCommand.builder().toStore(CommandUtil.bootstrapStore(expectedRangeLayout))).boundary(BoundaryUtil.toBoundary((ByteString)currentRange.getEndKey(), (ByteString)expectedRange.getEndKey()))).kvRangeId(KVRangeIdUtil.next((long)effectiveRoute.epoch()))).build();
                }
                Boundary nextCurrentBoundary = (Boundary)currentItr.next();
                RangeLeader nextRangeLeader = (RangeLeader)effectiveRoute.leaderRanges().get(nextCurrentBoundary);
                ClusterConfig nextCurrentRangeLayout = nextRangeLeader.descriptor().getConfig();
                if (!nextCurrentRangeLayout.getNextVotersList().isEmpty() || !nextCurrentRangeLayout.getNextLearnersList().isEmpty()) {
                    return null;
                }
                if (CommandUtil.isSame(expectedRangeLayout, nextCurrentRangeLayout)) {
                    return ((MergeCommand.MergeCommandBuilder)((MergeCommand.MergeCommandBuilder)((MergeCommand.MergeCommandBuilder)((MergeCommand.MergeCommandBuilder)((MergeCommand.MergeCommandBuilder)MergeCommand.builder().toStore(currentRangeLeader.storeId())).kvRangeId(currentRangeLeader.descriptor().getId())).expectedVer(currentRangeLeader.descriptor().getVer())).mergeeId(nextRangeLeader.descriptor().getId())).voters(CommandUtil.setOf((Collection<String>)nextRangeLeader.descriptor().getConfig().getVotersList()))).build();
                }
                return ((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)ChangeConfigCommand.builder().toStore(nextRangeLeader.storeId())).kvRangeId(nextRangeLeader.descriptor().getId())).expectedVer(nextRangeLeader.descriptor().getVer())).voters(CommandUtil.setOf((Collection<String>)currentRangeLayout.getVotersList()))).learners(CommandUtil.setOf((Collection<String>)currentRangeLayout.getLearnersList()))).build();
            }
            return ((BootstrapCommand.BootstrapCommandBuilder)((BalanceCommand.BalanceCommandBuilder)((BootstrapCommand.BootstrapCommandBuilder)BootstrapCommand.builder().toStore(CommandUtil.bootstrapStore(expectedRangeLayout))).boundary(expectedRange)).kvRangeId(KVRangeIdUtil.next((long)effectiveRoute.epoch()))).build();
        }
        return null;
    }

    private static String bootstrapStore(ClusterConfig layout) {
        ArrayList voters = new ArrayList(layout.getVotersList());
        Collections.sort(voters);
        return (String)voters.get(0);
    }

    public static boolean isSame(ClusterConfig config1, ClusterConfig config2) {
        return CommandUtil.setOf((Collection<String>)config1.getVotersList()).equals(CommandUtil.setOf((Collection<String>)config2.getVotersList())) && CommandUtil.setOf((Collection<String>)config1.getLearnersList()).equals(CommandUtil.setOf((Collection<String>)config2.getLearnersList())) && CommandUtil.setOf((Collection<String>)config1.getNextVotersList()).equals(CommandUtil.setOf((Collection<String>)config2.getNextVotersList())) && CommandUtil.setOf((Collection<String>)config1.getNextLearnersList()).equals(CommandUtil.setOf((Collection<String>)config2.getNextLearnersList()));
    }

    private static Set<String> setOf(Collection<String> iterable) {
        return new HashSet<String>(iterable);
    }
}

