/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.apiserver.IAPIServer;
import org.apache.bifromq.apiserver.NonTLSServerInitializer;
import org.apache.bifromq.apiserver.TLSServerInitializer;
import org.apache.bifromq.apiserver.http.HTTPRouteMap;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.RequestHandlersFactory;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIServer
implements IAPIServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(APIServer.class);
    private final String host;
    private final int port;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerBootstrap serverBootstrap;
    private final Collection<IHTTPRequestHandler> handlers;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private Channel serverChannel;

    private APIServer(String host, int port, int maxContentLength, int workerThreads, SslContext sslContext, IRPCServiceTrafficService trafficService, IBaseKVMetaService metaService, IAgentHost agentHost, IDistClient distClient, IInboxClient inboxClient, ISessionDictClient sessionDictClient, IRetainClient retainClient, ISettingProvider settingProvider) {
        Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0);
        this.host = host;
        this.port = port;
        this.bossGroup = NettyEnv.createEventLoopGroup((int)1, (String)"api-server-boss-elg");
        this.workerGroup = NettyEnv.createEventLoopGroup((int)workerThreads, (String)"api-server-worker-elg");
        RequestHandlersFactory handlersFactory = new RequestHandlersFactory(agentHost, trafficService, metaService, sessionDictClient, distClient, inboxClient, retainClient, settingProvider);
        this.handlers = handlersFactory.build();
        HTTPRouteMap routeMap = new HTTPRouteMap(this.handlers);
        this.serverBootstrap = sslContext != null ? this.buildServerChannel(new TLSServerInitializer(sslContext, routeMap, settingProvider, maxContentLength)) : this.buildServerChannel(new NonTLSServerInitializer(routeMap, settingProvider, maxContentLength));
    }

    @Override
    public String host() {
        this.checkStarted();
        return this.host;
    }

    @Override
    public int listeningPort() {
        this.checkStarted();
        return ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
    }

    @Override
    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                this.handlers.forEach(IHTTPRequestHandler::start);
                log.info("Starting API server");
                this.serverChannel = this.serverBootstrap.bind(this.host, this.port).sync().channel();
                log.debug("Accepting API request at {}", (Object)this.serverChannel.localAddress());
                log.info("API server started");
                this.state.set(State.STARTED);
            }
            catch (Throwable e) {
                this.state.set(State.STARTING_FAILED);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            log.info("Stopping API server");
            this.serverChannel.close().syncUninterruptibly();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.handlers.forEach(IHTTPRequestHandler::close);
            log.debug("API server stopped");
            this.state.set(State.STOPPED);
        }
    }

    private ServerBootstrap buildServerChannel(ChannelInitializer<SocketChannel> channelInitializer) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).channel(NettyEnv.determineServerSocketChannelClass((EventLoopGroup)this.bossGroup))).childHandler(channelInitializer);
        if (Epoll.isAvailable()) {
            b.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
        }
        return b;
    }

    private void checkStarted() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"APIServer not started");
    }

    @Generated
    public static APIServerBuilder builder() {
        return new APIServerBuilder();
    }

    static enum State {
        INIT,
        STARTING,
        STARTED,
        STARTING_FAILED,
        STOPPING,
        STOPPED;

    }

    @Generated
    public static class APIServerBuilder {
        @Generated
        private String host;
        @Generated
        private int port;
        @Generated
        private int maxContentLength;
        @Generated
        private int workerThreads;
        @Generated
        private SslContext sslContext;
        @Generated
        private IRPCServiceTrafficService trafficService;
        @Generated
        private IBaseKVMetaService metaService;
        @Generated
        private IAgentHost agentHost;
        @Generated
        private IDistClient distClient;
        @Generated
        private IInboxClient inboxClient;
        @Generated
        private ISessionDictClient sessionDictClient;
        @Generated
        private IRetainClient retainClient;
        @Generated
        private ISettingProvider settingProvider;

        @Generated
        APIServerBuilder() {
        }

        @Generated
        public APIServerBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public APIServerBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public APIServerBuilder maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        @Generated
        public APIServerBuilder workerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        @Generated
        public APIServerBuilder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Generated
        public APIServerBuilder trafficService(IRPCServiceTrafficService trafficService) {
            this.trafficService = trafficService;
            return this;
        }

        @Generated
        public APIServerBuilder metaService(IBaseKVMetaService metaService) {
            this.metaService = metaService;
            return this;
        }

        @Generated
        public APIServerBuilder agentHost(IAgentHost agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        @Generated
        public APIServerBuilder distClient(IDistClient distClient) {
            this.distClient = distClient;
            return this;
        }

        @Generated
        public APIServerBuilder inboxClient(IInboxClient inboxClient) {
            this.inboxClient = inboxClient;
            return this;
        }

        @Generated
        public APIServerBuilder sessionDictClient(ISessionDictClient sessionDictClient) {
            this.sessionDictClient = sessionDictClient;
            return this;
        }

        @Generated
        public APIServerBuilder retainClient(IRetainClient retainClient) {
            this.retainClient = retainClient;
            return this;
        }

        @Generated
        public APIServerBuilder settingProvider(ISettingProvider settingProvider) {
            this.settingProvider = settingProvider;
            return this;
        }

        @Generated
        public APIServer build() {
            return new APIServer(this.host, this.port, this.maxContentLength, this.workerThreads, this.sslContext, this.trafficService, this.metaService, this.agentHost, this.distClient, this.inboxClient, this.sessionDictClient, this.retainClient, this.settingProvider);
        }

        @Generated
        public String toString() {
            return "APIServer.APIServerBuilder(host=" + this.host + ", port=" + this.port + ", maxContentLength=" + this.maxContentLength + ", workerThreads=" + this.workerThreads + ", sslContext=" + String.valueOf(this.sslContext) + ", trafficService=" + String.valueOf(this.trafficService) + ", metaService=" + String.valueOf(this.metaService) + ", agentHost=" + String.valueOf(this.agentHost) + ", distClient=" + String.valueOf(this.distClient) + ", inboxClient=" + String.valueOf(this.inboxClient) + ", sessionDictClient=" + String.valueOf(this.sessionDictClient) + ", retainClient=" + String.valueOf(this.retainClient) + ", settingProvider=" + String.valueOf(this.settingProvider) + ")";
        }
    }
}

