/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server.interceptor;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import java.util.Collections;
import lombok.Generated;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.MetadataKeys;
import org.apache.bifromq.baserpc.RPCContext;
import org.apache.bifromq.baserpc.metrics.RPCMeter;
import org.apache.bifromq.baserpc.proto.PipelineMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAwareServerInterceptor
implements ServerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAwareServerInterceptor.class);
    private static final ServerCall.Listener NOOP_LISTENER = new ServerCall.Listener<Object>(){};
    private final RPCMeter meter;

    public TenantAwareServerInterceptor(ServerServiceDefinition serviceDefinition, BluePrint bluePrint) {
        this.meter = new RPCMeter(serviceDefinition.getServiceDescriptor(), bluePrint);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        try {
            Context ctx = Context.current();
            assert (headers.containsKey(MetadataKeys.TENANT_ID_META_KEY));
            String tenantId = (String)headers.get(MetadataKeys.TENANT_ID_META_KEY);
            ctx = ctx.withValue(RPCContext.TENANT_ID_CTX_KEY, (Object)tenantId);
            if (headers.containsKey(MetadataKeys.CUSTOM_METADATA_META_KEY)) {
                PipelineMetadata metadata = PipelineMetadata.parseFrom((byte[])((byte[])headers.get(MetadataKeys.CUSTOM_METADATA_META_KEY)));
                ctx = ctx.withValue(RPCContext.CUSTOM_METADATA_CTX_KEY, (Object)metadata.getEntryMap());
            } else {
                ctx = ctx.withValue(RPCContext.CUSTOM_METADATA_CTX_KEY, Collections.emptyMap());
            }
            ctx = ctx.withValue(RPCContext.METER_KEY_CTX_KEY, (Object)this.meter.get(call.getMethodDescriptor()));
            ServerCall.Listener listener = Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
            return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener){

                public void onHalfClose() {
                    try {
                        super.onHalfClose();
                    }
                    catch (Exception e) {
                        log.error("Failed to execute server call.", (Throwable)e);
                        call.close(Status.INTERNAL.withCause((Throwable)e).withDescription(e.getMessage()), headers);
                    }
                }
            };
        }
        catch (UnsupportedOperationException e) {
            log.error("Failed to determine traffic identifier from the call", (Throwable)e);
            call.close(Status.UNAUTHENTICATED.withDescription("Invalid Client Certificate"), headers);
            return NOOP_LISTENER;
        }
        catch (Throwable e) {
            log.error("Failed to make server call", e);
            call.close(Status.INTERNAL.withDescription("Server handling request error"), headers);
            return NOOP_LISTENER;
        }
    }
}

