/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CollectorRegistry {
    public static final CollectorRegistry defaultRegistry = new CollectorRegistry(true);
    private final Object namesCollectorsLock = new Object();
    private final Map<Collector, List<String>> collectorsToNames = new HashMap<Collector, List<String>>();
    private final Map<String, Collector> namesToCollectors = new HashMap<String, Collector>();
    private final boolean autoDescribe;

    public CollectorRegistry() {
        this(false);
    }

    public CollectorRegistry(boolean autoDescribe) {
        this.autoDescribe = autoDescribe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Collector m4) {
        List<String> names = this.collectorNames(m4);
        this.assertNoDuplicateNames(m4, names);
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            for (String name : names) {
                if (!this.namesToCollectors.containsKey(name)) continue;
                throw new IllegalArgumentException("Failed to register Collector of type " + m4.getClass().getSimpleName() + ": " + name + " is already in use by another Collector of type " + this.namesToCollectors.get(name).getClass().getSimpleName());
            }
            for (String name : names) {
                this.namesToCollectors.put(name, m4);
            }
            this.collectorsToNames.put(m4, names);
        }
    }

    private void assertNoDuplicateNames(Collector m4, List<String> names) {
        HashSet<String> uniqueNames = new HashSet<String>();
        for (String name : names) {
            if (uniqueNames.add(name)) continue;
            throw new IllegalArgumentException("Failed to register Collector of type " + m4.getClass().getSimpleName() + ": The Collector exposes the same name multiple times: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Collector m4) {
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            List<String> names = this.collectorsToNames.remove(m4);
            for (String name : names) {
                this.namesToCollectors.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            this.collectorsToNames.clear();
            this.namesToCollectors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Collector> collectors() {
        Object object = this.namesCollectorsLock;
        synchronized (object) {
            return new HashSet<Collector>(this.collectorsToNames.keySet());
        }
    }

    private List<String> collectorNames(Collector m4) {
        List<Collector.MetricFamilySamples> mfs = m4 instanceof Collector.Describable ? ((Collector.Describable)((Object)m4)).describe() : (this.autoDescribe ? m4.collect() : Collections.emptyList());
        ArrayList<String> names = new ArrayList<String>();
        for (Collector.MetricFamilySamples family : mfs) {
            names.addAll(Arrays.asList(family.getNames()));
        }
        return names;
    }

    public Enumeration<Collector.MetricFamilySamples> metricFamilySamples() {
        return new MetricFamilySamplesEnumeration();
    }

    public Enumeration<Collector.MetricFamilySamples> filteredMetricFamilySamples(Set<String> includedNames) {
        return new MetricFamilySamplesEnumeration(new SampleNameFilter.Builder().nameMustBeEqualTo(includedNames).build());
    }

    public Enumeration<Collector.MetricFamilySamples> filteredMetricFamilySamples(Predicate<String> sampleNameFilter) {
        return new MetricFamilySamplesEnumeration(sampleNameFilter);
    }

    public Double getSampleValue(String name) {
        return this.getSampleValue(name, new String[0], new String[0]);
    }

    public Double getSampleValue(String name, String[] labelNames, String[] labelValues) {
        for (Collector.MetricFamilySamples metricFamilySamples : Collections.list(this.metricFamilySamples())) {
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                if (!sample.name.equals(name) || !Arrays.equals(sample.labelNames.toArray(), labelNames) || !Arrays.equals(sample.labelValues.toArray(), labelValues)) continue;
                return sample.value;
            }
        }
        return null;
    }

    class MetricFamilySamplesEnumeration
    implements Enumeration<Collector.MetricFamilySamples> {
        private final Iterator<Collector> collectorIter;
        private Iterator<Collector.MetricFamilySamples> metricFamilySamples;
        private Collector.MetricFamilySamples next;
        private final Predicate<String> sampleNameFilter;

        MetricFamilySamplesEnumeration(Predicate<String> sampleNameFilter) {
            this.sampleNameFilter = sampleNameFilter;
            this.collectorIter = this.filteredCollectorIterator();
            this.findNextElement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator<Collector> filteredCollectorIterator() {
            if (this.sampleNameFilter == null) {
                return CollectorRegistry.this.collectors().iterator();
            }
            HashSet collectors = new HashSet();
            Object object = CollectorRegistry.this.namesCollectorsLock;
            synchronized (object) {
                block3: for (Map.Entry entry : CollectorRegistry.this.collectorsToNames.entrySet()) {
                    List names = (List)entry.getValue();
                    if (names.isEmpty()) {
                        collectors.add(entry.getKey());
                        continue;
                    }
                    for (String name : names) {
                        if (!this.sampleNameFilter.test(name)) continue;
                        collectors.add(entry.getKey());
                        continue block3;
                    }
                }
            }
            return collectors.iterator();
        }

        MetricFamilySamplesEnumeration() {
            this(null);
        }

        private void findNextElement() {
            this.next = null;
            while (this.metricFamilySamples != null && this.metricFamilySamples.hasNext()) {
                this.next = this.metricFamilySamples.next().filter(this.sampleNameFilter);
                if (this.next == null) continue;
                return;
            }
            while (this.collectorIter.hasNext()) {
                this.metricFamilySamples = this.collectorIter.next().collect(this.sampleNameFilter).iterator();
                while (this.metricFamilySamples.hasNext()) {
                    this.next = this.metricFamilySamples.next().filter(this.sampleNameFilter);
                    if (this.next == null) continue;
                    return;
                }
            }
        }

        @Override
        public Collector.MetricFamilySamples nextElement() {
            Collector.MetricFamilySamples current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.findNextElement();
            return current;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }
    }
}

