/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.dem;

import java.awt.image.BufferedImage;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntToDoubleFunction;

public class ElevationUtils {
    private static final double ELEVATION_SCALE = 65536.0;
    private static final double ELEVATION_OFFSET = 10000.0;
    private static final double TERRARIUM_OFFSET = 32768.0;

    private ElevationUtils() {
    }

    public static double[] imageToGrid(BufferedImage image) {
        ElevationUtils.validateImage(image);
        int width = image.getWidth();
        int height = image.getHeight();
        double[] grid = new double[width * height];
        image.getRaster().getPixels(0, 0, width, height, grid);
        return grid;
    }

    public static double[] imageToGrid(BufferedImage image, IntToDoubleFunction pixelToElevation) {
        ElevationUtils.validateImage(image);
        int width = image.getWidth();
        int height = image.getHeight();
        double[] grid = new double[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                grid[y * width + x] = pixelToElevation.applyAsDouble(rgb);
            }
        }
        return grid;
    }

    public static BufferedImage gridToImage(double[] grid, int width, int height, DoubleToIntFunction elevationToPixel) {
        ElevationUtils.validateGrid(grid, width, height);
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double elevation = grid[y * width + x];
                image.setRGB(x, y, elevationToPixel.applyAsInt(elevation));
            }
        }
        return image;
    }

    private static void validateImage(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Input image cannot be null");
        }
        if (image.getWidth() <= 0 || image.getHeight() <= 0) {
            throw new IllegalArgumentException("Image dimensions must be positive");
        }
    }

    private static void validateGrid(double[] grid, int width, int height) {
        if (grid == null || grid.length == 0) {
            throw new IllegalArgumentException("Grid array cannot be null or empty");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive");
        }
        if (grid.length != width * height) {
            throw new IllegalArgumentException("Grid array length does not match width * height");
        }
    }

    public static double[] invertGrid(double[] grid) {
        double[] invertedGrid = new double[grid.length];
        for (int i = 0; i < grid.length; ++i) {
            invertedGrid[i] = 255.0 - grid[i];
        }
        return invertedGrid;
    }

    public static double[] clampGrid(double[] grid, double min, double max) {
        double[] clampedGrid = new double[grid.length];
        for (int i = 0; i < grid.length; ++i) {
            clampedGrid[i] = Math.max(min, Math.min(max, grid[i]));
        }
        return clampedGrid;
    }

    public static double rgbToElevation(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return ((double)r * 65536.0 + (double)g * 256.0 + (double)b) / 10.0 - 10000.0;
    }

    public static int elevationToRgb(double elevation) {
        int value = (int)((elevation + 10000.0) * 10.0);
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public static double terrariumToElevation(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return (double)r * 256.0 + (double)g + (double)b / 256.0 - 32768.0;
    }

    public static int elevationToTerrarium(double elevation) {
        double adjustedElevation = elevation + 32768.0;
        int r = (int)(adjustedElevation / 256.0);
        int g = (int)(adjustedElevation % 256.0);
        int b = (int)((adjustedElevation - (double)r * 256.0 - (double)g) * 256.0);
        return r << 16 | g << 8 | b;
    }
}

