/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.function.NodeGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.RelationMultiPolygonBuilder;
import org.apache.baremaps.openstreetmap.function.WayGeometryBuilder;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.locationtech.jts.geom.Coordinate;

public class EntityGeometryBuilder
implements Consumer<Entity> {
    private final Consumer<Entity> nodeGeometryBuilder = new NodeGeometryBuilder();
    private final Consumer<Entity> wayGeometryBuilder;
    private final Consumer<Entity> relationMultiPolygonBuilder;

    public EntityGeometryBuilder(Map<Long, Coordinate> coordinateMap, Map<Long, List<Long>> referenceMap) {
        this.wayGeometryBuilder = new WayGeometryBuilder(coordinateMap);
        this.relationMultiPolygonBuilder = new RelationMultiPolygonBuilder(coordinateMap, referenceMap);
    }

    private static boolean isMultiPolygon(Relation relation) {
        Map<String, Object> tags = relation.getTags();
        if ("coastline".equals(tags.get("natural"))) {
            return false;
        }
        return "multipolygon".equals(tags.get("type")) || "boundary".equals(tags.get("type"));
    }

    @Override
    public void accept(Entity entity) {
        Relation relation;
        if (entity instanceof Node) {
            Node node = (Node)entity;
            this.nodeGeometryBuilder.accept(node);
        } else if (entity instanceof Way) {
            Way way = (Way)entity;
            this.wayGeometryBuilder.accept(way);
        } else if (entity instanceof Relation && EntityGeometryBuilder.isMultiPolygon(relation = (Relation)entity)) {
            this.relationMultiPolygonBuilder.accept(relation);
        }
    }
}

