/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.function.ChangeEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.NodeGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.RelationMultiPolygonBuilder;
import org.apache.baremaps.openstreetmap.function.WayGeometryBuilder;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.State;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.state.StateReader;
import org.apache.baremaps.openstreetmap.xml.XmlChangeReader;
import org.apache.baremaps.postgres.openstreetmap.ChangeElementsImporter;
import org.apache.baremaps.postgres.openstreetmap.CoordinateMap;
import org.apache.baremaps.postgres.openstreetmap.HeaderRepository;
import org.apache.baremaps.postgres.openstreetmap.NodeRepository;
import org.apache.baremaps.postgres.openstreetmap.ReferenceMap;
import org.apache.baremaps.postgres.openstreetmap.RelationRepository;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.RepositoryException;
import org.apache.baremaps.postgres.openstreetmap.WayRepository;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOsmDatabase
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(UpdateOsmDatabase.class);
    private Object database;
    private Integer databaseSrid;
    private String replicationUrl;

    public UpdateOsmDatabase() {
    }

    public UpdateOsmDatabase(Object database, Integer databaseSrid, String replicationUrl) {
        this.database = database;
        this.databaseSrid = databaseSrid;
        this.replicationUrl = replicationUrl;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource datasource = context.getDataSource(this.database);
        CoordinateMap coordinateMap = new CoordinateMap(datasource);
        ReferenceMap referenceMap = new ReferenceMap(datasource);
        HeaderRepository headerRepository = new HeaderRepository(datasource);
        NodeRepository nodeRepository = new NodeRepository(datasource);
        WayRepository wayRepository = new WayRepository(datasource);
        RelationRepository relationRepository = new RelationRepository(datasource);
        UpdateOsmDatabase.execute((Map<Long, Coordinate>)coordinateMap, (Map<Long, List<Long>>)referenceMap, headerRepository, (Repository<Long, Node>)nodeRepository, (Repository<Long, Way>)wayRepository, (Repository<Long, Relation>)relationRepository, this.databaseSrid, this.replicationUrl);
    }

    static void execute(Map<Long, Coordinate> coordinateMap, Map<Long, List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, Integer databaseSrid, String replicationUrl) throws IOException, RepositoryException {
        LocalDateTime replicationTimestamp;
        Optional state;
        Header header = headerRepository.selectLatest();
        if (replicationUrl == null) {
            replicationUrl = header.replicationUrl();
        }
        StateReader stateReader = new StateReader(replicationUrl, true);
        Long sequenceNumber = header.replicationSequenceNumber();
        if (sequenceNumber <= 0L && (state = stateReader.getStateFromTimestamp(replicationTimestamp = header.replicationTimestamp())).isPresent()) {
            sequenceNumber = ((State)state.get()).sequenceNumber();
        }
        long nextSequenceNumber = sequenceNumber + 1L;
        URL changeUrl = stateReader.getUrl(replicationUrl, Long.valueOf(nextSequenceNumber), "osc.gz");
        logger.info("Updating the database with the changeset: {}", (Object)changeUrl);
        NodeGeometryBuilder buildNodeGeometry = new NodeGeometryBuilder();
        EntityProjectionTransformer reprojectNodeGeometry = new EntityProjectionTransformer(4326, databaseSrid.intValue());
        ChangeEntitiesHandler prepareNodeGeometry = new ChangeEntitiesHandler(buildNodeGeometry.andThen((Consumer)reprojectNodeGeometry));
        ChangeElementsImporter importNodes = new ChangeElementsImporter(Node.class, nodeRepository);
        WayGeometryBuilder buildWayGeometry = new WayGeometryBuilder(coordinateMap);
        EntityProjectionTransformer reprojectWayGeometry = new EntityProjectionTransformer(4326, databaseSrid.intValue());
        ChangeEntitiesHandler prepareWayGeometry = new ChangeEntitiesHandler(buildWayGeometry.andThen((Consumer)reprojectWayGeometry));
        ChangeElementsImporter importWays = new ChangeElementsImporter(Way.class, wayRepository);
        RelationMultiPolygonBuilder buildRelationGeometry = new RelationMultiPolygonBuilder(coordinateMap, referenceMap);
        EntityProjectionTransformer reprojectRelationGeometry = new EntityProjectionTransformer(4326, databaseSrid.intValue());
        ChangeEntitiesHandler prepareRelationGeometry = new ChangeEntitiesHandler(buildRelationGeometry.andThen((Consumer)reprojectRelationGeometry));
        ChangeElementsImporter importRelations = new ChangeElementsImporter(Relation.class, relationRepository);
        Consumer entityProcessor = prepareNodeGeometry.andThen((Consumer)importNodes).andThen(prepareWayGeometry).andThen(importWays).andThen(prepareRelationGeometry).andThen(importRelations);
        try (GZIPInputStream changeInputStream = new GZIPInputStream(new BufferedInputStream(changeUrl.openStream()));){
            new XmlChangeReader().read((InputStream)changeInputStream).forEach(entityProcessor);
        }
        URL stateUrl = stateReader.getUrl(replicationUrl, Long.valueOf(nextSequenceNumber), "state.txt");
        try (BufferedInputStream stateInputStream = new BufferedInputStream(stateUrl.openStream());){
            State state2 = new StateReader().read((InputStream)stateInputStream);
            headerRepository.put(new Header(Long.valueOf(state2.sequenceNumber()), state2.timestamp(), header.replicationUrl(), header.source(), header.writingProgram()));
        }
    }

    public String toString() {
        return new StringJoiner(", ", UpdateOsmDatabase.class.getSimpleName() + "[", "]").add("database=" + this.database).add("databaseSrid=" + this.databaseSrid).add("replicationUrl='" + this.replicationUrl + "'").toString();
    }
}

