/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.common.DefaultCancellationScheduler;
import com.linecorp.armeria.internal.common.NoopCancellationScheduler;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;

public interface CancellationScheduler {
    public static final CancellationTask noopCancellationTask = new CancellationTask(){

        @Override
        public boolean canSchedule() {
            return true;
        }

        @Override
        public void run(Throwable cause) {
        }
    };

    public static CancellationScheduler ofClient(long timeoutNanos) {
        return new DefaultCancellationScheduler(timeoutNanos, false);
    }

    public static CancellationScheduler ofServer(long timeoutNanos) {
        return new DefaultCancellationScheduler(timeoutNanos, true);
    }

    public static CancellationScheduler finished(boolean server) {
        if (server) {
            return DefaultCancellationScheduler.serverFinishedCancellationScheduler;
        }
        return DefaultCancellationScheduler.clientFinishedCancellationScheduler;
    }

    public static CancellationScheduler noop() {
        return NoopCancellationScheduler.INSTANCE;
    }

    public void initAndStart(EventExecutor var1, CancellationTask var2);

    public void init(EventExecutor var1);

    public void start(CancellationTask var1);

    public void clearTimeout();

    public void clearTimeout(boolean var1);

    public void setTimeoutNanos(TimeoutMode var1, long var2);

    public void finishNow();

    public void finishNow(@Nullable Throwable var1);

    public boolean isFinished();

    @Nullable
    public Throwable cause();

    public long timeoutNanos();

    public long startTimeNanos();

    public CompletableFuture<Throwable> whenCancelling();

    public CompletableFuture<Throwable> whenCancelled();

    @Deprecated
    public CompletableFuture<Void> whenTimingOut();

    @Deprecated
    public CompletableFuture<Void> whenTimedOut();

    public static interface CancellationTask {
        public boolean canSchedule();

        public void run(Throwable var1);
    }

    public static enum State {
        INIT,
        INACTIVE,
        SCHEDULED,
        FINISHING,
        FINISHED;

    }
}

