/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.AggregatedResponseAs;
import com.linecorp.armeria.client.FutureResponseAs;
import com.linecorp.armeria.client.ResponseAsUtil;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseEntity;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SplitHttpResponse;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamMessages;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@FunctionalInterface
@UnstableApi
public interface ResponseAs<T, R> {
    @UnstableApi
    public static ResponseAs<HttpResponse, AggregatedHttpResponse> blocking() {
        return ResponseAsUtil.BLOCKING;
    }

    @UnstableApi
    public static FutureResponseAs<ResponseEntity<byte[]>> bytes() {
        return ResponseAsUtil.aggregateAndConvert(AggregatedResponseAs.bytes());
    }

    @UnstableApi
    public static FutureResponseAs<ResponseEntity<String>> string() {
        return ResponseAsUtil.aggregateAndConvert(AggregatedResponseAs.string());
    }

    @UnstableApi
    public static FutureResponseAs<ResponseEntity<Path>> path(Path path) {
        Objects.requireNonNull(path, "path");
        return response -> {
            SplitHttpResponse splitResponse = response.split();
            CompletableFuture<Void> future = StreamMessages.writeTo((StreamMessage<? extends HttpData>)splitResponse.body(), path, new OpenOption[0]);
            return CompletableFutures.allAsList(ImmutableList.of(splitResponse.headers(), future, splitResponse.trailers())).thenApply(objects -> {
                ResponseHeaders headers = (ResponseHeaders)objects.get(0);
                HttpHeaders trailers = (HttpHeaders)objects.get(2);
                return ResponseEntity.of(headers, path, trailers);
            });
        };
    }

    @UnstableApi
    public static <T> FutureResponseAs<ResponseEntity<T>> json(Class<? extends T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return ResponseAsUtil.aggregateAndConvert(AggregatedResponseAs.json(clazz));
    }

    @UnstableApi
    public static <T> FutureResponseAs<ResponseEntity<T>> json(Class<? extends T> clazz, ObjectMapper mapper) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(mapper, "mapper");
        return ResponseAsUtil.aggregateAndConvert(AggregatedResponseAs.json(clazz, mapper));
    }

    @UnstableApi
    public static <T> FutureResponseAs<ResponseEntity<T>> json(TypeReference<? extends T> typeRef) {
        Objects.requireNonNull(typeRef, "typeRef");
        return ResponseAsUtil.aggregateAndConvert(AggregatedResponseAs.json(typeRef));
    }

    @UnstableApi
    public static <T> FutureResponseAs<ResponseEntity<T>> json(TypeReference<? extends T> typeRef, ObjectMapper mapper) {
        Objects.requireNonNull(typeRef, "typeRef");
        Objects.requireNonNull(mapper, "mapper");
        return ResponseAsUtil.aggregateAndConvert(AggregatedResponseAs.json(typeRef, mapper));
    }

    @UnstableApi
    public R as(T var1);

    @UnstableApi
    default public boolean requiresAggregation() {
        return false;
    }

    @UnstableApi
    default public <V> ResponseAs<T, V> andThen(final ResponseAs<R, V> after) {
        Objects.requireNonNull(after, "after");
        return new ResponseAs<T, V>(){

            @Override
            public V as(T response) {
                Objects.requireNonNull(response, "response");
                return after.as(ResponseAs.this.as(response));
            }

            @Override
            public boolean requiresAggregation() {
                if (ResponseAs.this.requiresAggregation()) {
                    return true;
                }
                return after.requiresAggregation();
            }
        };
    }
}

