/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SQLExecResult {
    private Set<String> tables = new LinkedHashSet<String>();
    private List<String> columns = new ArrayList<String>();
    private Integer maxColumnWidth = null;
    private Integer maxLinesPerRow = null;
    private List<Integer> columnWidths = new ArrayList<Integer>();
    private List<List<String>> rows = new ArrayList<List<String>>();
    private Integer updateCount = null;
    private Integer maxRows = null;
    private boolean printSides = true;

    public void addTable(String table) {
        if (table != null && !table.isBlank()) {
            this.tables.add(table.trim());
        }
    }

    public List<String> getTables() {
        return new ArrayList<String>(this.tables);
    }

    public void addColumn(String column) {
        this.columns.add(column);
    }

    public void addColumn(int index, String column) {
        this.columns.add(index, column);
    }

    public void addColumns(Collection<String> columns) {
        this.columns.addAll(columns);
    }

    public int numColumns() {
        return this.columns.size();
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumn(int index) {
        return this.columns.get(index);
    }

    public boolean hasColumns() {
        return this.numColumns() > 0;
    }

    public Integer getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public void setMaxColumnWidth(Integer maxColumnWidth) {
        if (maxColumnWidth != null && maxColumnWidth <= 0) {
            maxColumnWidth = null;
        }
        this.maxColumnWidth = maxColumnWidth;
        if (maxColumnWidth != null) {
            for (int i = 0; i < this.columnWidths.size(); ++i) {
                Integer width = this.columnWidths.get(i);
                if (width == null || maxColumnWidth >= width) continue;
                this.columnWidths.set(i, maxColumnWidth);
            }
        }
    }

    public Integer getMaxLinesPerRow() {
        return this.maxLinesPerRow;
    }

    public void setMaxLinesPerRow(Integer maxLinesPerRow) {
        if (maxLinesPerRow != null && maxLinesPerRow <= 0) {
            maxLinesPerRow = null;
        }
        this.maxLinesPerRow = maxLinesPerRow;
    }

    public void addColumnWidth(int width) {
        if (this.maxColumnWidth != null) {
            width = Math.min(width, this.maxColumnWidth);
        }
        this.columnWidths.add(width);
    }

    public void addColumnWidth(int index, int width) {
        if (this.maxColumnWidth != null) {
            width = Math.min(width, this.maxColumnWidth);
        }
        this.columnWidths.add(index, width);
    }

    public void addColumnWidths(int[] widths) {
        for (int width : widths) {
            this.addColumnWidth(width);
        }
    }

    public List<Integer> getColumnWidths() {
        return this.columnWidths;
    }

    public int getColumnWidth(int index) {
        return this.columnWidths.get(index);
    }

    public void addRow(List<String> row) {
        this.rows.add(row);
    }

    public int numRows() {
        return this.rows.size();
    }

    public boolean hasRows() {
        return this.numRows() > 0;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public List<String> getRow(int index) {
        return this.rows.get(index);
    }

    public void addRowValue(int index, String value) {
        this.rows.get(index).add(value);
    }

    public void addRowValue(int index, int columnIndex, String value) {
        this.rows.get(index).add(columnIndex, value);
    }

    public String getValue(int rowIndex, int columnIndex) {
        return this.getRow(rowIndex).get(columnIndex);
    }

    public void setUpdateCount(Integer updateCount) {
        this.updateCount = updateCount;
    }

    public Integer getUpdateCount() {
        return this.updateCount;
    }

    public boolean hasUpdateCount() {
        return this.getUpdateCount() != null;
    }

    public void setMaxRows(Integer maxRows) {
        if (maxRows != null && maxRows <= 0) {
            maxRows = null;
        }
        this.maxRows = maxRows;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public boolean hasMaxResults() {
        return this.maxRows != null && this.numRows() >= this.maxRows;
    }

    public boolean isPrintSides() {
        return this.printSides;
    }

    public void setPrintSides(boolean printSides) {
        this.printSides = printSides;
    }

    public void printResults() {
        System.out.println();
        if (this.hasColumns()) {
            int width = 0;
            for (int columnWidth : this.columnWidths) {
                width += columnWidth;
            }
            width += this.numColumns() - 1;
            if (this.printSides) {
                width += 2;
            }
            width += 2 * (this.numColumns() - 1);
            if (this.printSides) {
                width += 2;
            }
            this.printTables();
            this.printHorizontalDivider(width);
            this.printColumns();
            this.printHorizontalDivider(width);
            this.printRows(width);
            this.printHorizontalDivider(width);
            this.printRowCount();
        } else if (this.hasUpdateCount()) {
            System.out.println("Update Count: " + this.getUpdateCount());
        } else {
            System.out.println("No Results");
        }
    }

    private void printRowCount() {
        System.out.println("Rows: " + this.numRows() + (this.hasMaxResults() ? " (max)" : ""));
    }

    private void printTables() {
        List<String> tables = this.getTables();
        if (!tables.isEmpty()) {
            System.out.print("Table");
            if (tables.size() > 1) {
                System.out.print("s");
            }
            System.out.print(": ");
            for (int i = 0; i < tables.size(); ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(tables.get(i));
            }
            System.out.println();
        }
    }

    private void printColumns() {
        for (int col = 0; col < this.numColumns(); ++col) {
            if (col > 0 || this.printSides) {
                this.printVerticalDivider();
                this.printSpace();
            }
            String column = this.getColumn(col);
            System.out.print(column);
            if (col + 1 >= this.numColumns() && !this.printSides) continue;
            int width = this.getColumnWidth(col);
            this.printSpace(width - column.length());
            this.printSpace();
        }
        if (this.printSides) {
            this.printVerticalDivider();
        }
        System.out.println();
    }

    private void printRows(int width) {
        if (this.hasRows()) {
            for (int row = 0; row < this.numRows(); ++row) {
                this.printRow(row);
            }
        } else if (this.printSides) {
            this.printVerticalDivider();
            this.printSpace(width - 2);
            this.printVerticalDivider();
            System.out.println();
        }
    }

    private void printRow(int index) {
        this.printRowValues(this.getRow(index), 1);
    }

    private void printRowValues(List<String> values, int line) {
        ArrayList<String> nextLine = null;
        int numColumns = this.numColumns();
        for (int col = 0; col < numColumns; ++col) {
            Object value;
            if (col > 0 || this.printSides) {
                if (col > 0) {
                    this.printSpace();
                }
                this.printVerticalDivider();
                this.printSpace();
            }
            if ((value = values.get(col)) != null && this.maxColumnWidth != null && ((String)value).length() > this.maxColumnWidth) {
                if (this.maxLinesPerRow == null || line < this.maxLinesPerRow) {
                    String nextLineValue = ((String)value).substring(this.maxColumnWidth);
                    value = ((String)value).substring(0, this.maxColumnWidth);
                    if (nextLine == null) {
                        nextLine = new ArrayList<String>();
                        for (int i = 0; i < values.size(); ++i) {
                            nextLine.add(null);
                        }
                    }
                    nextLine.set(col, nextLineValue);
                } else {
                    value = ((String)value).substring(0, this.maxColumnWidth - 1) + "\u2026";
                }
            }
            int width = this.getColumnWidth(col);
            int valueLength = 0;
            if (value != null) {
                System.out.print((String)value);
                valueLength = ((String)value).length();
            }
            if (!this.printSides && numColumns <= 1) continue;
            this.printSpace(width - valueLength);
        }
        if (this.printSides) {
            this.printSpace();
            this.printVerticalDivider();
        }
        System.out.println();
        if (nextLine != null) {
            this.printRowValues(nextLine, line + 1);
        }
    }

    private void printHorizontalDivider(int width) {
        for (int i = 0; i < width; ++i) {
            this.printHorizontalDivider();
        }
        System.out.println();
    }

    private void printHorizontalDivider() {
        System.out.print("-");
    }

    private void printVerticalDivider() {
        System.out.print("|");
    }

    private void printSpace(int width) {
        for (int i = 0; i < width; ++i) {
            this.printSpace();
        }
    }

    private void printSpace() {
        System.out.print(" ");
    }
}

