package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Link1;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("style-set-entry")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class StyleSetEntry   {
  private @Valid String id;
  private @Valid String title;
  private @Valid List<Link1> links = null;

  /**
   **/
  public StyleSetEntry id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   **/
  public StyleSetEntry title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public StyleSetEntry links(List<Link1> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("links")
  @NotNull
 @Size(min=1)  public List<Link1> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link1> links) {
    this.links = links;
  }

  public StyleSetEntry addLinksItem(Link1 linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public StyleSetEntry removeLinksItem(Link1 linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StyleSetEntry styleSetEntry = (StyleSetEntry) o;
    return Objects.equals(this.id, styleSetEntry.id) &&
        Objects.equals(this.title, styleSetEntry.title) &&
        Objects.equals(this.links, styleSetEntry.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StyleSetEntry {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

