/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Ipv6Address
extends IpAddress {
    private static final long serialVersionUID = 2L;
    private static final Pattern IPV6_PATTERN = Pattern.compile("(([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))");
    private static final int COLON_COUNT_FOR_EMBEDDED_IPV4 = 6;
    private static final int COLON_COUNT_IPV6 = 7;
    private static final String COLON = ":";
    private final BigInteger PART_MASK = BigInteger.valueOf(65535L);
    private final BigInteger value;

    public Ipv6Address(BigInteger value) {
        this.value = value;
    }

    @Override
    public IpResourceType getType() {
        return IpResourceType.IPv6;
    }

    @Override
    protected int doHashCode() {
        return this.value.hashCode();
    }

    @Override
    protected int doCompareTo(IpResource obj) {
        if (obj instanceof Ipv6Address) {
            Ipv6Address that = (Ipv6Address)obj;
            return this.getValue().compareTo(that.getValue());
        }
        return super.doCompareTo(obj);
    }

    @Override
    public int getCommonPrefixLength(UniqueIpResource other) {
        Validate.isTrue((this.getType() == other.getType() ? 1 : 0) != 0, (String)"incompatible resource types", (Object[])new Object[0]);
        BigInteger temp = this.getValue().xor(other.getValue());
        return this.getType().getBitSize() - temp.bitLength();
    }

    @Override
    public Ipv6Address lowerBoundForPrefix(int prefixLength) {
        BigInteger mask = Ipv6Address.bitMask(0, this.getType()).xor(Ipv6Address.bitMask(prefixLength, this.getType()));
        return new Ipv6Address(this.getValue().and(mask));
    }

    @Override
    public IpAddress upperBoundForPrefix(int prefixLength) {
        return new Ipv6Address(this.getValue().or(Ipv6Address.bitMask(prefixLength, this.getType())));
    }

    public static Ipv6Address parse(String ipAddressString) {
        Validate.notNull((Object)ipAddressString);
        ipAddressString = ipAddressString.trim();
        Validate.isTrue((boolean)IPV6_PATTERN.matcher(ipAddressString).matches(), (String)("Invalid IPv6 address: " + ipAddressString), (Object[])new Object[0]);
        ipAddressString = Ipv6Address.expandMissingColons(ipAddressString);
        if (Ipv6Address.isInIpv4EmbeddedIpv6Format(ipAddressString)) {
            ipAddressString = Ipv6Address.getIpv6AddressWithIpv4SectionInIpv6Notation(ipAddressString);
        }
        return new Ipv6Address(Ipv6Address.ipv6StringtoBigInteger(ipAddressString));
    }

    private static String expandMissingColons(String ipAddressString) {
        int colonCount = Ipv6Address.isInIpv4EmbeddedIpv6Format(ipAddressString) ? 6 : 7;
        return ipAddressString.replace("::", StringUtils.repeat((String)COLON, (int)(colonCount - StringUtils.countMatches((CharSequence)ipAddressString, (CharSequence)COLON) + 2)));
    }

    private static boolean isInIpv4EmbeddedIpv6Format(String ipAddressString) {
        return ipAddressString.contains(".");
    }

    private static String getIpv6AddressWithIpv4SectionInIpv6Notation(String ipAddressString) {
        String ipv6Section = StringUtils.substringBeforeLast((String)ipAddressString, (String)COLON);
        String ipv4Section = StringUtils.substringAfterLast((String)ipAddressString, (String)COLON);
        try {
            long ipv4value = Ipv4Address.parse(ipv4Section).longValue();
            return ipv6Section + COLON + Long.toString(ipv4value >>> 16, 16) + COLON + Long.toString(ipv4value & 0xFFFFL, 16);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Embedded Ipv4 in IPv6 address is invalid: " + ipAddressString, e);
        }
    }

    private static BigInteger ipv6StringtoBigInteger(String ipAddressString) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        int groupValue = 0;
        for (int i = 0; i < ipAddressString.length(); ++i) {
            char c = ipAddressString.charAt(i);
            if (c == ':') {
                byteBuffer.putShort((short)groupValue);
                groupValue = 0;
                continue;
            }
            groupValue = (groupValue << 4) + Character.digit(c, 16);
        }
        byteBuffer.putShort((short)groupValue);
        return new BigInteger(1, byteBuffer.array());
    }

    @Override
    public String toString(boolean defaultMissingOctets) {
        long[] parts = new long[8];
        Object[] formatted = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.getValue().shiftRight((7 - i) * 16).and(this.PART_MASK).longValue();
            formatted[i] = Long.toHexString(parts[i]);
        }
        int currentZeroPartsLength = 0;
        int currentZeroPartsStart = 0;
        int maxZeroPartsLength = 0;
        int maxZeroPartsStart = 0;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == 0L) {
                if (currentZeroPartsLength == 0) {
                    currentZeroPartsStart = i;
                }
                if (++currentZeroPartsLength <= maxZeroPartsLength) continue;
                maxZeroPartsLength = currentZeroPartsLength;
                maxZeroPartsStart = currentZeroPartsStart;
                continue;
            }
            currentZeroPartsLength = 0;
        }
        if (maxZeroPartsLength <= 1) {
            return StringUtils.join((Object[])formatted, (String)COLON);
        }
        String init = StringUtils.join((Object[])formatted, (String)COLON, (int)0, (int)maxZeroPartsStart);
        String tail = StringUtils.join((Object[])formatted, (String)COLON, (int)(maxZeroPartsStart + maxZeroPartsLength), (int)formatted.length);
        return init + "::" + tail;
    }

    @Override
    public final BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean isValidNetmask() {
        int bitLength = this.value.bitLength();
        if (bitLength < IpResourceType.IPv6.getBitSize()) {
            return false;
        }
        int lowestSetBit = this.value.getLowestSetBit();
        for (int i = bitLength - 1; i >= lowestSetBit; --i) {
            if (this.value.testBit(i)) continue;
            return false;
        }
        return true;
    }
}

