/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

final class OnErrorMapCompletable
extends AbstractSynchronousCompletableOperator {
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Throwable> mapper;

    OnErrorMapCompletable(Completable original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        super(original);
        this.predicate = Objects.requireNonNull(predicate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new ErrorMapSubscriber(subscriber);
    }

    private final class ErrorMapSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber subscriber;

        private ErrorMapSubscriber(CompletableSource.Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(cancellable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void onError(Throwable t) {
            boolean predicateResult;
            try {
                predicateResult = OnErrorMapCompletable.this.predicate.test(t);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (predicateResult) {
                Throwable mappedCause;
                try {
                    mappedCause = (Throwable)Objects.requireNonNull(OnErrorMapCompletable.this.mapper.apply(t));
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return;
                }
                this.subscriber.onError(mappedCause);
            } else {
                this.subscriber.onError(t);
            }
        }
    }
}

