/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.GeospatialDataBoundingBox;
import org.apache.baremaps.ogcapi.model.GeospatialDataDataType;
import org.apache.baremaps.ogcapi.model.GeospatialDataPropertiesSchema;
import org.apache.baremaps.ogcapi.model.GeospatialDataStyle;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileSetCrs;

@JsonTypeName(value="geospatialData")
public class GeospatialData {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private String keywords;
    @Valid
    private String id;
    @Valid
    private GeospatialDataDataType dataType;
    @Valid
    private Integer geometryDimension;
    @Valid
    private String featureType;
    @Valid
    private String attribution;
    @Valid
    private String license;
    @Valid
    private String pointOfContact;
    @Valid
    private String publisher;
    @Valid
    private String theme;
    @Valid
    private TileSetCrs crs;
    @Valid
    private BigDecimal epoch;
    @Valid
    private BigDecimal minScaleDenominator;
    @Valid
    private BigDecimal maxScaleDenominator;
    @Valid
    private BigDecimal minCellSize;
    @Valid
    private BigDecimal maxCellSize;
    @Valid
    private String maxTileMatrix;
    @Valid
    private String minTileMatrix;
    @Valid
    private GeospatialDataBoundingBox boundingBox;
    @Valid
    private Object created;
    @Valid
    private Object updated;
    @Valid
    private GeospatialDataStyle style;
    @Valid
    private List<String> geoDataClasses = null;
    @Valid
    private GeospatialDataPropertiesSchema propertiesSchema;
    @Valid
    private List<Link> links = null;

    public GeospatialData title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title of this tile matrix set, normally used for display to a human")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public GeospatialData description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Brief narrative description of this tile matrix set, normally available for display to a human")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public GeospatialData keywords(String keywords) {
        this.keywords = keywords;
        return this;
    }

    @ApiModelProperty(value="Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this layer")
    @JsonProperty(value="keywords")
    public String getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public GeospatialData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the Layer. Implementation of 'identifier'")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public GeospatialData dataType(GeospatialDataDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dataType")
    @NotNull
    public GeospatialDataDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(GeospatialDataDataType dataType) {
        this.dataType = dataType;
    }

    public GeospatialData geometryDimension(Integer geometryDimension) {
        this.geometryDimension = geometryDimension;
        return this;
    }

    @ApiModelProperty(value="The geometry dimension of the features shown in this layer (0: points, 1: curves, 2: surfaces, 3: solids), unspecified: mixed or unknown")
    @JsonProperty(value="geometryDimension")
    @Min(value=0L)
    @Max(value=3L)
    public @Min(value=0L) @Max(value=3L) Integer getGeometryDimension() {
        return this.geometryDimension;
    }

    @JsonProperty(value="geometryDimension")
    public void setGeometryDimension(Integer geometryDimension) {
        this.geometryDimension = geometryDimension;
    }

    public GeospatialData featureType(String featureType) {
        this.featureType = featureType;
        return this;
    }

    @ApiModelProperty(value="Feature type identifier. Only applicable to layers of datatype 'geometries'")
    @JsonProperty(value="featureType")
    public String getFeatureType() {
        return this.featureType;
    }

    @JsonProperty(value="featureType")
    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public GeospatialData attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @ApiModelProperty(value="Short reference to recognize the author or provider")
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    @JsonProperty(value="attribution")
    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public GeospatialData license(String license) {
        this.license = license;
        return this;
    }

    @ApiModelProperty(value="License applicable to the tiles")
    @JsonProperty(value="license")
    public String getLicense() {
        return this.license;
    }

    @JsonProperty(value="license")
    public void setLicense(String license) {
        this.license = license;
    }

    public GeospatialData pointOfContact(String pointOfContact) {
        this.pointOfContact = pointOfContact;
        return this;
    }

    @ApiModelProperty(value="Useful information to contact the authors or custodians for the layer (e.g. e-mail address, a physical address,  phone numbers, etc)")
    @JsonProperty(value="pointOfContact")
    public String getPointOfContact() {
        return this.pointOfContact;
    }

    @JsonProperty(value="pointOfContact")
    public void setPointOfContact(String pointOfContact) {
        this.pointOfContact = pointOfContact;
    }

    public GeospatialData publisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    @ApiModelProperty(value="Organization or individual responsible for making the layer available")
    @JsonProperty(value="publisher")
    public String getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public GeospatialData theme(String theme) {
        this.theme = theme;
        return this;
    }

    @ApiModelProperty(value="Category where the layer can be grouped")
    @JsonProperty(value="theme")
    public String getTheme() {
        return this.theme;
    }

    @JsonProperty(value="theme")
    public void setTheme(String theme) {
        this.theme = theme;
    }

    public GeospatialData crs(TileSetCrs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="crs")
    public TileSetCrs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(TileSetCrs crs) {
        this.crs = crs;
    }

    public GeospatialData epoch(BigDecimal epoch) {
        this.epoch = epoch;
        return this;
    }

    @ApiModelProperty(value="Epoch of the Coordinate Reference System (CRS)")
    @JsonProperty(value="epoch")
    public BigDecimal getEpoch() {
        return this.epoch;
    }

    @JsonProperty(value="epoch")
    public void setEpoch(BigDecimal epoch) {
        this.epoch = epoch;
    }

    public GeospatialData minScaleDenominator(BigDecimal minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
        return this;
    }

    @ApiModelProperty(value="Minimum scale denominator for usage of the layer")
    @JsonProperty(value="minScaleDenominator")
    public BigDecimal getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    @JsonProperty(value="minScaleDenominator")
    public void setMinScaleDenominator(BigDecimal minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
    }

    public GeospatialData maxScaleDenominator(BigDecimal maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
        return this;
    }

    @ApiModelProperty(value="Maximum scale denominator for usage of the layer")
    @JsonProperty(value="maxScaleDenominator")
    public BigDecimal getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    @JsonProperty(value="maxScaleDenominator")
    public void setMaxScaleDenominator(BigDecimal maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
    }

    public GeospatialData minCellSize(BigDecimal minCellSize) {
        this.minCellSize = minCellSize;
        return this;
    }

    @ApiModelProperty(value="Minimum cell size for usage of the layer")
    @JsonProperty(value="minCellSize")
    public BigDecimal getMinCellSize() {
        return this.minCellSize;
    }

    @JsonProperty(value="minCellSize")
    public void setMinCellSize(BigDecimal minCellSize) {
        this.minCellSize = minCellSize;
    }

    public GeospatialData maxCellSize(BigDecimal maxCellSize) {
        this.maxCellSize = maxCellSize;
        return this;
    }

    @ApiModelProperty(value="Maximum cell size for usage of the layer")
    @JsonProperty(value="maxCellSize")
    public BigDecimal getMaxCellSize() {
        return this.maxCellSize;
    }

    @JsonProperty(value="maxCellSize")
    public void setMaxCellSize(BigDecimal maxCellSize) {
        this.maxCellSize = maxCellSize;
    }

    public GeospatialData maxTileMatrix(String maxTileMatrix) {
        this.maxTileMatrix = maxTileMatrix;
        return this;
    }

    @ApiModelProperty(value="TileMatrix identifier associated with the minScaleDenominator")
    @JsonProperty(value="maxTileMatrix")
    public String getMaxTileMatrix() {
        return this.maxTileMatrix;
    }

    @JsonProperty(value="maxTileMatrix")
    public void setMaxTileMatrix(String maxTileMatrix) {
        this.maxTileMatrix = maxTileMatrix;
    }

    public GeospatialData minTileMatrix(String minTileMatrix) {
        this.minTileMatrix = minTileMatrix;
        return this;
    }

    @ApiModelProperty(value="TileMatrix identifier associated with the maxScaleDenominator")
    @JsonProperty(value="minTileMatrix")
    public String getMinTileMatrix() {
        return this.minTileMatrix;
    }

    @JsonProperty(value="minTileMatrix")
    public void setMinTileMatrix(String minTileMatrix) {
        this.minTileMatrix = minTileMatrix;
    }

    public GeospatialData boundingBox(GeospatialDataBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="boundingBox")
    public GeospatialDataBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @JsonProperty(value="boundingBox")
    public void setBoundingBox(GeospatialDataBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public GeospatialData created(Object created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="created")
    public Object getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(Object created) {
        this.created = created;
    }

    public GeospatialData updated(Object updated) {
        this.updated = updated;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="updated")
    public Object getUpdated() {
        return this.updated;
    }

    @JsonProperty(value="updated")
    public void setUpdated(Object updated) {
        this.updated = updated;
    }

    public GeospatialData style(GeospatialDataStyle style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="style")
    public GeospatialDataStyle getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    public void setStyle(GeospatialDataStyle style) {
        this.style = style;
    }

    public GeospatialData geoDataClasses(List<String> geoDataClasses) {
        this.geoDataClasses = geoDataClasses;
        return this;
    }

    @ApiModelProperty(value="URI identifying a class of data contained in this layer (useful to determine compatibility with styles or processes)")
    @JsonProperty(value="geoDataClasses")
    public List<String> getGeoDataClasses() {
        return this.geoDataClasses;
    }

    @JsonProperty(value="geoDataClasses")
    public void setGeoDataClasses(List<String> geoDataClasses) {
        this.geoDataClasses = geoDataClasses;
    }

    public GeospatialData addGeoDataClassesItem(String geoDataClassesItem) {
        if (this.geoDataClasses == null) {
            this.geoDataClasses = new ArrayList<String>();
        }
        this.geoDataClasses.add(geoDataClassesItem);
        return this;
    }

    public GeospatialData removeGeoDataClassesItem(String geoDataClassesItem) {
        if (geoDataClassesItem != null && this.geoDataClasses != null) {
            this.geoDataClasses.remove(geoDataClassesItem);
        }
        return this;
    }

    public GeospatialData propertiesSchema(GeospatialDataPropertiesSchema propertiesSchema) {
        this.propertiesSchema = propertiesSchema;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="propertiesSchema")
    public GeospatialDataPropertiesSchema getPropertiesSchema() {
        return this.propertiesSchema;
    }

    @JsonProperty(value="propertiesSchema")
    public void setPropertiesSchema(GeospatialDataPropertiesSchema propertiesSchema) {
        this.propertiesSchema = propertiesSchema;
    }

    public GeospatialData links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="Links related to this layer. Possible link 'rel' values are: 'geodata' for a URL pointing to the collection of geospatial data.")
    @JsonProperty(value="links")
    @Size(min=1)
    public @Size(min=1) List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public GeospatialData addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public GeospatialData removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeospatialData geospatialData = (GeospatialData)o;
        return Objects.equals(this.title, geospatialData.title) && Objects.equals(this.description, geospatialData.description) && Objects.equals(this.keywords, geospatialData.keywords) && Objects.equals(this.id, geospatialData.id) && Objects.equals(this.dataType, geospatialData.dataType) && Objects.equals(this.geometryDimension, geospatialData.geometryDimension) && Objects.equals(this.featureType, geospatialData.featureType) && Objects.equals(this.attribution, geospatialData.attribution) && Objects.equals(this.license, geospatialData.license) && Objects.equals(this.pointOfContact, geospatialData.pointOfContact) && Objects.equals(this.publisher, geospatialData.publisher) && Objects.equals(this.theme, geospatialData.theme) && Objects.equals(this.crs, geospatialData.crs) && Objects.equals(this.epoch, geospatialData.epoch) && Objects.equals(this.minScaleDenominator, geospatialData.minScaleDenominator) && Objects.equals(this.maxScaleDenominator, geospatialData.maxScaleDenominator) && Objects.equals(this.minCellSize, geospatialData.minCellSize) && Objects.equals(this.maxCellSize, geospatialData.maxCellSize) && Objects.equals(this.maxTileMatrix, geospatialData.maxTileMatrix) && Objects.equals(this.minTileMatrix, geospatialData.minTileMatrix) && Objects.equals(this.boundingBox, geospatialData.boundingBox) && Objects.equals(this.created, geospatialData.created) && Objects.equals(this.updated, geospatialData.updated) && Objects.equals(this.style, geospatialData.style) && Objects.equals(this.geoDataClasses, geospatialData.geoDataClasses) && Objects.equals(this.propertiesSchema, geospatialData.propertiesSchema) && Objects.equals(this.links, geospatialData.links);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.keywords, this.id, this.dataType, this.geometryDimension, this.featureType, this.attribution, this.license, this.pointOfContact, this.publisher, this.theme, this.crs, this.epoch, this.minScaleDenominator, this.maxScaleDenominator, this.minCellSize, this.maxCellSize, this.maxTileMatrix, this.minTileMatrix, this.boundingBox, this.created, this.updated, this.style, this.geoDataClasses, this.propertiesSchema, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeospatialData {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    geometryDimension: ").append(this.toIndentedString(this.geometryDimension)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString(this.featureType)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    license: ").append(this.toIndentedString(this.license)).append("\n");
        sb.append("    pointOfContact: ").append(this.toIndentedString(this.pointOfContact)).append("\n");
        sb.append("    publisher: ").append(this.toIndentedString(this.publisher)).append("\n");
        sb.append("    theme: ").append(this.toIndentedString(this.theme)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    epoch: ").append(this.toIndentedString(this.epoch)).append("\n");
        sb.append("    minScaleDenominator: ").append(this.toIndentedString(this.minScaleDenominator)).append("\n");
        sb.append("    maxScaleDenominator: ").append(this.toIndentedString(this.maxScaleDenominator)).append("\n");
        sb.append("    minCellSize: ").append(this.toIndentedString(this.minCellSize)).append("\n");
        sb.append("    maxCellSize: ").append(this.toIndentedString(this.maxCellSize)).append("\n");
        sb.append("    maxTileMatrix: ").append(this.toIndentedString(this.maxTileMatrix)).append("\n");
        sb.append("    minTileMatrix: ").append(this.toIndentedString(this.minTileMatrix)).append("\n");
        sb.append("    boundingBox: ").append(this.toIndentedString(this.boundingBox)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    geoDataClasses: ").append(this.toIndentedString(this.geoDataClasses)).append("\n");
        sb.append("    propertiesSchema: ").append(this.toIndentedString(this.propertiesSchema)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

