/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.servicetalk.tcp.netty.internal.AbstractTcpConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import java.net.SocketOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TcpServerConfig
extends AbstractTcpConfig<ServerSslConfig> {
    @Nullable
    private Map<ChannelOption, Object> listenOptions;
    private TransportObserver transportObserver = NoopTransportObserver.INSTANCE;
    @Nullable
    private Map<String, ServerSslConfig> sniConfig;

    TransportObserver transportObserver() {
        return this.transportObserver;
    }

    @Nullable
    public Map<String, ServerSslConfig> sniConfig() {
        return this.sniConfig;
    }

    @Nullable
    Map<ChannelOption, Object> listenOptions() {
        return this.listenOptions;
    }

    public void transportObserver(TransportObserver transportObserver) {
        this.transportObserver = Objects.requireNonNull(transportObserver);
    }

    public TcpServerConfig sslConfig(ServerSslConfig defaultSslConfig, Map<String, ServerSslConfig> sniConfig) {
        this.sslConfig(defaultSslConfig);
        this.sniConfig = Objects.requireNonNull(sniConfig);
        return this;
    }

    public <T> void listenSocketOption(SocketOption<T> option, T value) {
        if (this.listenOptions == null) {
            this.listenOptions = new HashMap<ChannelOption, Object>();
        }
        SocketOptionUtils.addOption(this.listenOptions, option, value);
    }

    public ReadOnlyTcpServerConfig asReadOnly() {
        return new ReadOnlyTcpServerConfig(this);
    }
}

