/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import java.util.Arrays;
import java.util.Objects;
import org.apache.amoro.utils.map.SizeEstimator;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.lucene.util.RamUsageEstimator;

public class StructLikeWrapperSizeEstimator
implements SizeEstimator<StructLikeWrapper> {
    @Override
    public long sizeEstimate(StructLikeWrapper structLikeWrapper) {
        if (structLikeWrapper == null) {
            return 0L;
        }
        StructLike structLike = structLikeWrapper.get();
        return this.sizeOf(this.structLikeObjects(structLike));
    }

    private long sizeOf(Object[] objects) {
        if (objects == null) {
            return 0L;
        }
        return Arrays.stream(objects).filter(Objects::nonNull).mapToLong(object -> {
            if (object.getClass().isArray()) {
                return this.sizeOf((Object[])object);
            }
            return RamUsageEstimator.sizeOfObject((Object)object, (long)0L);
        }).sum();
    }

    private Object[] structLikeObjects(StructLike structLike) {
        if (structLike == null) {
            return null;
        }
        Object[] values = new Object[structLike.size()];
        for (int i = 0; i < values.length; ++i) {
            Object value = structLike.get(i, Object.class);
            values[i] = value instanceof StructLike ? this.structLikeObjects((StructLike)value) : value;
        }
        return values;
    }
}

