/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.suggestions;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsConfigurationSuggestions {
    private static final String VM_PARAMS_BASE_PATH = "/proc/sys/vm/";
    private static final String DIRTY_WRITEBACK_CENTISECS = "dirty_writeback_centisecs";
    private static final String DIRTY_EXPIRE_CENTISECS = "dirty_expire_centisecs";
    private static final String SWAPPINESS = "swappiness";
    private static final String ZONE_RECLAIM_MODE = "zone_reclaim_mode";
    private static final String EXTRA_FREE_KBYTES = "extra_free_kbytes";

    public static synchronized List<String> getSuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (U.isLinux()) {
            boolean decParamFlag;
            int exp = 500;
            Integer val = OsConfigurationSuggestions.readVmParam(DIRTY_WRITEBACK_CENTISECS);
            boolean dwcParamFlag = val != null && val > exp;
            val = OsConfigurationSuggestions.readVmParam(DIRTY_EXPIRE_CENTISECS);
            boolean bl = decParamFlag = val != null && val > exp;
            if (dwcParamFlag || decParamFlag) {
                suggestions.add(String.format("Speed up flushing of dirty pages by OS (alter %s%s%s parameter%s by setting to %d)", dwcParamFlag ? "vm.dirty_writeback_centisecs" : "", dwcParamFlag && decParamFlag ? " and " : "", decParamFlag ? "vm.dirty_expire_centisecs" : "", dwcParamFlag && decParamFlag ? "s" : "", exp));
            }
            if ((val = OsConfigurationSuggestions.readVmParam(SWAPPINESS)) != null) {
                try {
                    int maxSwappiness = 10;
                    if (val > maxSwappiness) {
                        suggestions.add(String.format("Reduce pages swapping ratio (set vm.%s=%d or less)", SWAPPINESS, maxSwappiness));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((val = OsConfigurationSuggestions.readVmParam(ZONE_RECLAIM_MODE)) != null) {
                exp = 0;
                if (val > 0) {
                    suggestions.add(String.format("Disable NUMA memory reclaim (set vm.%s=%d)", ZONE_RECLAIM_MODE, exp));
                }
            }
            if ((val = OsConfigurationSuggestions.readVmParam(EXTRA_FREE_KBYTES)) != null) {
                exp = 1240000;
                if (val < 1240000) {
                    suggestions.add(String.format("Avoid direct reclaim and page allocation failures (set vm.%s=%d)", EXTRA_FREE_KBYTES, exp));
                }
            }
        }
        return suggestions;
    }

    @Nullable
    private static Integer readVmParam(@NotNull String name) {
        try {
            Path path = Paths.get(VM_PARAMS_BASE_PATH + name, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return Integer.parseInt(OsConfigurationSuggestions.readLine(path));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    private static String readLine(@NotNull Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String string = reader.readLine();
            return string;
        }
    }

    public String toString() {
        return S.toString(OsConfigurationSuggestions.class, this);
    }
}

