/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBasicTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlTypeName sqlTypeName;
    private final int precision;
    private final int scale;
    private final @Nullable String charSetName;

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, int scale, @Nullable String charSetName, SqlParserPos pos) {
        super(new SqlIdentifier(typeName.name(), pos), pos);
        this.sqlTypeName = typeName;
        this.precision = precision;
        this.scale = scale;
        this.charSetName = charSetName;
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, SqlParserPos pos) {
        this(typeName, -1, Integer.MIN_VALUE, null, pos);
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, SqlParserPos pos) {
        this(typeName, precision, Integer.MIN_VALUE, null, pos);
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, String charSetName, SqlParserPos pos) {
        this(typeName, precision, Integer.MIN_VALUE, charSetName, pos);
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, int scale, SqlParserPos pos) {
        this(typeName, precision, scale, null, pos);
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public @Nullable String getCharSetName() {
        return this.charSetName;
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec node, Litmus litmus) {
        if (!(node instanceof SqlBasicTypeNameSpec)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlBasicTypeNameSpec that = (SqlBasicTypeNameSpec)node;
        if (this.sqlTypeName != that.sqlTypeName) {
            return litmus.fail("{} != {}", this, node);
        }
        if (this.precision != that.precision) {
            return litmus.fail("{} != {}", this, node);
        }
        if (this.scale != that.scale) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!Objects.equals(this.charSetName, that.charSetName)) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        boolean isWithTimeZone = SqlBasicTypeNameSpec.isWithTimeZoneDef(this.sqlTypeName);
        if (isWithTimeZone) {
            writer.keyword(SqlBasicTypeNameSpec.stripTimeZoneDef(this.sqlTypeName).name());
        } else {
            writer.keyword(this.getTypeName().getSimple());
        }
        if (this.sqlTypeName.allowsPrec() && this.precision != -1) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            writer.print(this.precision);
            if (this.sqlTypeName.allowsScale() && this.scale != Integer.MIN_VALUE) {
                writer.sep(",", true);
                writer.print(this.scale);
            }
            writer.endList(frame);
        }
        if (isWithTimeZone) {
            writer.keyword("WITH");
            if (SqlBasicTypeNameSpec.isWithLocalTimeZoneDef(this.sqlTypeName)) {
                writer.keyword("LOCAL");
            }
            writer.keyword("TIME ZONE");
        }
        if (writer.getDialect().supportsCharSet() && this.charSetName != null) {
            writer.keyword("CHARACTER SET");
            writer.identifier(this.charSetName, true);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        RelDataType type;
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        if (this.precision != -1 && this.scale != Integer.MIN_VALUE) {
            assert (this.sqlTypeName.allowsPrecScale(true, true));
            type = typeFactory.createSqlType(this.sqlTypeName, this.precision, this.scale);
        } else if (this.precision != -1) {
            assert (this.sqlTypeName.allowsPrecNoScale());
            type = typeFactory.createSqlType(this.sqlTypeName, this.precision);
        } else {
            assert (this.sqlTypeName.allowsNoPrecNoScale());
            type = typeFactory.createSqlType(this.sqlTypeName);
        }
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset charset;
            SqlCollation collation = SqlCollation.COERCIBLE;
            if (null == this.charSetName) {
                charset = typeFactory.getDefaultCharset();
            } else {
                String javaCharSetName = Objects.requireNonNull(SqlUtil.translateCharacterSetName(this.charSetName), this.charSetName);
                charset = Charset.forName(javaCharSetName);
            }
            type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        }
        return type;
    }

    private static boolean isWithLocalTimeZoneDef(SqlTypeName typeName) {
        switch (typeName) {
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return true;
            }
        }
        return false;
    }

    private static boolean isWithTimeZoneDef(SqlTypeName typeName) {
        return SqlTypeName.TZ_TYPES.contains((Object)typeName);
    }

    private static SqlTypeName stripTimeZoneDef(SqlTypeName typeName) {
        switch (typeName) {
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIME_TZ: {
                return SqlTypeName.TIME;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_TZ: {
                return SqlTypeName.TIMESTAMP;
            }
        }
        throw new AssertionError((Object)typeName);
    }
}

