/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.executor;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.compute.task.MapReduceTask;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.ExecutionOptions;
import org.apache.ignite.internal.compute.JobExecutionContextImpl;
import org.apache.ignite.internal.compute.SharedComputeUtils;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.compute.executor.ComputeExecutor;
import org.apache.ignite.internal.compute.executor.JobExecutionInternal;
import org.apache.ignite.internal.compute.loader.JobClassLoader;
import org.apache.ignite.internal.compute.queue.PriorityQueueExecutor;
import org.apache.ignite.internal.compute.queue.QueueExecution;
import org.apache.ignite.internal.compute.state.ComputeStateMachine;
import org.apache.ignite.internal.compute.task.JobSubmitter;
import org.apache.ignite.internal.compute.task.TaskExecutionContextImpl;
import org.apache.ignite.internal.compute.task.TaskExecutionInternal;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

public class ComputeExecutorImpl
implements ComputeExecutor {
    private static final IgniteLogger LOG = Loggers.forClass(ComputeExecutorImpl.class);
    private final Ignite ignite;
    private final ComputeConfiguration configuration;
    private final ComputeStateMachine stateMachine;
    private final TopologyService topologyService;
    private PriorityQueueExecutor executorService;

    public ComputeExecutorImpl(Ignite ignite, ComputeStateMachine stateMachine, ComputeConfiguration configuration, TopologyService topologyService) {
        this.ignite = ignite;
        this.configuration = configuration;
        this.stateMachine = stateMachine;
        this.topologyService = topologyService;
    }

    @Override
    public <T, R> JobExecutionInternal<ComputeJobDataHolder> executeJob(ExecutionOptions options, Class<? extends ComputeJob<T, R>> jobClass, JobClassLoader classLoader, ComputeJobDataHolder input) {
        assert (this.executorService != null);
        AtomicBoolean isInterrupted = new AtomicBoolean();
        JobExecutionContextImpl context = new JobExecutionContextImpl(this.ignite, isInterrupted, classLoader, options.partition());
        ComputeJob jobInstance = ComputeUtils.instantiateJob(jobClass);
        Marshaller inputMarshaller = jobInstance.inputMarshaller();
        Marshaller resultMarshaller = jobInstance.resultMarshaller();
        QueueExecution<ComputeJobDataHolder> execution = this.executorService.submit(ComputeExecutorImpl.unmarshalExecMarshal(input, jobClass, jobInstance, context, inputMarshaller, resultMarshaller), options.priority(), options.maxRetries());
        return new JobExecutionInternal<ComputeJobDataHolder>(execution, isInterrupted, null, false, this.topologyService.localMember());
    }

    private static <T, R> Callable<CompletableFuture<ComputeJobDataHolder>> unmarshalExecMarshal(ComputeJobDataHolder input, Class<? extends ComputeJob<T, R>> jobClass, ComputeJob<T, R> jobInstance, JobExecutionContext context, @Nullable Marshaller<T, byte[]> inputMarshaller, @Nullable Marshaller<R, byte[]> resultMarshaller) {
        return () -> {
            CompletableFuture userJobFut = jobInstance.executeAsync(context, ComputeUtils.unmarshalOrNotIfNull(inputMarshaller, input, ComputeUtils.getJobExecuteArgumentType(jobClass)));
            return userJobFut == null ? null : userJobFut.thenApply(r -> SharedComputeUtils.marshalArgOrResult((Object)r, (Marshaller)resultMarshaller));
        };
    }

    @Override
    public <I, M, T, R> TaskExecutionInternal<I, M, T, R> executeTask(JobSubmitter<M, T> jobSubmitter, Class<? extends MapReduceTask<I, M, T, R>> taskClass, I input) {
        assert (this.executorService != null);
        AtomicBoolean isCancelled = new AtomicBoolean();
        TaskExecutionContextImpl context = new TaskExecutionContextImpl(this.ignite, isCancelled);
        return new TaskExecutionInternal(this.executorService, jobSubmitter, taskClass, context, isCancelled, input);
    }

    @Override
    public void start() {
        this.stateMachine.start();
        this.executorService = new PriorityQueueExecutor(this.configuration, IgniteThreadFactory.create((String)this.ignite.name(), (String)"compute", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}), this.stateMachine);
    }

    @Override
    public void stop() {
        this.stateMachine.stop();
        this.executorService.shutdown();
    }
}

