/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity.codec.v1;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite.raft.jraft.util.Bits;
import org.jetbrains.annotations.Nullable;

public final class V1Encoder
implements LogEntryEncoder {
    public static final V1Encoder INSTANCE = new V1Encoder();

    private V1Encoder() {
    }

    public int size(LogEntry logEntry) {
        EnumOutter.EntryType type = logEntry.getType();
        LogId id = logEntry.getId();
        List<PeerId> peers = logEntry.getPeers();
        List<PeerId> oldPeers = logEntry.getOldPeers();
        List<PeerId> learners = logEntry.getLearners();
        List<PeerId> oldLearners = logEntry.getOldLearners();
        ByteBuffer data = logEntry.getData();
        int totalLen = 1;
        int typeNumber = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        totalLen += V1Encoder.sizeInBytes(typeNumber) + V1Encoder.sizeInBytes(index) + V1Encoder.sizeInBytes(term) + 8;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            totalLen += V1Encoder.nodesListSizeInBytes(peers);
            totalLen += V1Encoder.nodesListSizeInBytes(oldPeers);
            totalLen += V1Encoder.nodesListSizeInBytes(learners);
            totalLen += V1Encoder.nodesListSizeInBytes(oldLearners);
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
            int bodyLen = data != null ? data.remaining() : 0;
            totalLen += bodyLen;
        }
        return totalLen;
    }

    public void append(long addr, LogEntry logEntry) {
        EnumOutter.EntryType type = logEntry.getType();
        LogId id = logEntry.getId();
        List<PeerId> peers = logEntry.getPeers();
        List<PeerId> oldPeers = logEntry.getOldPeers();
        List<PeerId> learners = logEntry.getLearners();
        List<PeerId> oldLearners = logEntry.getOldLearners();
        ByteBuffer data = logEntry.getData();
        int typeNumber = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        GridUnsafe.putByte((long)addr++, (byte)-72);
        addr = V1Encoder.writeLong(typeNumber, addr);
        addr = V1Encoder.writeLong(index, addr);
        addr = V1Encoder.writeLong(term, addr);
        Bits.putLongLittleEndian(addr, logEntry.getChecksum());
        addr += 8L;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            addr = V1Encoder.writeNodesList(addr, peers);
            addr = V1Encoder.writeNodesList(addr, oldPeers);
            addr = V1Encoder.writeNodesList(addr, learners);
            addr = V1Encoder.writeNodesList(addr, oldLearners);
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION && data != null) {
            GridUnsafe.copyHeapOffheap((Object)data.array(), (long)((long)data.position() + GridUnsafe.BYTE_ARR_OFF), (long)addr, (long)data.remaining());
        }
    }

    @Override
    public byte[] encode(LogEntry log) {
        EnumOutter.EntryType type = log.getType();
        LogId id = log.getId();
        List<PeerId> peers = log.getPeers();
        List<PeerId> oldPeers = log.getOldPeers();
        List<PeerId> learners = log.getLearners();
        List<PeerId> oldLearners = log.getOldLearners();
        ByteBuffer data = log.getData();
        int typeNumber = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        int totalLen = this.size(log);
        byte[] content = new byte[totalLen];
        content[0] = -72;
        int pos = 1;
        pos = V1Encoder.writeLong(typeNumber, content, pos);
        pos = V1Encoder.writeLong(index, content, pos);
        pos = V1Encoder.writeLong(term, content, pos);
        Bits.putLongLittleEndian(content, pos, log.getChecksum());
        pos += 8;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            pos = V1Encoder.writeNodesList(pos, content, peers);
            pos = V1Encoder.writeNodesList(pos, content, oldPeers);
            pos = V1Encoder.writeNodesList(pos, content, learners);
            pos = V1Encoder.writeNodesList(pos, content, oldLearners);
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION && data != null) {
            System.arraycopy(data.array(), data.position(), content, pos, data.remaining());
        }
        return content;
    }

    private static int nodesListSizeInBytes(@Nullable List<PeerId> nodes) {
        if (nodes == null) {
            return 1;
        }
        int size = 0;
        for (PeerId node : nodes) {
            String consistentId = node.getConsistentId();
            size += 2 + consistentId.length() + V1Encoder.sizeInBytes(node.getIdx()) + V1Encoder.sizeInBytes(node.getPriority() + 1);
        }
        return size + V1Encoder.sizeInBytes(nodes.size());
    }

    private static long writeNodesList(long addr, List<PeerId> nodes) {
        if (nodes == null) {
            return V1Encoder.writeLong(0L, addr);
        }
        addr = V1Encoder.writeLong(nodes.size(), addr);
        for (PeerId node : nodes) {
            String nodeStr = node.getConsistentId();
            int length = nodeStr.length();
            Bits.putShortLittleEndian(addr, (short)length);
            addr += 2L;
            for (int i = 0; i < length; ++i) {
                GridUnsafe.putByte((long)(addr + (long)i), (byte)((byte)nodeStr.charAt(i)));
            }
            addr += (long)length;
            addr = V1Encoder.writeLong(node.getIdx(), addr);
            addr = V1Encoder.writeLong(node.getPriority() + 1, addr);
        }
        return addr;
    }

    private static int writeNodesList(int pos, byte[] content, List<PeerId> nodeStrs) {
        if (nodeStrs == null) {
            content[pos] = 0;
            return pos + 1;
        }
        pos = V1Encoder.writeLong(nodeStrs.size(), content, pos);
        for (PeerId peerId : nodeStrs) {
            String consistentId = peerId.getConsistentId();
            int length = consistentId.length();
            Bits.putShortLittleEndian(content, pos, (short)length);
            AsciiStringUtil.unsafeEncode(consistentId, content, pos += 2);
            pos += length;
            pos = V1Encoder.writeLong(peerId.getIdx(), content, pos);
            pos = V1Encoder.writeLong(peerId.getPriority() + 1, content, pos);
        }
        return pos;
    }

    private static int writeLong(long val, byte[] out, int pos) {
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(val | 0x80L);
            out[pos++] = b;
            val >>>= 7;
        }
        out[pos++] = (byte)val;
        return pos;
    }

    private static long writeLong(long val, long addr) {
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(val | 0x80L);
            GridUnsafe.putByte((long)addr++, (byte)b);
            val >>>= 7;
        }
        GridUnsafe.putByte((long)addr++, (byte)((byte)val));
        return addr;
    }

    private static int sizeInBytes(long val) {
        if (val >= 0L) {
            if (val < 128L) {
                return 1;
            }
            if (val < 16384L) {
                return 2;
            }
            if (val < 0x200000L) {
                return 3;
            }
            if (val < 0x10000000L) {
                return 4;
            }
            if (val < 0x800000000L) {
                return 5;
            }
            if (val < 0x40000000000L) {
                return 6;
            }
            if (val < 0x2000000000000L) {
                return 7;
            }
            if (val < 0x100000000000000L) {
                return 8;
            }
            return 9;
        }
        return 10;
    }
}

