/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CommunicationFailureContext;
import org.apache.ignite.internal.cluster.graph.BitSetIterator;
import org.apache.ignite.internal.cluster.graph.FullyConnectedComponentSearcher;

public class ClusterGraph {
    private final int nodeCnt;
    private final List<ClusterNode> nodes;
    private final BitSet[] connections;
    private final FullyConnectedComponentSearcher fccSearcher;

    public ClusterGraph(CommunicationFailureContext ctx, Predicate<ClusterNode> nodeFilterOut) {
        this.nodes = ctx.topologySnapshot();
        this.nodeCnt = this.nodes.size();
        assert (this.nodeCnt > 0);
        this.connections = this.buildConnectivityMatrix(ctx, nodeFilterOut);
        this.fccSearcher = new FullyConnectedComponentSearcher(this.connections);
    }

    private BitSet[] buildConnectivityMatrix(CommunicationFailureContext ctx, Predicate<ClusterNode> nodeFilterOut) {
        int i;
        BitSet[] connections = new BitSet[this.nodeCnt];
        for (i = 0; i < this.nodeCnt; ++i) {
            ClusterNode node = this.nodes.get(i);
            if (nodeFilterOut.test(node)) {
                connections[i] = null;
                continue;
            }
            connections[i] = new BitSet(this.nodeCnt);
            for (int j = 0; j < this.nodeCnt; ++j) {
                ClusterNode to = this.nodes.get(j);
                if (nodeFilterOut.test(to) || i != j && !ctx.connectionAvailable(node, to)) continue;
                connections[i].set(j);
            }
        }
        for (i = 0; i < this.nodeCnt; ++i) {
            for (int j = i + 1; j < this.nodeCnt; ++j) {
                if (connections[i] == null || connections[j] == null || !(connections[i].get(j) ^ connections[j].get(i))) continue;
                connections[i].set(j, false);
                connections[j].set(i, false);
            }
        }
        return connections;
    }

    public List<BitSet> findConnectedComponents() {
        ArrayList<BitSet> connectedComponets = new ArrayList<BitSet>();
        BitSet visitSet = new BitSet(this.nodeCnt);
        for (int i = 0; i < this.nodeCnt; ++i) {
            if (visitSet.get(i) || this.connections[i] == null) continue;
            BitSet currComponent = new BitSet(this.nodeCnt);
            this.dfs(i, currComponent, visitSet);
            connectedComponets.add(currComponent);
        }
        return connectedComponets;
    }

    private void dfs(int nodeIdx, BitSet currComponent, BitSet allVisitSet) {
        assert (!allVisitSet.get(nodeIdx)) : "Incorrect node visit " + nodeIdx;
        assert (this.connections[nodeIdx] != null) : "Incorrect node visit. Node has not passed filter " + this.nodes.get(nodeIdx);
        allVisitSet.set(nodeIdx);
        currComponent.set(nodeIdx);
        for (int toIdx = 0; toIdx < this.nodeCnt; ++toIdx) {
            boolean connected;
            if (toIdx == nodeIdx || allVisitSet.get(toIdx) || this.connections[toIdx] == null) continue;
            boolean bl = connected = this.connections[nodeIdx].get(toIdx) && this.connections[toIdx].get(nodeIdx);
            if (!connected) continue;
            this.dfs(toIdx, currComponent, allVisitSet);
        }
    }

    public BitSet findLargestFullyConnectedComponent(BitSet nodesSet) {
        boolean fullyConnected = this.checkFullyConnected(nodesSet);
        if (fullyConnected) {
            return nodesSet;
        }
        BitSet res = this.fccSearcher.findLargest(nodesSet);
        assert (this.checkFullyConnected(res)) : "Not fully connected component was found [result=" + res + ", nodesSet=" + nodesSet + "]";
        return res;
    }

    public boolean checkFullyConnected(BitSet nodesSet) {
        int maxIdx = nodesSet.length();
        BitSetIterator it = new BitSetIterator(nodesSet);
        while (it.hasNext()) {
            int idx = (Integer)it.next();
            for (int i = 0; i < maxIdx; ++i) {
                if (i == idx || !nodesSet.get(i) || this.connections[idx].get(i)) continue;
                return false;
            }
        }
        return true;
    }
}

