/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.pipeline.transforms.dimensionlookup;

import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.junit.Before;
import org.junit.Test;

import java.sql.Connection;
import java.util.Date;
import java.util.List;

import static org.mockito.Matchers.anyString;
import static org.mockito.Mockito.*;

public class DimensionLookupTest {
  private DatabaseMeta databaseMeta;

  private TransformMeta transformMeta;

  private DimensionLookup dimensionLookup, dimensionLookupSpy;
  private DimensionLookupMeta dimensionLookupMeta;
  private DimensionLookupData dimensionLookupData;

  @Before
  public void setUp() throws Exception {
    databaseMeta = mock(DatabaseMeta.class);
    doReturn("").when(databaseMeta).quoteField(anyString());

    dimensionLookupMeta = mock(DimensionLookupMeta.class);
    doReturn(databaseMeta).when(dimensionLookupMeta).getDatabaseMeta();
    doReturn(new String[] {}).when(dimensionLookupMeta).getKeyLookup();
    doReturn(new String[] {}).when(dimensionLookupMeta).getFieldLookup();
    doReturn(new int[] {}).when(dimensionLookupMeta).getFieldUpdate();

    transformMeta = mock(TransformMeta.class);
    doReturn("transform").when(transformMeta).getName();
    doReturn(mock(TransformPartitioningMeta.class))
        .when(transformMeta)
        .getTargetTransformPartitioningMeta();
    doReturn(dimensionLookupMeta).when(transformMeta).getTransform();

    Database db = mock(Database.class);
    doReturn(mock(Connection.class)).when(db).getConnection();

    dimensionLookupData = mock(DimensionLookupData.class);
    dimensionLookupData.db = db;
    dimensionLookupData.keynrs = new int[] {};
    dimensionLookupData.fieldnrs = new int[] {};

    PipelineMeta pipelineMeta = mock(PipelineMeta.class);
    doReturn(transformMeta).when(pipelineMeta).findTransform(anyString());

    dimensionLookup =
        new DimensionLookup(
            transformMeta,
            dimensionLookupMeta,
            dimensionLookupData,
            1,
            pipelineMeta,
            spy(new LocalPipelineEngine()));
    // dimensionLookup.setData( dimensionLookupData );
    // dimensionLookup.setMeta( dimensionLookupMeta );
    dimensionLookupSpy = spy(dimensionLookup);
    doReturn(transformMeta).when(dimensionLookupSpy).getTransformMeta();
    doReturn(false).when(dimensionLookupSpy).isRowLevel();
    doReturn(false).when(dimensionLookupSpy).isDebug();
    doReturn(true).when(dimensionLookupSpy).isAutoIncrement();
    doNothing().when(dimensionLookupSpy).logDetailed(anyString());
  }

  @Test
  public void testDimInsert() throws Exception {
    IRowMeta iRowMeta = mock(IRowMeta.class);
    Object[] objects = mock(List.class).toArray();
    Date date = mock(Date.class);
    dimensionLookupSpy.dimInsert(iRowMeta, objects, new Long("132323"), true, null, date, date);
    verify(databaseMeta, times(0)).supportsAutoGeneratedKeys();

    dimensionLookupSpy.dimInsert(iRowMeta, objects, null, true, null, date, date);
    verify(databaseMeta, times(2)).supportsAutoGeneratedKeys();
  }
}
