/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactorThread
extends Thread
implements Configurable {
    private static final String CLASS_NAME = CompactorThread.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected HiveConf conf;
    protected AtomicBoolean stop;
    protected String hostName;
    protected String runtimeVersion;
    private static final Integer MAX_WARN_LOG_TIME = 1200000;
    protected long checkInterval = 0L;

    public void setConf(Configuration configuration) {
        this.conf = new HiveConf(configuration, HiveConf.class);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void init(AtomicBoolean stop) throws Exception {
        this.setPriority(1);
        this.setDaemon(false);
        this.stop = stop;
        this.hostName = ServerUtils.hostname();
        this.runtimeVersion = this.getRuntimeVersion();
    }

    abstract Table resolveTable(CompactionInfo var1) throws MetaException;

    protected String tableName(Table t) {
        return Warehouse.getQualifiedName((Table)t);
    }

    public static void initializeAndStartThread(CompactorThread thread, Configuration conf) {
        LOG.info("Starting compactor thread of type " + thread.getClass().getName());
        thread.setConf(conf);
        try {
            thread.init(new AtomicBoolean());
        }
        catch (Exception e) {
            throw new CompactionException(e, ErrorMsg.COMPACTION_THREAD_INITIALIZATION);
        }
        thread.start();
    }

    @VisibleForTesting
    protected String getRuntimeVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    protected void doPostLoopActions(long elapsedTime) throws InterruptedException {
        String threadTypeName = this.getClass().getName();
        if (elapsedTime < this.checkInterval && !this.stop.get()) {
            Thread.sleep(this.checkInterval - elapsedTime);
        }
        if (elapsedTime < (long)MAX_WARN_LOG_TIME.intValue()) {
            LOG.debug("{} loop took {} seconds to finish.", (Object)threadTypeName, (Object)(elapsedTime / 1000L));
        } else {
            LOG.warn("Possible {} slowdown, loop took {} seconds to finish.", (Object)threadTypeName, (Object)(elapsedTime / 1000L));
        }
    }
}

