/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;

public class HiveSemiJoinProjectTransposeRule
extends RelOptRule {
    public static final HiveSemiJoinProjectTransposeRule INSTANCE = new HiveSemiJoinProjectTransposeRule(HiveRelFactories.HIVE_BUILDER);

    private HiveSemiJoinProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(HiveSemiJoinProjectTransposeRule.operandJ(Join.class, null, Join::isSemiJoin, (RelOptRuleOperand)HiveSemiJoinProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)HiveSemiJoinProjectTransposeRule.operand(Join.class, (RelOptRuleOperandChildren)HiveSemiJoinProjectTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveSemiJoinProjectTransposeRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveSemiJoinProjectTransposeRule.any())}), relBuilderFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        Join semiJoin = (Join)call.rel(0);
        Project project = (Project)call.rel(1);
        RexNode newCondition = this.adjustCondition(project, semiJoin);
        HiveSemiJoin newSemiJoin = HiveSemiJoin.getSemiJoin(project.getCluster(), project.getTraitSet(), project.getInput(), semiJoin.getRight(), newCondition);
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)newSemiJoin);
        relBuilder.project((Iterable)project.getProjects(), (Iterable)project.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    private RexNode adjustCondition(Project project, Join semiJoin) {
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelNode rightChild = semiJoin.getRight();
        RelDataType bottomInputRowType = SqlValidatorUtil.deriveJoinRowType((RelDataType)project.getInput().getRowType(), (RelDataType)rightChild.getRowType(), (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)typeFactory, null, (List)semiJoin.getSystemFieldList());
        RexProgramBuilder bottomProgramBuilder = new RexProgramBuilder(bottomInputRowType, rexBuilder);
        for (Pair pair : project.getNamedProjects()) {
            bottomProgramBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        int nLeftFields = project.getInput().getRowType().getFieldCount();
        List rightFields = rightChild.getRowType().getFieldList();
        int nRightFields = rightFields.size();
        for (int i = 0; i < nRightFields; ++i) {
            RelDataTypeField field = (RelDataTypeField)rightFields.get(i);
            RexInputRef inputRef = rexBuilder.makeInputRef(field.getType(), i + nLeftFields);
            bottomProgramBuilder.addProject((RexNode)inputRef, field.getName());
        }
        RexProgram bottomProgram = bottomProgramBuilder.getProgram();
        RelDataType topInputRowType = SqlValidatorUtil.deriveJoinRowType((RelDataType)project.getRowType(), (RelDataType)rightChild.getRowType(), (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)typeFactory, null, (List)semiJoin.getSystemFieldList());
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(topInputRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(semiJoin.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms((RexProgram)topProgram, (RexProgram)bottomProgram, (RexBuilder)rexBuilder);
        return mergedProgram.expandLocalRef(mergedProgram.getCondition());
    }
}

