/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.exec.DataSketchesFunctions;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveRewriteToDataSketchesRules {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRewriteToDataSketchesRules.class);

    public static class RankRewriteRule
    extends AbstractRankBasedRewriteRule {
        public RankRewriteRule(String sketchType) {
            super(sketchType, "WindowingToProjectAggregateJoinProject(RankRewriteRule)");
        }

        @Override
        protected WindowingToProjectAggregateJoinProject.VbuilderPAP buildProcessor(RelOptRuleCall call) {
            return new RankRewriteBuilder(this.sketchType, call.builder());
        }

        private static class RankRewriteBuilder
        extends AbstractRankBasedRewriteRule.AbstractRankBasedRewriteBuilder {
            protected RankRewriteBuilder(String sketchClass, RelBuilder relBuilder) {
                super(sketchClass, relBuilder);
            }

            @Override
            protected boolean isApplicable1(RexOver over) {
                SqlAggFunction aggOp = over.getAggOperator();
                return aggOp.getName().equalsIgnoreCase("rank");
            }

            @Override
            protected RexNode evaluateRankValue(RexNode projRex, RexOver over, RexInputRef sketchInputRef) {
                RexNode ret = projRex;
                RexLiteral literal1 = this.relBuilder.literal((Object)1.0);
                SqlOperator getNOperator = this.getSqlOperator("n");
                RexNode n = this.rexBuilder.makeCall(getNOperator, (List)ImmutableList.of((Object)sketchInputRef));
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{ret, n});
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, new RexNode[]{ret});
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{ret, literal1});
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{this.lt(n, ret), n, ret});
                return ret;
            }

            private RexNode lt(RexNode op1, RexNode op2) {
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{op1, op2});
            }
        }
    }

    public static class NTileRewrite
    extends AbstractRankBasedRewriteRule {
        public NTileRewrite(String sketchType) {
            super(sketchType, "WindowingToProjectAggregateJoinProject(NTileRewrite)");
        }

        @Override
        protected WindowingToProjectAggregateJoinProject.VbuilderPAP buildProcessor(RelOptRuleCall call) {
            return new NTileRewriteBuilder(this.sketchType, call.builder());
        }

        private static class NTileRewriteBuilder
        extends AbstractRankBasedRewriteRule.AbstractRankBasedRewriteBuilder {
            protected NTileRewriteBuilder(String sketchClass, RelBuilder relBuilder) {
                super(sketchClass, relBuilder);
            }

            @Override
            protected boolean isApplicable1(RexOver over) {
                SqlAggFunction aggOp = over.getAggOperator();
                return aggOp.getName().equalsIgnoreCase("ntile");
            }

            @Override
            protected RexNode evaluateRankValue(RexNode projRex, RexOver over, RexInputRef sketchInputRef) {
                RexNode ntileOperand = (RexNode)over.getOperands().get(0);
                RexNode ret = projRex;
                RexLiteral literal1 = this.relBuilder.literal((Object)1.0);
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{ret, ntileOperand});
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CEIL, new RexNode[]{ret});
                ret = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{this.lt(ret, (RexNode)literal1), literal1, ret});
                return ret;
            }

            private RexNode lt(RexNode op1, RexNode op2) {
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{op1, op2});
            }
        }
    }

    public static class CumeDistRewriteRule
    extends AbstractRankBasedRewriteRule {
        public CumeDistRewriteRule(String sketchType) {
            super(sketchType, "WindowingToProjectAggregateJoinProject(CumeDistRewriteRule)");
        }

        @Override
        protected WindowingToProjectAggregateJoinProject.VbuilderPAP buildProcessor(RelOptRuleCall call) {
            return new CumeDistRewriteBuilder(this.sketchType, call.builder());
        }

        private static class CumeDistRewriteBuilder
        extends AbstractRankBasedRewriteRule.AbstractRankBasedRewriteBuilder {
            protected CumeDistRewriteBuilder(String sketchClass, RelBuilder relBuilder) {
                super(sketchClass, relBuilder);
            }

            @Override
            protected boolean isApplicable1(RexOver over) {
                SqlAggFunction aggOp = over.getAggOperator();
                return aggOp.getName().equalsIgnoreCase("cume_dist");
            }

            @Override
            protected RexNode evaluateRankValue(RexNode projRex, RexOver over, RexInputRef sketchInputRef) {
                return projRex;
            }
        }
    }

    public static abstract class AbstractRankBasedRewriteRule
    extends WindowingToProjectAggregateJoinProject {
        public AbstractRankBasedRewriteRule(String sketchType, String description) {
            super(sketchType, description);
        }

        protected static abstract class AbstractRankBasedRewriteBuilder
        extends WindowingToProjectAggregateJoinProject.VbuilderPAP {
            protected AbstractRankBasedRewriteBuilder(String sketchClass, RelBuilder relBuilder) {
                super(sketchClass, relBuilder);
            }

            @Override
            final boolean isApplicable(RexOver over) {
                RexWindow window = over.getWindow();
                if (window.orderKeys.size() == 1 && window.getLowerBound().isUnbounded() && window.getUpperBound().isUnbounded() && this.isApplicable1(over)) {
                    RelDataType type = ((RexNode)((RexFieldCollation)window.orderKeys.get(0)).getKey()).getType();
                    return type.getFamily() == SqlTypeFamily.NUMERIC;
                }
                return false;
            }

            @Override
            final RexNode rewrite(RexOver over) {
                RexWindow w = over.getWindow();
                RexFieldCollation orderKey = (RexFieldCollation)w.orderKeys.get(0);
                ImmutableList partitionKeys = w.partitionKeys;
                this.relBuilder.push(this.relBuilder.peek());
                RexNode key = (RexNode)orderKey.getKey();
                key = this.rexBuilder.makeCast(this.getFloatType(), key);
                SqlAggFunction dataToSketchFunction = (SqlAggFunction)this.getSqlOperator("sketch");
                RelBuilder.AggCall aggCall = this.relBuilder.aggregateCall(dataToSketchFunction, new RexNode[]{key}).ignoreNulls(true);
                this.relBuilder.aggregate(this.relBuilder.groupKey((Iterable)partitionKeys), new RelBuilder.AggCall[]{aggCall});
                List joinConditions = Ord.zip((List)partitionKeys).stream().map(o -> {
                    RexInputRef f = this.relBuilder.field(2, 1, o.i);
                    return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{(RexNode)o.e, f});
                }).collect(Collectors.toList());
                this.relBuilder.join(JoinRelType.INNER, joinConditions);
                int sketchFieldIndex = this.relBuilder.peek().getRowType().getFieldCount() - 1;
                RexInputRef sketchInputRef = this.relBuilder.field(sketchFieldIndex);
                SqlOperator projectOperator = this.getSqlOperator("rank");
                RexLiteral nullReplacement = this.relBuilder.literal((Object)Float.valueOf(orderKey.getNullDirection() == RelFieldCollation.NullDirection.LAST ? Float.MAX_VALUE : -3.4028235E38f));
                RexNode projRex = key;
                projRex = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, new RexNode[]{key, nullReplacement});
                projRex = this.rexBuilder.makeCast(this.getFloatType(), projRex);
                projRex = this.rexBuilder.makeCall(projectOperator, (List)ImmutableList.of((Object)sketchInputRef, (Object)projRex));
                projRex = this.evaluateRankValue(projRex, over, sketchInputRef);
                projRex = this.rexBuilder.makeCast(over.getType(), projRex);
                return projRex;
            }

            protected abstract boolean isApplicable1(RexOver var1);

            protected abstract RexNode evaluateRankValue(RexNode var1, RexOver var2, RexInputRef var3);
        }
    }

    private static abstract class WindowingToProjectAggregateJoinProject
    extends RelOptRule {
        protected final String sketchType;

        public WindowingToProjectAggregateJoinProject(String sketchType, String description) {
            super(WindowingToProjectAggregateJoinProject.operand(HiveProject.class, (RelOptRuleOperandChildren)WindowingToProjectAggregateJoinProject.any()), HiveRelFactories.HIVE_BUILDER, description);
            this.sketchType = sketchType;
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            VbuilderPAP vb = this.buildProcessor(call);
            RelNode newProject = vb.processProject(project);
            if (newProject == project) {
                return;
            }
            call.transformTo(newProject);
        }

        protected abstract VbuilderPAP buildProcessor(RelOptRuleCall var1);

        protected static abstract class VbuilderPAP {
            private final String sketchClass;
            protected final RelBuilder relBuilder;
            protected final RexBuilder rexBuilder;

            protected VbuilderPAP(String sketchClass, RelBuilder relBuilder) {
                this.sketchClass = sketchClass;
                this.relBuilder = relBuilder;
                this.rexBuilder = relBuilder.getRexBuilder();
            }

            protected final RelNode processProject(Project project) {
                RelNode origInput = project.getInput();
                this.relBuilder.push(origInput);
                ProcessShuttle shuttle = new ProcessShuttle();
                ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
                for (RexNode expr : project.getProjects()) {
                    newProjects.add((RexNode)expr.accept((RexVisitor)shuttle));
                }
                if (this.relBuilder.peek() == origInput) {
                    this.relBuilder.clear();
                    return project;
                }
                this.relBuilder.project(newProjects);
                return this.relBuilder.build();
            }

            private final RexNode processCall(RexNode expr) {
                RexOver over;
                if (expr instanceof RexOver && this.isApplicable(over = (RexOver)expr)) {
                    return this.rewrite(over);
                }
                return expr;
            }

            protected final SqlOperator getSqlOperator(String fnName) {
                DataSketchesFunctions.SketchFunctionDescriptor fn = DataSketchesFunctions.INSTANCE.getSketchFunction(this.sketchClass, fnName);
                if (!fn.getCalciteFunction().isPresent()) {
                    throw new RuntimeException(((Object)fn).toString() + " doesn't have a Calcite function associated with it");
                }
                return (SqlOperator)fn.getCalciteFunction().get();
            }

            protected final RelDataType getFloatType() {
                RelDataTypeFactory typeFactory = this.rexBuilder.getTypeFactory();
                RelDataType notNullFloatType = typeFactory.createSqlType(SqlTypeName.FLOAT);
                RelDataType floatType = typeFactory.createTypeWithNullability(notNullFloatType, true);
                return floatType;
            }

            abstract RexNode rewrite(RexOver var1);

            abstract boolean isApplicable(RexOver var1);

            final class ProcessShuttle
            extends RexShuttle {
                ProcessShuttle() {
                }

                public RexNode visitOver(RexOver over) {
                    return VbuilderPAP.this.processCall((RexNode)over);
                }
            }
        }
    }

    public static class PercentileDiscRewrite
    extends AggregateToProjectAggregateProject {
        private final String sketchType;

        public PercentileDiscRewrite(String sketchType) {
            super(PercentileDiscRewrite.operand(HiveAggregate.class, (RelOptRuleOperand)PercentileDiscRewrite.operand(HiveProject.class, (RelOptRuleOperandChildren)PercentileDiscRewrite.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AggregateToProjectAggregateProject(PercentileDiscRewrite)");
            this.sketchType = sketchType;
        }

        @Override
        protected VBuilderPAP processCall(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            if (aggregate.getGroupSets().size() != 1) {
                return null;
            }
            return new VBuilderPAP(aggregate, project, this.sketchType);
        }

        private static class VBuilderPAP
        extends AggregateToProjectAggregateProject.VbuilderPAP {
            private final Project aggInput;

            protected VBuilderPAP(Aggregate aggregate, Project project, String sketchClass) {
                super(aggregate, sketchClass);
                this.aggInput = project;
                this.processAggregate();
            }

            @Override
            boolean isApplicable(AggregateCall aggCall) {
                if (this.aggInput != null && !aggCall.isDistinct() && aggCall.getArgList().size() == 1 && aggCall.getAggregation().getName().equalsIgnoreCase("percentile_disc") && !aggCall.hasFilter() && aggCall.collation.getFieldCollations().size() == 1) {
                    RelFieldCollation fieldCollation = (RelFieldCollation)aggCall.collation.getFieldCollations().get(0);
                    return fieldCollation.getDirection() == RelFieldCollation.Direction.ASCENDING;
                }
                return false;
            }

            @Override
            void rewrite(AggregateCall aggCall) {
                RelDataType origType = ((RelDataTypeField)this.aggregate.getRowType().getFieldList().get(this.newProjectsAbove.size())).getType();
                Integer collationKeyIndex = ((RelFieldCollation)aggCall.collation.getFieldCollations().get(0)).getFieldIndex();
                RexInputRef call = this.rexBuilder.makeInputRef(this.aggregate.getInput(), collationKeyIndex.intValue());
                RelDataTypeFactory typeFactory = this.rexBuilder.getTypeFactory();
                RelDataType notNullFloatType = typeFactory.createSqlType(SqlTypeName.FLOAT);
                RelDataType floatType = typeFactory.createTypeWithNullability(notNullFloatType, true);
                call = this.rexBuilder.makeCast(floatType, (RexNode)call);
                this.newProjectsBelow.add(call);
                SqlAggFunction aggFunction = (SqlAggFunction)this.getSqlOperator("sketch");
                boolean distinct = false;
                boolean approximate = false;
                boolean ignoreNulls = true;
                ArrayList argList = Lists.newArrayList((Object[])new Integer[]{this.newProjectsBelow.size() - 1});
                int filterArg = aggCall.filterArg;
                RelDataType type = this.rexBuilder.deriveReturnType((SqlOperator)aggFunction, Collections.emptyList());
                String name = aggFunction.getName();
                AggregateCall newAgg = AggregateCall.create((SqlAggFunction)aggFunction, (boolean)distinct, (boolean)approximate, (boolean)ignoreNulls, (List)argList, (int)filterArg, (RelCollation)RelCollations.EMPTY, (RelDataType)type, (String)name);
                Integer origFractionIdx = (Integer)aggCall.getArgList().get(0);
                RexNode fraction = (RexNode)this.aggInput.getProjects().get(origFractionIdx);
                fraction = this.rexBuilder.makeCast(floatType, fraction);
                SqlOperator projectOperator = this.getSqlOperator("quantile");
                RexInputRef projRex = this.rexBuilder.makeInputRef(newAgg.getType(), this.newProjectsAbove.size());
                projRex = this.rexBuilder.makeCall(projectOperator, (List)ImmutableList.of((Object)projRex, (Object)fraction));
                projRex = this.rexBuilder.makeCast(origType, (RexNode)projRex);
                this.newAggCalls.add(newAgg);
                this.newProjectsAbove.add(projRex);
            }
        }
    }

    public static class CountDistinctRewrite
    extends AggregateToProjectAggregateProject {
        private final String sketchType;

        public CountDistinctRewrite(String sketchType) {
            super(CountDistinctRewrite.operand(HiveAggregate.class, (RelOptRuleOperandChildren)CountDistinctRewrite.any()), "AggregateToProjectAggregateProject(CountDistinctRewrite)");
            this.sketchType = sketchType;
        }

        @Override
        protected VBuilderPAP processCall(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            if (aggregate.getGroupSets().size() != 1) {
                return null;
            }
            return new VBuilderPAP(aggregate, this.sketchType);
        }

        private static class VBuilderPAP
        extends AggregateToProjectAggregateProject.VbuilderPAP {
            protected VBuilderPAP(Aggregate aggregate, String sketchClass) {
                super(aggregate, sketchClass);
                this.processAggregate();
            }

            @Override
            boolean isApplicable(AggregateCall aggCall) {
                return aggCall.isDistinct() && aggCall.getArgList().size() == 1 && aggCall.getAggregation().getKind() == SqlKind.COUNT && !aggCall.hasFilter();
            }

            @Override
            void rewrite(AggregateCall aggCall) {
                RelDataType origType = ((RelDataTypeField)this.aggregate.getRowType().getFieldList().get(this.newProjectsAbove.size())).getType();
                Integer argIndex = (Integer)aggCall.getArgList().get(0);
                RexInputRef call = this.rexBuilder.makeInputRef(this.aggregate.getInput(), argIndex.intValue());
                this.newProjectsBelow.add(call);
                SqlAggFunction aggFunction = (SqlAggFunction)this.getSqlOperator("sketch");
                boolean distinct = false;
                boolean approximate = false;
                boolean ignoreNulls = true;
                ArrayList argList = Lists.newArrayList((Object[])new Integer[]{this.newProjectsBelow.size() - 1});
                int filterArg = aggCall.filterArg;
                RelCollation collation = aggCall.getCollation();
                RelDataType type = this.rexBuilder.deriveReturnType((SqlOperator)aggFunction, Collections.emptyList());
                String name = aggFunction.getName();
                AggregateCall newAgg = AggregateCall.create((SqlAggFunction)aggFunction, (boolean)distinct, (boolean)approximate, (boolean)ignoreNulls, (List)argList, (int)filterArg, (RelCollation)collation, (RelDataType)type, (String)name);
                SqlOperator projectOperator = this.getSqlOperator("estimate");
                RexInputRef projRex = this.rexBuilder.makeInputRef(newAgg.getType(), this.newProjectsAbove.size());
                projRex = this.rexBuilder.makeCall(projectOperator, (List)ImmutableList.of((Object)projRex));
                projRex = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROUND, (List)ImmutableList.of((Object)projRex));
                projRex = this.rexBuilder.makeCast(origType, (RexNode)projRex);
                this.newAggCalls.add(newAgg);
                this.newProjectsAbove.add(projRex);
            }
        }
    }

    private static abstract class AggregateToProjectAggregateProject
    extends RelOptRule {
        private final RelFactories.ProjectFactory projectFactory = HiveRelFactories.HIVE_PROJECT_FACTORY;

        public AggregateToProjectAggregateProject(RelOptRuleOperand operand, String description) {
            super(operand, description);
        }

        public void onMatch(RelOptRuleCall call) {
            VbuilderPAP vb = this.processCall(call);
            if (vb == null) {
                return;
            }
            Aggregate aggregate = vb.aggregate;
            if (aggregate.getAggCallList().equals(vb.newAggCalls)) {
                return;
            }
            List<AggregateCall> newAggCalls = vb.newAggCalls;
            ArrayList<CallSite> fieldNames = new ArrayList<CallSite>();
            for (int i = 0; i < vb.newProjectsBelow.size(); ++i) {
                fieldNames.add((CallSite)((Object)("ff_" + i)));
            }
            RelNode newProjectBelow = this.projectFactory.createProject(aggregate.getInput(), Collections.emptyList(), vb.newProjectsBelow, fieldNames);
            Aggregate newAgg = aggregate.copy(aggregate.getTraitSet(), newProjectBelow, aggregate.getGroupSet(), (List)aggregate.getGroupSets(), newAggCalls);
            RelNode newProject = this.projectFactory.createProject((RelNode)newAgg, Collections.emptyList(), vb.newProjectsAbove, aggregate.getRowType().getFieldNames());
            call.transformTo(newProject);
        }

        protected abstract VbuilderPAP processCall(RelOptRuleCall var1);

        private static abstract class VbuilderPAP {
            protected final RexBuilder rexBuilder;
            protected final Aggregate aggregate;
            protected final List<AggregateCall> newAggCalls;
            protected final List<RexNode> newProjectsAbove;
            protected final List<RexNode> newProjectsBelow;
            private final String sketchClass;

            protected VbuilderPAP(Aggregate aggregate, String sketchClass) {
                this.aggregate = aggregate;
                this.sketchClass = sketchClass;
                this.newAggCalls = new ArrayList<AggregateCall>();
                this.newProjectsAbove = new ArrayList<RexNode>();
                this.newProjectsBelow = new ArrayList<RexNode>();
                this.rexBuilder = aggregate.getCluster().getRexBuilder();
            }

            protected final void processAggregate() {
                this.addProjectedFields();
                for (AggregateCall aggCall : this.aggregate.getAggCallList()) {
                    this.processAggCall(aggCall);
                }
            }

            private final void addProjectedFields() {
                for (int i = 0; i < this.aggregate.getGroupCount(); ++i) {
                    this.newProjectsAbove.add((RexNode)this.rexBuilder.makeInputRef((RelNode)this.aggregate, i));
                }
                int numInputFields = this.aggregate.getInput().getRowType().getFieldCount();
                for (int i = 0; i < numInputFields; ++i) {
                    this.newProjectsBelow.add((RexNode)this.rexBuilder.makeInputRef(this.aggregate.getInput(), i));
                }
            }

            private final void processAggCall(AggregateCall aggCall) {
                if (this.isApplicable(aggCall)) {
                    this.rewrite(aggCall);
                } else {
                    this.appendAggCall(aggCall);
                }
            }

            private final void appendAggCall(AggregateCall aggCall) {
                RexInputRef projRex = this.rexBuilder.makeInputRef(aggCall.getType(), this.newProjectsAbove.size());
                this.newAggCalls.add(aggCall);
                this.newProjectsAbove.add((RexNode)projRex);
            }

            protected final SqlOperator getSqlOperator(String fnName) {
                DataSketchesFunctions.SketchFunctionDescriptor fn = DataSketchesFunctions.INSTANCE.getSketchFunction(this.sketchClass, fnName);
                if (!fn.getCalciteFunction().isPresent()) {
                    throw new RuntimeException(((Object)fn).toString() + " doesn't have a Calcite function associated with it");
                }
                return (SqlOperator)fn.getCalciteFunction().get();
            }

            abstract boolean isApplicable(AggregateCall var1);

            abstract void rewrite(AggregateCall var1);
        }
    }
}

