/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.bulkimport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.model.annotation.AtlasJSON;

@AtlasJSON
public class BulkImportResponse
implements Serializable {
    private List<ImportInfo> failedImportInfoList = new ArrayList<ImportInfo>();
    private List<ImportInfo> successImportInfoList = new ArrayList<ImportInfo>();

    public List<ImportInfo> getFailedImportInfoList() {
        return this.failedImportInfoList;
    }

    public void setFailedImportInfoList(List<ImportInfo> failedImportInfoList) {
        this.failedImportInfoList = failedImportInfoList;
    }

    public void addToFailedImportInfoList(ImportInfo importInfo) {
        if (this.failedImportInfoList == null) {
            this.failedImportInfoList = new ArrayList<ImportInfo>();
        }
        this.failedImportInfoList.add(importInfo);
    }

    public List<ImportInfo> getSuccessImportInfoList() {
        return this.successImportInfoList;
    }

    public void setSuccessImportInfoList(List<ImportInfo> successImportInfoList) {
        this.successImportInfoList = successImportInfoList;
    }

    public void addToSuccessImportInfoList(ImportInfo importInfo) {
        if (this.successImportInfoList == null) {
            this.successImportInfoList = new ArrayList<ImportInfo>();
        }
        this.successImportInfoList.add(importInfo);
    }

    public String toString() {
        return "BulkImportResponse{failedImportInfoList=" + this.failedImportInfoList + ", successImportInfoList=" + this.successImportInfoList + '}';
    }

    public static class ImportInfo {
        private String parentObjectName;
        private String childObjectName;
        private ImportStatus importStatus;
        private String remarks;
        private Integer rowNumber;

        public ImportInfo() {
        }

        public ImportInfo(String parentObjectName, String childObjectName, ImportStatus importStatus, String remarks, Integer rowNumber) {
            this.parentObjectName = parentObjectName;
            this.childObjectName = childObjectName;
            this.importStatus = importStatus;
            this.remarks = remarks;
            this.rowNumber = rowNumber;
        }

        public ImportInfo(String parentObjectName, String childObjectName, ImportStatus importStatus) {
            this(parentObjectName, childObjectName, importStatus, "", -1);
        }

        public ImportInfo(ImportStatus importStatus, String remarks) {
            this("", "", importStatus, remarks, -1);
        }

        public ImportInfo(ImportStatus importStatus, String remarks, Integer rowNumber) {
            this("", "", importStatus, remarks, rowNumber);
        }

        public ImportInfo(String parentObjectName, String childObjectName) {
            this(parentObjectName, childObjectName, ImportStatus.SUCCESS, "", -1);
        }

        public ImportInfo(String parentObjectName, String childObjectName, ImportStatus importStatus, String remarks) {
            this(parentObjectName, childObjectName, importStatus, remarks, -1);
        }

        public String getParentObjectName() {
            return this.parentObjectName;
        }

        public void setParentObjectName(String parentObjectName) {
            this.parentObjectName = parentObjectName;
        }

        public String getChildObjectName() {
            return this.childObjectName;
        }

        public void setChildObjectName(String childObjectName) {
            this.childObjectName = childObjectName;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public ImportStatus getImportStatus() {
            return this.importStatus;
        }

        public void setImportStatus(ImportStatus importStatus) {
            this.importStatus = importStatus;
        }

        public String toString() {
            return "ImportInfo{parentObjectName='" + this.parentObjectName + '\'' + ", childObjectName='" + this.childObjectName + '\'' + ", remarks='" + this.remarks + '\'' + ", importStatus=" + (Object)((Object)this.importStatus) + ", rowNumber=" + this.rowNumber + '}';
        }
    }

    public static enum ImportStatus {
        SUCCESS,
        FAILED;

    }
}

