/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.mbeans.ManagementMBean;
import org.apache.derby.mbeans.Version;
import org.apache.derby.mbeans.VersionMBean;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.security.SystemPermission;

public final class JMXManagementService
implements ManagementService,
ModuleControl {
    private MBeanServer mbeanServer;
    private Map<ObjectName, StandardMBean> registeredMbeans;
    private ObjectName myManagementBean;
    private MBeanServer myManagementServer;
    private String systemIdentifier;
    private static final SystemPermission CONTROL = new SystemPermission("jmx", "control");

    @Override
    public synchronized void boot(boolean bl, Properties properties) throws StandardException {
        this.registeredMbeans = new HashMap<ObjectName, StandardMBean>();
        this.systemIdentifier = JMXManagementService.getMonitor().getUUIDFactory().createUUID().toString();
        this.findServer();
        this.myManagementBean = (ObjectName)this.registerMBean(this, ManagementMBean.class, "type=Management");
        this.myManagementServer = this.mbeanServer;
        this.registerMBean(new Version(JMXManagementService.getMonitor().getEngineVersion(), "engine"), VersionMBean.class, "type=Version,jar=derby.jar");
    }

    @Override
    public synchronized void stop() {
        if (this.mbeanServer == null && this.myManagementBean != null) {
            this.mbeanServer = this.myManagementServer;
            this.unregisterMBean(this.myManagementBean);
            this.mbeanServer = null;
        }
        for (ObjectName objectName : new HashSet<ObjectName>(this.registeredMbeans.keySet())) {
            this.unregisterMBean(objectName);
        }
        this.mbeanServer = null;
        this.registeredMbeans = null;
        this.myManagementServer = null;
        this.systemIdentifier = null;
    }

    private synchronized void findServer() {
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public synchronized <T> Object registerMBean(T t, final Class<T> clazz, String string) throws StandardException {
        try {
            ObjectName objectName = new ObjectName("org.apache.derby:" + string + ",system=" + this.systemIdentifier);
            StandardMBean standardMBean = new StandardMBean(this, t, clazz){

                @Override
                protected String getClassName(MBeanInfo mBeanInfo) {
                    return clazz.getName();
                }
            };
            this.registeredMbeans.put(objectName, standardMBean);
            if (this.mbeanServer != null) {
                this.jmxRegister(standardMBean, objectName);
            }
            return objectName;
        }
        catch (JMException jMException) {
            throw StandardException.plainWrapException((Throwable)jMException);
        }
    }

    private void jmxRegister(StandardMBean standardMBean, ObjectName objectName) throws JMException {
        if (this.mbeanServer.isRegistered(objectName)) {
            return;
        }
        this.mbeanServer.registerMBean(standardMBean, objectName);
    }

    @Override
    public void unregisterMBean(Object object) {
        if (object == null) {
            return;
        }
        this.unregisterMBean((ObjectName)object);
    }

    private synchronized void unregisterMBean(ObjectName objectName) {
        if (this.registeredMbeans == null) {
            return;
        }
        if (this.registeredMbeans.remove(objectName) == null) {
            return;
        }
        if (this.mbeanServer == null) {
            return;
        }
        this.jmxUnregister(objectName);
    }

    private void jmxUnregister(ObjectName objectName) {
        if (!this.mbeanServer.isRegistered(objectName)) {
            return;
        }
        try {
            this.mbeanServer.unregisterMBean(objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean isManagementActive() {
        return this.mbeanServer != null;
    }

    @Override
    public synchronized void startManagement() {
        if (this.registeredMbeans == null) {
            return;
        }
        this.checkJMXControl();
        if (this.isManagementActive()) {
            return;
        }
        this.findServer();
        if (this.mbeanServer == null) {
            return;
        }
        for (ObjectName objectName : this.registeredMbeans.keySet()) {
            if (objectName.equals(this.myManagementBean) && this.mbeanServer.isRegistered(this.myManagementBean)) continue;
            try {
                this.jmxRegister(this.registeredMbeans.get(objectName), objectName);
            }
            catch (JMException jMException) {}
        }
    }

    @Override
    public synchronized void stopManagement() {
        if (this.registeredMbeans == null) {
            return;
        }
        this.checkJMXControl();
        if (this.isManagementActive()) {
            for (ObjectName objectName : this.registeredMbeans.keySet()) {
                if (objectName.equals(this.myManagementBean)) continue;
                this.jmxUnregister(objectName);
            }
            this.mbeanServer = null;
        }
    }

    private void checkJMXControl() {
    }

    @Override
    public synchronized String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    @Override
    public String quotePropertyValue(String string) {
        return ObjectName.quote(string);
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }
}

