/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotExport {
    private static final Pattern specialChars = Pattern.compile("[\"\\\\]");

    public static void printConnection(BufferedWriter writer, String from, String to, String label) throws IOException {
        writer.write(String.format("    \"%s\" -> \"%s\" [ label = \"%s\" ];", DotExport.escape(from), DotExport.escape(to), DotExport.escape(label)));
        writer.newLine();
    }

    public static String escape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m = specialChars.matcher(str);
        while (m.find()) {
            m.appendReplacement(escapedString, switch (str.charAt(m.start())) {
                case '\"' -> "\\\\\"";
                case '\\' -> "";
                default -> throw CompilerDirectives.shouldNotReachHere();
            });
        }
        m.appendTail(escapedString);
        return escapedString.toString();
    }
}

