/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.registry.discovery.entity;

import java.util.Map;

public class ServiceInstance {
    private String serviceId;
    private String serviceName;
    private String address;
    private double weight;
    private Map<String, String> metadata;
    private int port;
    private String healthStatus;

    public static ServiceInstanceBuilder builder() {
        return new ServiceInstanceBuilder();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAddress() {
        return this.address;
    }

    public double getWeight() {
        return this.weight;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getPort() {
        return this.port;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceInstance)) {
            return false;
        }
        ServiceInstance other = (ServiceInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$healthStatus = this.getHealthStatus();
        String other$healthStatus = other.getHealthStatus();
        return !(this$healthStatus == null ? other$healthStatus != null : !this$healthStatus.equals(other$healthStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        result = result * 59 + this.getPort();
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $healthStatus = this.getHealthStatus();
        result = result * 59 + ($healthStatus == null ? 43 : $healthStatus.hashCode());
        return result;
    }

    public String toString() {
        return "ServiceInstance(serviceId=" + this.getServiceId() + ", serviceName=" + this.getServiceName() + ", address=" + this.getAddress() + ", weight=" + this.getWeight() + ", metadata=" + this.getMetadata() + ", port=" + this.getPort() + ", healthStatus=" + this.getHealthStatus() + ")";
    }

    public ServiceInstance(String serviceId, String serviceName, String address, double weight, Map<String, String> metadata, int port, String healthStatus) {
        this.serviceId = serviceId;
        this.serviceName = serviceName;
        this.address = address;
        this.weight = weight;
        this.metadata = metadata;
        this.port = port;
        this.healthStatus = healthStatus;
    }

    public static class ServiceInstanceBuilder {
        private String serviceId;
        private String serviceName;
        private String address;
        private double weight;
        private Map<String, String> metadata;
        private int port;
        private String healthStatus;

        ServiceInstanceBuilder() {
        }

        public ServiceInstanceBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ServiceInstanceBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceInstanceBuilder address(String address) {
            this.address = address;
            return this;
        }

        public ServiceInstanceBuilder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public ServiceInstanceBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ServiceInstanceBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ServiceInstanceBuilder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public ServiceInstance build() {
            return new ServiceInstance(this.serviceId, this.serviceName, this.address, this.weight, this.metadata, this.port, this.healthStatus);
        }

        public String toString() {
            return "ServiceInstance.ServiceInstanceBuilder(serviceId=" + this.serviceId + ", serviceName=" + this.serviceName + ", address=" + this.address + ", weight=" + this.weight + ", metadata=" + this.metadata + ", port=" + this.port + ", healthStatus=" + this.healthStatus + ")";
        }
    }
}

