/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipCompressionUtil {
    public static byte[] compress(byte[] buffer) throws IOException {
        ByteArrayOutputStream gzipByteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = null;
        gzipOutputStream = new GZIPOutputStream(gzipByteArrayOutputStream);
        gzipOutputStream.write(buffer, 0, buffer.length);
        gzipOutputStream.close();
        byte[] compressedBytes = gzipByteArrayOutputStream.toByteArray();
        return compressedBytes;
    }

    public static byte[] uncompress(ByteArrayInputStream bais) throws IOException {
        int length;
        GZIPInputStream gzipInputStream = new GZIPInputStream(bais);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((length = gzipInputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        gzipInputStream.close();
        baos.close();
        byte[] uncompressedBytes = baos.toByteArray();
        return uncompressedBytes;
    }

    public static boolean isCompressed(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

