/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverFactory;

public class UnivariateRealSolverUtils {
    private static final String NULL_FUNCTION_MESSAGE = "function is null";

    private UnivariateRealSolverUtils() {
    }

    public static double solve(UnivariateRealFunction f, double x0, double x1) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f);
        return LazyHolder.FACTORY.newDefaultSolver().solve(f, x0, x1);
    }

    public static double solve(UnivariateRealFunction f, double x0, double x1, double absoluteAccuracy) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f);
        UnivariateRealSolver solver = LazyHolder.FACTORY.newDefaultSolver();
        solver.setAbsoluteAccuracy(absoluteAccuracy);
        return solver.solve(f, x0, x1);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound) throws ConvergenceException, FunctionEvaluationException {
        return UnivariateRealSolverUtils.bracket(function, initial, lowerBound, upperBound, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws ConvergenceException, FunctionEvaluationException {
        double fb;
        double fa;
        if (function == null) {
            throw MathRuntimeException.createIllegalArgumentException(NULL_FUNCTION_MESSAGE, new Object[0]);
        }
        if (maximumIterations <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("bad value for maximum iterations number: {0}", maximumIterations);
        }
        if (initial < lowerBound || initial > upperBound || lowerBound >= upperBound) {
            throw MathRuntimeException.createIllegalArgumentException("invalid bracketing parameters:  lower bound={0},  initial={1}, upper bound={2}", lowerBound, initial, upperBound);
        }
        double a = initial;
        double b = initial;
        int numIterations = 0;
        do {
            a = Math.max(a - 1.0, lowerBound);
            b = Math.min(b + 1.0, upperBound);
        } while ((fa = function.value(a)) * (fb = function.value(b)) > 0.0 && ++numIterations < maximumIterations && (a > lowerBound || b < upperBound));
        if (fa * fb > 0.0) {
            throw new ConvergenceException("number of iterations={0}, maximum iterations={1}, initial={2}, lower bound={3}, upper bound={4}, final a value={5}, final b value={6}, f(a)={7}, f(b)={8}", numIterations, maximumIterations, initial, lowerBound, upperBound, a, b, fa, fb);
        }
        return new double[]{a, b};
    }

    public static double midpoint(double a, double b) {
        return (a + b) * 0.5;
    }

    private static void setup(UnivariateRealFunction f) {
        if (f == null) {
            throw MathRuntimeException.createIllegalArgumentException(NULL_FUNCTION_MESSAGE, new Object[0]);
        }
    }

    private static class LazyHolder {
        private static final UnivariateRealSolverFactory FACTORY = UnivariateRealSolverFactory.newInstance();

        private LazyHolder() {
        }
    }
}

