ace.define("ace/mode/slim_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../config").$modes,f=r("../lib/oop"),d=r("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:"keyword",regex:/^(\s*)(\w+):\s*/,onMatch:function(o,u,a,i){var s=/^\s*/.exec(i)[0],n=o.match(/^(\s*)(\w+):/)[2];return/^(javascript|ruby|coffee|markdown|css|scss|sass|less)$/.test(n)||(n=""),a.unshift("language-embed",[],[s,n],u),this.token},stateName:"language-embed",next:[{token:"string",regex:/^(\s*)/,onMatch:function(o,u,a,i){var s=a[2][0];return s.length>=o.length?(a.splice(0,3),this.next=a.shift(),this.token):(this.next="",[{type:"text",value:s}])},next:""},{token:"string",regex:/.+/,onMatch:function(o,u,a,i){var s=a[2][0],e=a[2][1],n=a[1];if(x[e]){var t=x[e].getTokenizer().getLineTokens(i.slice(s.length),n.slice(0));return a[1]=t.state,t.tokens}return this.token}}]},{token:"constant.begin.javascript.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(ruby):$"},{token:"constant.begin.coffeescript.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(markdown):$"},{token:"constant.begin.css.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin.scss.filter.slim",regex:"^(\\s*)():$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(sass):$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(less):$"},{token:"constant.begin..filter.slim",regex:"^(\\s*)(erb):$"},{token:"keyword.html.tags.slim",regex:"^(\\s*)((:?\\*(\\w)+)|doctype html|abbr|acronym|address|applet|area|article|aside|audio|base|basefont|bdo|big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|command|datalist|dd|del|details|dialog|dfn|dir|div|dl|dt|embed|fieldset|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|link|li|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|option|output|p|param|pre|progress|q|rp|rt|ruby|samp|script|section|select|small|source|span|strike|strong|style|sub|sup|table|tbody|td|textarea|tfoot|th|thead|time|title|tr|tt|ul|var|video|xmp|b|u|s|em|a)(?:([.#](\\w|\\.)+)+\\s?)?\\b"},{token:"keyword.slim",regex:"^(\\s*)(?:([.#](\\w|\\.)+)+\\s?)"},{token:"string",regex:/^(\s*)('|\||\/|(\/!))\s*/,onMatch:function(o,u,a,i){var s=/^\s*/.exec(i)[0];return a.length<1?a.push(this.next):a[0]="mlString",a.length<2?a.push(s.length):a[1]=s.length,this.token},next:"mlString"},{token:"keyword.control.slim",regex:"^(\\s*)(\\-|==|=)",push:[{token:"control.end.slim",regex:"$",next:"pop"},{include:"rubyline"},{include:"misc"}]},{token:"paren",regex:"\\(",push:[{token:"paren",regex:"\\)",next:"pop"},{include:"misc"}]},{token:"paren",regex:"\\[",push:[{token:"paren",regex:"\\]",next:"pop"},{include:"misc"}]},{include:"misc"}],mlString:[{token:"indent",regex:/^\s*/,onMatch:function(o,u,a){return a[1]>=o.length?(this.next="start",a.splice(0)):this.next="mlString",this.token},next:"start"},{defaultToken:"string"}],rubyline:[{token:"keyword.operator.ruby.embedded.slim",regex:"(==|=)(<>|><|<'|'<|<|>)?|-"},{token:"list.ruby.operators.slim",regex:"(\\b)(for|in|do|if|else|elsif|unless|while|yield|not|and|or)\\b"},{token:"string",regex:"['](.)*?[']"},{token:"string",regex:'["](.)*?["]'}],misc:[{token:"class.variable.slim",regex:"\\@([a-zA-Z_][a-zA-Z0-9_]*)\\b"},{token:"list.meta.slim",regex:"(\\b)(true|false|nil)(\\b)"},{token:"keyword.operator.equals.slim",regex:"="},{token:"string",regex:"['](.)*?[']"},{token:"string",regex:'["](.)*?["]'}]},this.normalizeRules()};f.inherits(g,d),h.SlimHighlightRules=g}),ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,d=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},d.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}]}};x.inherits(d,f),d.getTagRule=function(g){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},d.getStartRule=function(g){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:g}},d.getEndRule=function(g){return{token:"comment.doc",regex:"\\*\\/",next:g}},h.DocCommentHighlightRules=d}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./doc_comment_highlight_rules").DocCommentHighlightRules,d=r("./text_highlight_rules").TextHighlightRules,g="[a-zA-Z\\$_\xa1-\uffff][a-zA-Z\\d\\$_\xa1-\uffff]*",o=function(i){var s=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier"),n="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[f.getStartRule("doc-start"),a("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+g+")(\\.)(prototype)(\\.)("+g+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+g+")(\\.)("+g+")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+g+")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+g+")(\\.)("+g+")(\\s*)(=)(\\s*)(function\\*?)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function\\*?)(\\s+)("+g+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+g+")(\\s*)(:)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void)\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:s,regex:g},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+g+")(\\.)("+g+")(\\s*)(=)(\\s*)(function\\*?)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:g},{regex:"",token:"empty",next:"no_regex"}],start:[f.getStartRule("doc-start"),a("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[a("function_arguments"),{token:"variable.parameter",regex:g},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:n},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:n},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!i||!i.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(t,l,c){if(this.next="{"==t?this.nextState:"","{"==t&&c.length)c.unshift("start",l);else if("}"==t&&c.length&&(c.shift(),this.next=c.shift(),-1!=this.next.indexOf("string")||-1!=this.next.indexOf("jsx")))return"paren.quasi.end";return"{"==t?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:n},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+g+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=.+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"}),this.$rules.function_arguments.unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"}),this.$rules.property.unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"}),(!i||0!=i.jsx)&&u.call(this)),this.embedRules(f,"doc-",[f.getEndRule("no_regex")]),this.normalizeRules()};function u(){var i=g.replace("\\d","\\d\\-"),s={onMatch:function(n,t,l){var c="/"==n.charAt(1)?2:1;return 1==c?(t!=this.nextState?l.unshift(this.next,this.nextState,0):l.unshift(this.next),l[2]++):2==c&&t==this.nextState&&(l[1]--,(!l[1]||l[1]<0)&&(l.shift(),l.shift())),[{type:"meta.tag.punctuation."+(1==c?"":"end-")+"tag-open.xml",value:n.slice(0,c)},{type:"meta.tag.tag-name.xml",value:n.substr(c)}]},regex:"</?"+i,next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(s);var e={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[e,s,{include:"reference"},{defaultToken:"string"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(n,t,l){return t==l[0]&&l.shift(),2==n.length&&(l[0]==this.nextState&&l[1]--,(!l[1]||l[1]<0)&&l.splice(0,2)),this.next=l[0]||"start",[{type:this.token,value:n}]},nextState:"jsx"},e,a("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:i},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},s],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function a(i){return[{token:"comment",regex:/\/\*/,next:[f.getTagRule(),{token:"comment",regex:"\\*\\/",next:i||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[f.getTagRule(),{token:"comment",regex:"$|^",next:i||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}x.inherits(o,d),h.JavaScriptHighlightRules=o}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(r,h,_){"use strict";var x=r("../range").Range,f=function(){};(function(){this.checkOutdent=function(d,g){return!!/^\s+$/.test(d)&&/^\s*\}/.test(g)},this.autoOutdent=function(d,g){var u=d.getLine(g).match(/^(\s*\})/);if(!u)return 0;var a=u[1].length,i=d.findMatchingBracket({row:g,column:a});if(!i||i.row==g)return 0;var s=this.$getIndent(d.getLine(i.row));d.replace(new x(g,0,g,a-1),s)},this.$getIndent=function(d){return d.match(/^\s*/)[0]}}).call(f.prototype),h.MatchingBraceOutdent=f}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("../../range").Range,d=r("./fold_mode").FoldMode,g=h.FoldMode=function(o){o&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+o.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+o.end)))};x.inherits(g,d),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(o,u,a){var i=o.getLine(a);if(this.singleLineBlockCommentRe.test(i)&&!this.startRegionRe.test(i)&&!this.tripleStarBlockCommentRe.test(i))return"";var s=this._getFoldWidgetBase(o,u,a);return!s&&this.startRegionRe.test(i)?"start":s},this.getFoldWidgetRange=function(o,u,a,i){var t,s=o.getLine(a);if(this.startRegionRe.test(s))return this.getCommentRegionBlock(o,s,a);if(t=s.match(this.foldingStartMarker)){var e=t.index;if(t[1])return this.openingBracketBlock(o,t[1],a,e);var n=o.getCommentFoldRange(a,e+t[0].length,1);return n&&!n.isMultiLine()&&(i?n=this.getSectionRange(o,a):"all"!=u&&(n=null)),n}return"markbegin"!==u&&(t=s.match(this.foldingStopMarker))?(e=t.index+t[0].length,t[1]?this.closingBracketBlock(o,t[1],a,e):o.getCommentFoldRange(a,e,-1)):void 0},this.getSectionRange=function(o,u){for(var a=o.getLine(u),i=a.search(/\S/),s=u,e=a.length,n=u+=1,t=o.getLength();++u<t;){var l=(a=o.getLine(u)).search(/\S/);if(-1!==l){if(i>l)break;var c=this.getFoldWidgetRange(o,"all",u);if(c){if(c.start.row<=s)break;if(c.isMultiLine())u=c.end.row;else if(i==l)break}n=u}}return new f(s,e,n,o.getLine(n).length)},this.getCommentRegionBlock=function(o,u,a){for(var i=u.search(/\s*$/),s=o.getLength(),e=a,n=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,t=1;++a<s;){u=o.getLine(a);var l=n.exec(u);if(l&&(l[1]?t--:t++,!t))break}if(a>e)return new f(e,i,a,u.length)}}.call(g.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./javascript_highlight_rules").JavaScriptHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,o=r("../worker/worker_client").WorkerClient,u=r("./behaviour/cstyle").CstyleBehaviour,a=r("./folding/cstyle").FoldMode,i=function(){this.HighlightRules=d,this.$outdent=new g,this.$behaviour=new u,this.foldingRules=new a};x.inherits(i,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.getNextLineIndent=function(s,e,n){var t=this.$getIndent(e),l=this.getTokenizer().getLineTokens(e,s),c=l.tokens,p=l.state;if(c.length&&"comment"==c[c.length-1].type)return t;if("start"==s||"no_regex"==s)(v=e.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/))&&(t+=n);else if("doc-start"==s){if("start"==p||"no_regex"==p)return"";var v;(v=e.match(/^\s*(\/?)\*/))&&(v[1]&&(t+=" "),t+="* ")}return t},this.checkOutdent=function(s,e,n){return this.$outdent.checkOutdent(e,n)},this.autoOutdent=function(s,e,n){this.$outdent.autoOutdent(e,n)},this.createWorker=function(s){var e=new o(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return e.attachToDocument(s.getDocument()),e.on("annotate",function(n){s.setAnnotations(n.data)}),e.on("terminate",function(){s.clearAnnotations()}),e},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),d=(r("../lib/lang"),r("./text_highlight_rules").TextHighlightRules),g=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",o=h.supportFunction="rgb|rgba|url|attr|counter|counters",u=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",a=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",i=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",s=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",e=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",n=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",t=function(){var l=this.createKeywordMapper({"support.function":o,"support.constant":u,"support.type":g,"support.constant.color":a,"support.constant.fonts":i},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:s},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+s+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:s},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:e},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:n},{include:"url"},{token:l,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};x.inherits(t,d),h.CssHighlightRules=t}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,d=function(g){var o="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+o+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:o},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+o+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+o+":)?"+o+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:o},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===d&&this.normalizeRules()};(function(){this.embedTagRules=function(g,o,u){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+u+".tag-name.xml"],regex:"(<)("+u+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:o+"start"}]}),this.$rules[u+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(a,i,s){return s.splice(0),this.token}}],this.embedRules(g,o,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+u+".tag-name.xml"],regex:"(</)("+u+"(?=\\s|>|$))",next:u+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(f.prototype),x.inherits(d,f),h.XmlHighlightRules=d}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),d=r("./css_highlight_rules").CssHighlightRules,g=r("./javascript_highlight_rules").JavaScriptHighlightRules,o=r("./xml_highlight_rules").XmlHighlightRules,u=f.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),a=function(){o.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(i,s){var e=u[s];return["meta.tag.punctuation."+("<"==i?"":"end-")+"tag-open.xml","meta.tag"+(e?"."+e:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(d,"css-","style"),this.embedTagRules(new g({jsx:!1}).getRules(),"js-","script"),this.constructor===a&&this.normalizeRules()};x.inherits(a,o),h.HtmlHighlightRules=a}),ace.define("ace/mode/markdown_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/html_highlight_rules"],function(r,h,_){"use strict";var x=r("../config").$modes,f=r("../lib/oop"),d=r("../lib/lang"),g=r("./text_highlight_rules").TextHighlightRules,o=r("./html_highlight_rules").HtmlHighlightRules,u=function(i){return"(?:[^"+d.escapeRegExp(i)+"\\\\]|\\\\.)*"},a=function(){o.call(this);var i={token:"support.function",regex:/^\s*(```+[^`]*|~~~+[^~]*)$/,onMatch:function(e,n,t,l){var c=e.match(/^(\s*)([`~]+)(.*)/),p=/[\w-]+|$/.exec(c[3])[0];return x[p]||(p=""),t.unshift("githubblock",[],[c[1],c[2],p],n),this.token},next:"githubblock"},s=[{token:"support.function",regex:".*",onMatch:function(e,n,t,l){var c=t[1],p=t[2][0],v=t[2][1],w=t[2][2],k=/^(\s*)(`+|~+)\s*$/.exec(e);if(k&&k[1].length<p.length+3&&k[2].length>=v.length&&k[2][0]==v[0])return t.splice(0,3),this.next=t.shift(),this.token;if(this.next="",w&&x[w]){var R=x[w].getTokenizer().getLineTokens(e,c.slice(0));return t[1]=R.state,R.tokens}return this.token}}];this.$rules.start.unshift({token:"empty_line",regex:"^$",next:"allowBlock"},{token:"markup.heading.1",regex:"^=+(?=\\s*$)"},{token:"markup.heading.2",regex:"^\\-+(?=\\s*$)"},{token:function(e){return"markup.heading."+e.length},regex:/^#{1,6}(?=\s|$)/,next:"header"},i,{token:"string.blockquote",regex:"^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",next:"blockquote"},{token:"constant",regex:"^ {0,3}(?:(?:\\* ?){3,}|(?:\\- ?){3,}|(?:\\_ ?){3,})\\s*$",next:"allowBlock"},{token:"markup.list",regex:"^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",next:"listblock-start"},{include:"basic"}),this.addRules({basic:[{token:"constant.language.escape",regex:/\\[\\`*_{}\[\]()#+\-.!]/},{token:"support.function",regex:"(`+)(.*?[^`])(\\1)"},{token:["text","constant","text","url","string","text"],regex:'^([ ]{0,3}\\[)([^\\]]+)(\\]:\\s*)([^ ]+)(\\s*(?:["][^"]+["])?(\\s*))$'},{token:["text","string","text","constant","text"],regex:"(\\[)("+u("]")+")(\\]\\s*\\[)("+u("]")+")(\\])"},{token:["text","string","text","markup.underline","string","text"],regex:"(\\!?\\[)("+u("]")+')(\\]\\()((?:[^\\)\\s\\\\]|\\\\.|\\s(?=[^"]))*)(\\s*"'+u('"')+'"\\s*)?(\\))'},{token:"string.strong",regex:"([*]{2}|[_]{2}(?=\\S))(.*?\\S[*_]*)(\\1)"},{token:"string.emphasis",regex:"([*]|[_](?=\\S))(.*?\\S[*_]*)(\\1)"},{token:["text","url","text"],regex:"(<)((?:https?|ftp|dict):[^'\">\\s]+|(?:mailto:)?[-.\\w]+\\@[-a-z0-9]+(?:\\.[-a-z0-9]+)*\\.[a-z]+)(>)"}],allowBlock:[{token:"support.function",regex:"^ {4}.+",next:"allowBlock"},{token:"empty_line",regex:"^$",next:"allowBlock"},{token:"empty",regex:"",next:"start"}],header:[{regex:"$",next:"start"},{include:"basic"},{defaultToken:"heading"}],"listblock-start":[{token:"support.variable",regex:/(?:\[[ x]\])?/,next:"listblock"}],listblock:[{token:"empty_line",regex:"^$",next:"start"},{token:"markup.list",regex:"^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",next:"listblock-start"},{include:"basic",noEscape:!0},i,{defaultToken:"list"}],blockquote:[{token:"empty_line",regex:"^\\s*$",next:"start"},{token:"string.blockquote",regex:"^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",next:"blockquote"},{include:"basic",noEscape:!0},{defaultToken:"string.blockquote"}],githubblock:s}),this.normalizeRules()};f.inherits(a,g),h.MarkdownHighlightRules=a}),ace.define("ace/mode/folding/markdown",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,d=r("../../range").Range,g=h.FoldMode=function(){};x.inherits(g,f),function(){this.foldingStartMarker=/^(?:[=-]+\s*$|#{1,6} |`{3})/,this.getFoldWidget=function(o,u,a){var i=o.getLine(a);return this.foldingStartMarker.test(i)?"`"==i[0]&&"start"==o.bgTokenizer.getState(a)?"end":"start":""},this.getFoldWidgetRange=function(o,u,a){var i=o.getLine(a),s=i.length,e=o.getLength(),n=a,t=a;if(i.match(this.foldingStartMarker)){if("`"==i[0]){if("start"!==o.bgTokenizer.getState(a)){for(;++a<e&&!("`"==(i=o.getLine(a))[0]&"```"==i.substring(0,3)););return new d(n,s,a,0)}for(;a-- >0&&!("`"==(i=o.getLine(a))[0]&"```"==i.substring(0,3)););return new d(a,i.length,n,0)}var l,p="markup.heading";if(c(a)){for(var w=v();++a<e&&!(c(a)&&v()>=w););if((t=a-(l&&-1!=["=","-"].indexOf(l.value[0])?2:1))>n)for(;t>n&&/^\s*$/.test(o.getLine(t));)t--;if(t>n){var R=o.getLine(t).length;return new d(n,s,t,R)}}}function c(b){return(l=o.getTokens(b)[0])&&0===l.type.lastIndexOf(p,0)}function v(){var b=l.value[0];return"="==b?6:"-"==b?5:7-l.value.search(/[^#]|$/)}}}.call(g.prototype)}),ace.define("ace/mode/css_completions",["require","exports","module"],function(r,h,_){"use strict";var x={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},f=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var d=document.createElement("c").style;for(var g in d)if("string"==typeof d[g]){var o=g.replace(/[A-Z]/g,function(u){return"-"+u.toLowerCase()});x.hasOwnProperty(o)||(x[o]=1)}}this.completionsDefined=!0},this.getCompletions=function(d,g,o,u){if(this.completionsDefined||this.defineCompletions(),"ruleset"===d||"ace/mode/scss"==g.$mode.$id){var a=g.getLine(o.row).substr(0,o.column),i=/\([^)]*$/.test(a);return i&&(a=a.substr(a.lastIndexOf("(")+1)),/:[^;]+$/.test(a)?(/([\w\-]+):[^:]*$/.test(a),this.getPropertyValueCompletions(d,g,o,u)):this.getPropertyCompletions(d,g,o,u,i)}return[]},this.getPropertyCompletions=function(d,g,o,u,a){return a=a||!1,Object.keys(x).map(function(s){return{caption:s,snippet:s+": $0"+(a?"":";"),meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(d,g,o,u){var a=g.getLine(o.row).substr(0,o.column),i=(/([\w\-]+):[^:]*$/.exec(a)||{})[1];if(!i)return[];var s=[];return i in x&&"object"==typeof x[i]&&(s=Object.keys(x[i])),s.map(function(e){return{caption:e,snippet:e,meta:"property value",score:1e6}})}}).call(f.prototype),h.CssCompletions=f}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(r,h,_){"use strict";var x=r("../../lib/oop"),d=(r("../behaviour"),r("./cstyle").CstyleBehaviour),g=r("../../token_iterator").TokenIterator,o=function(){this.inherit(d),this.add("colon","insertion",function(u,a,i,s,e){if(":"===e&&i.selection.isEmpty()){var n=i.getCursorPosition(),t=new g(s,n.row,n.column),l=t.getCurrentToken();if(l&&l.value.match(/\s+/)&&(l=t.stepBackward()),l&&"support.type"===l.type){var c=s.doc.getLine(n.row);if(":"===c.substring(n.column,n.column+1))return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(c.substring(n.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(u,a,i,s,e){var n=s.doc.getTextRange(e);if(!e.isMultiLine()&&":"===n){var t=i.getCursorPosition(),l=new g(s,t.row,t.column),c=l.getCurrentToken();if(c&&c.value.match(/\s+/)&&(c=l.stepBackward()),c&&"support.type"===c.type&&";"===s.doc.getLine(e.start.row).substring(e.end.column,e.end.column+1))return e.end.column++,e}}),this.add("semicolon","insertion",function(u,a,i,s,e){if(";"===e&&i.selection.isEmpty()){var n=i.getCursorPosition();if(";"===s.doc.getLine(n.row).substring(n.column,n.column+1))return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(u,a,i,s,e){if("!"===e&&i.selection.isEmpty()){var n=i.getCursorPosition(),t=s.doc.getLine(n.row);if(/^\s*(;|}|$)/.test(t.substring(n.column)))return{text:"!important",selection:[10,10]}}})};x.inherits(o,d),h.CssBehaviour=o}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./css_highlight_rules").CssHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,o=r("../worker/worker_client").WorkerClient,u=r("./css_completions").CssCompletions,a=r("./behaviour/css").CssBehaviour,i=r("./folding/cstyle").FoldMode,s=function(){this.HighlightRules=d,this.$outdent=new g,this.$behaviour=new a,this.$completer=new u,this.foldingRules=new i};x.inherits(s,f),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(e,n,t){var l=this.$getIndent(n),c=this.getTokenizer().getLineTokens(n,e).tokens;return c.length&&"comment"==c[c.length-1].type||n.match(/^.*\{\s*$/)&&(l+=t),l},this.checkOutdent=function(e,n,t){return this.$outdent.checkOutdent(n,t)},this.autoOutdent=function(e,n,t){this.$outdent.autoOutdent(n,t)},this.getCompletions=function(e,n,t,l){return this.$completer.getCompletions(e,n,t,l)},this.createWorker=function(e){var n=new o(["ace"],"ace/mode/css_worker","Worker");return n.attachToDocument(e.getDocument()),n.on("annotate",function(t){e.setAnnotations(t.data)}),n.on("terminate",function(){e.clearAnnotations()}),n},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(s.prototype),h.Mode=s}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("../behaviour").Behaviour,d=r("../../token_iterator").TokenIterator;function o(a,i){return a&&a.type.lastIndexOf(i+".xml")>-1}r("../../lib/lang");var u=function(){this.add("string_dquotes","insertion",function(a,i,s,e,n){if('"'==n||"'"==n){var t=n,l=e.doc.getTextRange(s.getSelectionRange());if(""!==l&&"'"!==l&&'"'!=l&&s.getWrapBehavioursEnabled())return{text:t+l+t,selection:!1};var c=s.getCursorPosition(),v=e.doc.getLine(c.row).substring(c.column,c.column+1),w=new d(e,c.row,c.column),k=w.getCurrentToken();if(v==t&&(o(k,"attribute-value")||o(k,"string")))return{text:"",selection:[1,1]};if(k||(k=w.stepBackward()),!k)return;for(;o(k,"tag-whitespace")||o(k,"whitespace");)k=w.stepBackward();var R=!v||v.match(/\s/);if(o(k,"attribute-equals")&&(R||">"==v)||o(k,"decl-attribute-equals")&&(R||"?"==v))return{text:t+t,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(a,i,s,e,n){var t=e.doc.getTextRange(n);if(!n.isMultiLine()&&('"'==t||"'"==t)&&e.doc.getLine(n.start.row).substring(n.start.column+1,n.start.column+2)==t)return n.end.column++,n}),this.add("autoclosing","insertion",function(a,i,s,e,n){if(">"==n){var t=s.getSelectionRange().start,l=new d(e,t.row,t.column),c=l.getCurrentToken()||l.stepBackward();if(!c||!(o(c,"tag-name")||o(c,"tag-whitespace")||o(c,"attribute-name")||o(c,"attribute-equals")||o(c,"attribute-value"))||o(c,"reference.attribute-value"))return;if(o(c,"attribute-value")){var p=l.getCurrentTokenColumn()+c.value.length;if(t.column<p)return;if(t.column==p){var v=l.stepForward();if(v&&o(v,"attribute-value"))return;l.stepBackward()}}if(/^\s*>/.test(e.getLine(t.row).slice(t.column)))return;for(;!o(c,"tag-name");)if("<"==(c=l.stepBackward()).value){c=l.stepForward();break}var w=l.getCurrentTokenRow(),k=l.getCurrentTokenColumn();if(o(l.stepBackward(),"end-tag-open"))return;var R=c.value;return w==t.row&&(R=R.substring(0,t.column-k)),this.voidElements.hasOwnProperty(R.toLowerCase())?void 0:{text:"></"+R+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(a,i,s,e,n){if("\n"==n){var t=s.getCursorPosition(),l=e.getLine(t.row),c=new d(e,t.row,t.column),p=c.getCurrentToken();if(p&&-1!==p.type.indexOf("tag-close")){if("/>"==p.value)return;for(;p&&-1===p.type.indexOf("tag-name");)p=c.stepBackward();if(!p)return;var v=p.value,w=c.getCurrentTokenRow();if(!(p=c.stepBackward())||-1!==p.type.indexOf("end-tag"))return;if(this.voidElements&&!this.voidElements[v]){var k=e.getTokenAt(t.row,t.column+1),R=(l=e.getLine(w),this.$getIndent(l)),b=R+e.getTabString();return k&&"</"===k.value?{text:"\n"+b+"\n"+R,selection:[1,b.length,1,b.length]}:{text:"\n"+b}}}}})};x.inherits(u,f),h.XmlBehaviour=u}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,d=h.FoldMode=function(g,o){this.defaultMode=g,this.subModes=o};x.inherits(d,f),function(){this.$getMode=function(g){for(var o in"string"!=typeof g&&(g=g[0]),this.subModes)if(0===g.indexOf(o))return this.subModes[o];return null},this.$tryMode=function(g,o,u,a){var i=this.$getMode(g);return i?i.getFoldWidget(o,u,a):""},this.getFoldWidget=function(g,o,u){return this.$tryMode(g.getState(u-1),g,o,u)||this.$tryMode(g.getState(u),g,o,u)||this.defaultMode.getFoldWidget(g,o,u)},this.getFoldWidgetRange=function(g,o,u){var a=this.$getMode(g.getState(u-1));return(!a||!a.getFoldWidget(g,o,u))&&(a=this.$getMode(g.getState(u))),(!a||!a.getFoldWidget(g,o,u))&&(a=this.defaultMode),a.getFoldWidgetRange(g,o,u)}}.call(d.prototype)}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("../../range").Range,d=r("./fold_mode").FoldMode,g=h.FoldMode=function(a,i){d.call(this),this.voidElements=a||{},this.optionalEndTags=x.mixin({},this.voidElements),i&&x.mixin(this.optionalEndTags,i)};x.inherits(g,d);var o=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function u(a,i){return a.type.lastIndexOf(i+".xml")>-1}(function(){this.getFoldWidget=function(a,i,s){var e=this._getFirstTagInLine(a,s);return e?e.closing||!e.tagName&&e.selfClosing?"markbeginend"===i?"end":"":!e.tagName||e.selfClosing||this.voidElements.hasOwnProperty(e.tagName.toLowerCase())||this._findEndTagInLine(a,s,e.tagName,e.end.column)?"":"start":this.getCommentFoldWidget(a,s)},this.getCommentFoldWidget=function(a,i){return/comment/.test(a.getState(i))&&/<!-/.test(a.getLine(i))?"start":""},this._getFirstTagInLine=function(a,i){for(var s=a.getTokens(i),e=new o,n=0;n<s.length;n++){var t=s[n];if(u(t,"tag-open")){if(e.end.column=e.start.column+t.value.length,e.closing=u(t,"end-tag-open"),!(t=s[++n]))return null;for(e.tagName=t.value,e.end.column+=t.value.length,n++;n<s.length;n++)if(e.end.column+=(t=s[n]).value.length,u(t,"tag-close")){e.selfClosing="/>"==t.value;break}return e}if(u(t,"tag-close"))return e.selfClosing="/>"==t.value,e;e.start.column+=t.value.length}return null},this._findEndTagInLine=function(a,i,s,e){for(var n=a.getTokens(i),t=0,l=0;l<n.length;l++){var c=n[l];if(!((t+=c.value.length)<e)&&u(c,"end-tag-open")&&(c=n[l+1])&&c.value==s)return!0}return!1},this.getFoldWidgetRange=function(a,i,s){var e=a.getMatchingTags({row:s,column:0});return e?new f(e.openTag.end.row,e.openTag.end.column,e.closeTag.start.row,e.closeTag.start.column):this.getCommentFoldWidget(a,s)&&a.getCommentFoldRange(s,a.getLine(s).length)}}).call(g.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("./mixed").FoldMode,d=r("./xml").FoldMode,g=r("./cstyle").FoldMode,o=h.FoldMode=function(u,a){f.call(this,new d(u,a),{"js-":new g,"css-":new g})};x.inherits(o,f)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(r,h,_){"use strict";var x=r("../token_iterator").TokenIterator,g=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"].concat(["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"]),o={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},u=Object.keys(o);function a(n,t){return n.type.lastIndexOf(t+".xml")>-1}function i(n,t){for(var l=new x(n,t.row,t.column),c=l.getCurrentToken();c&&!a(c,"tag-name");)c=l.stepBackward();if(c)return c.value}var e=function(){};(function(){this.getCompletions=function(n,t,l,c){var p=t.getTokenAt(l.row,l.column);if(!p)return[];if(a(p,"tag-name")||a(p,"tag-open")||a(p,"end-tag-open"))return this.getTagCompletions(n,t,l,c);if(a(p,"tag-whitespace")||a(p,"attribute-name"))return this.getAttributeCompletions(n,t,l,c);if(a(p,"attribute-value"))return this.getAttributeValueCompletions(n,t,l,c);var v=t.getLine(l.row).substr(0,l.column);return/&[a-z]*$/i.test(v)?this.getHTMLEntityCompletions(n,t,l,c):[]},this.getTagCompletions=function(n,t,l,c){return u.map(function(p){return{value:p,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(n,t,l,c){var p=i(t,l);if(!p)return[];var v=g;return p in o&&(v=v.concat(Object.keys(o[p]))),v.map(function(w){return{caption:w,snippet:w+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(n,t,l,c){var p=i(t,l),v=function s(n,t){for(var l=new x(n,t.row,t.column),c=l.getCurrentToken();c&&!a(c,"attribute-name");)c=l.stepBackward();if(c)return c.value}(t,l);if(!p)return[];var w=[];return p in o&&v in o[p]&&"object"==typeof o[p][v]&&(w=Object.keys(o[p][v])),w.map(function(k){return{caption:k,snippet:k,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(n,t,l,c){return["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"].map(function(v){return{caption:v,snippet:v,meta:"html entity",score:1e6}})}}).call(e.prototype),h.HtmlCompletions=e}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),d=r("./text").Mode,g=r("./javascript").Mode,o=r("./css").Mode,u=r("./html_highlight_rules").HtmlHighlightRules,a=r("./behaviour/xml").XmlBehaviour,i=r("./folding/html").FoldMode,s=r("./html_completions").HtmlCompletions,e=r("../worker/worker_client").WorkerClient,n=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],t=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],l=function(c){this.fragmentContext=c&&c.fragmentContext,this.HighlightRules=u,this.$behaviour=new a,this.$completer=new s,this.createModeDelegates({"js-":g,"css-":o}),this.foldingRules=new i(this.voidElements,f.arrayToMap(t))};x.inherits(l,d),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=f.arrayToMap(n),this.getNextLineIndent=function(c,p,v){return this.$getIndent(p)},this.checkOutdent=function(c,p,v){return!1},this.getCompletions=function(c,p,v,w){return this.$completer.getCompletions(c,p,v,w)},this.createWorker=function(c){if(this.constructor==l){var p=new e(["ace"],"ace/mode/html_worker","Worker");return p.attachToDocument(c.getDocument()),this.fragmentContext&&p.call("setOptions",[{context:this.fragmentContext}]),p.on("error",function(v){c.setAnnotations(v.data)}),p.on("terminate",function(){c.clearAnnotations()}),p}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(l.prototype),h.Mode=l}),ace.define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,d=h.reservedKeywords="!|{|}|case|do|done|elif|else|esac|fi|for|if|in|then|until|while|&|;|export|local|read|typeset|unset|elif|select|set|function|declare|readonly",g=h.languageConstructs="[|]|alias|bg|bind|break|builtin|cd|command|compgen|complete|continue|dirs|disown|echo|enable|eval|exec|exit|fc|fg|getopts|hash|help|history|jobs|kill|let|logout|popd|printf|pushd|pwd|return|set|shift|shopt|source|suspend|test|times|trap|type|ulimit|umask|unalias|wait",o=function(){var u=this.createKeywordMapper({keyword:d,"support.function.builtin":g,"invalid.deprecated":"debugger"},"identifier");this.$rules={start:[{token:"constant",regex:/\\./},{token:["text","comment"],regex:/(^|\s)(#.*)$/},{token:"string.start",regex:'"',push:[{token:"constant.language.escape",regex:/\\(?:[$`"\\]|$)/},{include:"variables"},{token:"keyword.operator",regex:/`/},{token:"string.end",regex:'"',next:"pop"},{defaultToken:"string"}]},{token:"string",regex:"\\$'",push:[{token:"constant.language.escape",regex:/\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/},{token:"string",regex:"'",next:"pop"},{defaultToken:"string"}]},{regex:"<<<",token:"keyword.operator"},{stateName:"heredoc",regex:"(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",onMatch:function(k,R,b){var y="-"==k[2]?"indentedHeredoc":"heredoc",m=k.split(this.splitRegex);return b.push(y,m[4]),[{type:"constant",value:m[1]},{type:"text",value:m[2]},{type:"string",value:m[3]},{type:"support.class",value:m[4]},{type:"string",value:m[5]}]},rules:{heredoc:[{onMatch:function(k,R,b){return k===b[1]?(b.shift(),b.shift(),this.next=b[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^\t+"},{onMatch:function(k,R,b){return k===b[1]?(b.shift(),b.shift(),this.next=b[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(k,R){return"heredoc"===R[0]||"indentedHeredoc"===R[0]?R[0]:k}},{token:["keyword","text","text","text","variable"],regex:/(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/},{token:"variable.language",regex:"(?:\\$(?:SHLVL|\\$|\\!|\\?))"},{token:"variable",regex:"(?:[a-zA-Z_][a-zA-Z0-9_]*(?==))"},{include:"variables"},{token:"support.function",regex:"(?:[a-zA-Z_][a-zA-Z0-9_]*\\s*\\(\\))"},{token:"support.function",regex:"(?:&(?:\\d+))"},{token:"string",start:"'",end:"'"},{token:"constant.numeric",regex:"(?:(?:(?:(?:(?:(?:\\d+)?(?:\\.\\d+))|(?:(?:\\d+)\\.))|(?:\\d+)))|(?:(?:(?:\\d+)?(?:\\.\\d+))|(?:(?:\\d+)\\.)))"},{token:"constant.numeric",regex:"(?:(?:[1-9]\\d*)|(?:0))\\b"},{token:u,regex:"[a-zA-Z_][a-zA-Z0-9_]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"},{token:"punctuation.operator",regex:";"},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]]"},{token:"paren.rparen",regex:"[\\)\\}]",next:"pop"}],variables:[{token:"variable",regex:/(\$)(\w+)/},{token:["variable","paren.lparen"],regex:/(\$)(\()/,push:"start"},{token:["variable","paren.lparen","keyword.operator","variable","keyword.operator"],regex:/(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,push:"start"},{token:"variable",regex:/\$[*@#?\-$!0_]/},{token:["variable","paren.lparen"],regex:/(\$)(\{)/,push:"start"}]},this.normalizeRules()};x.inherits(o,f),h.ShHighlightRules=o}),ace.define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle","ace/mode/behaviour/cstyle"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./sh_highlight_rules").ShHighlightRules,g=r("../range").Range,o=r("./folding/cstyle").FoldMode,u=r("./behaviour/cstyle").CstyleBehaviour,a=function(){this.HighlightRules=d,this.foldingRules=new o,this.$behaviour=new u};x.inherits(a,f),function(){this.lineCommentStart="#",this.getNextLineIndent=function(s,e,n){var t=this.$getIndent(e),c=this.getTokenizer().getLineTokens(e,s).tokens;return c.length&&"comment"==c[c.length-1].type||"start"==s&&e.match(/^.*[\{\(\[:]\s*$/)&&(t+=n),t};var i={pass:1,return:1,raise:1,break:1,continue:1};this.checkOutdent=function(s,e,n){if("\r\n"!==n&&"\r"!==n&&"\n"!==n)return!1;var t=this.getTokenizer().getLineTokens(e.trim(),s).tokens;if(!t)return!1;do{var l=t.pop()}while(l&&("comment"==l.type||"text"==l.type&&l.value.match(/^\s+$/)));return!!l&&"keyword"==l.type&&i[l.value]},this.autoOutdent=function(s,e,n){var t=this.$getIndent(e.getLine(n+=1)),l=e.getTabString();t.slice(-l.length)==l&&e.remove(new g(n,t.length-l.length,n,t.length))},this.$id="ace/mode/sh",this.snippetFileId="ace/snippets/sh"}.call(a.prototype),h.Mode=a}),ace.define("ace/mode/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/xml_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/xml","ace/worker/worker_client"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),d=r("./text").Mode,g=r("./xml_highlight_rules").XmlHighlightRules,o=r("./behaviour/xml").XmlBehaviour,u=r("./folding/xml").FoldMode,a=r("../worker/worker_client").WorkerClient,i=function(){this.HighlightRules=g,this.$behaviour=new o,this.foldingRules=new u};x.inherits(i,d),function(){this.voidElements=f.arrayToMap([]),this.blockComment={start:"\x3c!--",end:"--\x3e"},this.createWorker=function(s){var e=new a(["ace"],"ace/mode/xml_worker","Worker");return e.attachToDocument(s.getDocument()),e.on("error",function(n){s.setAnnotations(n.data)}),e.on("terminate",function(){s.clearAnnotations()}),e},this.$id="ace/mode/xml"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/markdown",["require","exports","module","ace/lib/oop","ace/mode/behaviour/cstyle","ace/mode/text","ace/mode/markdown_highlight_rules","ace/mode/folding/markdown","ace/mode/javascript","ace/mode/html","ace/mode/sh","ace/mode/sh","ace/mode/xml","ace/mode/css"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./behaviour/cstyle").CstyleBehaviour,d=r("./text").Mode,g=r("./markdown_highlight_rules").MarkdownHighlightRules,o=r("./folding/markdown").FoldMode,u=function(){this.HighlightRules=g,this.createModeDelegates({javascript:r("./javascript").Mode,html:r("./html").Mode,bash:r("./sh").Mode,sh:r("./sh").Mode,xml:r("./xml").Mode,css:r("./css").Mode}),this.foldingRules=new o,this.$behaviour=new f({braces:!0})};x.inherits(u,d),function(){this.type="text",this.blockComment={start:"\x3c!--",end:"--\x3e"},this.$quotes={'"':'"',"`":"`"},this.getNextLineIndent=function(a,i,s){if("listblock"==a){var e=/^(\s*)(?:([-+*])|(\d+)\.)(\s+)/.exec(i);if(!e)return"";var n=e[2];return n||(n=parseInt(e[3],10)+1+"."),e[1]+n+e[4]}return this.$getIndent(i)},this.$id="ace/mode/markdown",this.snippetFileId="ace/snippets/markdown"}.call(u.prototype),h.Mode=u}),ace.define("ace/mode/coffee_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules;function d(){var g="[$A-Za-z_\\x7f-\\uffff][$\\w\\x7f-\\uffff]*",a="case|const|function|var|void|with|enum|implements|interface|let|package|private|protected|public|static",n=this.createKeywordMapper({keyword:"this|throw|then|try|typeof|super|switch|return|break|by|continue|catch|class|in|instanceof|is|isnt|if|else|extends|for|own|finally|function|while|when|new|no|not|delete|debugger|do|loop|of|off|or|on|unless|until|and|yes|yield|export|import|default","constant.language":"true|false|null|undefined|NaN|Infinity","invalid.illegal":a,"language.support.class":"Array|Boolean|Date|Function|Number|Object|RegExp|ReferenceError|String|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray","language.support.function":"Math|JSON|isNaN|isFinite|parseInt|parseFloat|encodeURI|encodeURIComponent|decodeURI|decodeURIComponent|String|","variable.language":"window|arguments|prototype|document"},"identifier"),t={token:["paren.lparen","variable.parameter","paren.rparen","text","storage.type"],regex:/(?:(\()((?:"[^")]*?"|'[^')]*?'|\/[^\/)]*?\/|[^()"'\/])*?)(\))(\s*))?([\-=]>)/.source},l=/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)/;this.$rules={start:[{token:"constant.numeric",regex:"(?:0x[\\da-fA-F]+|(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:[eE][+-]?\\d+)?)"},{stateName:"qdoc",token:"string",regex:"'''",next:[{token:"string",regex:"'''",next:"start"},{token:"constant.language.escape",regex:l},{defaultToken:"string"}]},{stateName:"qqdoc",token:"string",regex:'"""',next:[{token:"string",regex:'"""',next:"start"},{token:"paren.string",regex:"#{",push:"start"},{token:"constant.language.escape",regex:l},{defaultToken:"string"}]},{stateName:"qstring",token:"string",regex:"'",next:[{token:"string",regex:"'",next:"start"},{token:"constant.language.escape",regex:l},{defaultToken:"string"}]},{stateName:"qqstring",token:"string.start",regex:'"',next:[{token:"string.end",regex:'"',next:"start"},{token:"paren.string",regex:"#{",push:"start"},{token:"constant.language.escape",regex:l},{defaultToken:"string"}]},{stateName:"js",token:"string",regex:"`",next:[{token:"string",regex:"`",next:"start"},{token:"constant.language.escape",regex:l},{defaultToken:"string"}]},{regex:"[{}]",onMatch:function(c,p,v){return this.next="","{"==c&&v.length?(v.unshift("start",p),"paren"):"}"==c&&v.length&&(v.shift(),this.next=v.shift()||"",-1!=this.next.indexOf("string"))?"paren.string":"paren"}},{token:"string.regex",regex:"///",next:"heregex"},{token:"string.regex",regex:/(?:\/(?![\s=])[^[\/\n\\]*(?:(?:\\[\s\S]|\[[^\]\n\\]*(?:\\[\s\S][^\]\n\\]*)*])[^[\/\n\\]*)*\/)(?:[imgy]{0,4})(?!\w)/},{token:"comment",regex:"###(?!#)",next:"comment"},{token:"comment",regex:"#.*"},{token:["punctuation.operator","text","identifier"],regex:"(\\.)(\\s*)("+a+")"},{token:"punctuation.operator",regex:"\\.{1,3}"},{token:["keyword","text","language.support.class","text","keyword","text","language.support.class"],regex:"(class)(\\s+)("+g+")(?:(\\s+)(extends)(\\s+)("+g+"))?"},{token:["entity.name.function","text","keyword.operator","text"].concat(t.token),regex:"("+g+")(\\s*)([=:])(\\s*)"+t.regex},t,{token:"variable",regex:"@(?:"+g+")?"},{token:n,regex:g},{token:"punctuation.operator",regex:"\\,|\\."},{token:"storage.type",regex:"[\\-=]>"},{token:"keyword.operator",regex:"(?:[-+*/%<>&|^!?=]=|>>>=?|\\-\\-|\\+\\+|::|&&=|\\|\\|=|<<=|>>=|\\?\\.|\\.{2,3}|[!*+-=><])"},{token:"paren.lparen",regex:"[({[]"},{token:"paren.rparen",regex:"[\\]})]"},{token:"text",regex:"\\s+"}],heregex:[{token:"string.regex",regex:".*?///[imgy]{0,4}",next:"start"},{token:"comment.regex",regex:"\\s+(?:#.*)?"},{token:"string.regex",regex:"\\S+"}],comment:[{token:"comment",regex:"###",next:"start"},{defaultToken:"comment"}]},this.normalizeRules()}x.inherits(d,f),h.CoffeeHighlightRules=d}),ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,d=r("../../range").Range,g=h.FoldMode=function(){};x.inherits(g,f),function(){this.getFoldWidgetRange=function(o,u,a){var i=this.indentationBlock(o,a);if(i)return i;var s=/\S/,e=o.getLine(a),n=e.search(s);if(-1!=n&&"#"==e[n]){for(var t=e.length,l=o.getLength(),c=a,p=a;++a<l;){var v=(e=o.getLine(a)).search(s);if(-1!=v){if("#"!=e[v])break;p=a}}if(p>c){var w=o.getLine(p).length;return new d(c,t,p,w)}}},this.getFoldWidget=function(o,u,a){var i=o.getLine(a),s=i.search(/\S/),e=o.getLine(a+1),n=o.getLine(a-1),t=n.search(/\S/),l=e.search(/\S/);if(-1==s)return o.foldWidgets[a-1]=-1!=t&&t<l?"start":"","";if(-1==t){if(s==l&&"#"==i[s]&&"#"==e[s])return o.foldWidgets[a-1]="",o.foldWidgets[a+1]="","start"}else if(t==s&&"#"==i[s]&&"#"==n[s]&&-1==o.getLine(a-2).search(/\S/))return o.foldWidgets[a-1]="start",o.foldWidgets[a+1]="","";return o.foldWidgets[a-1]=-1!=t&&t<s?"start":"",s<l?"start":""}}.call(g.prototype)}),ace.define("ace/mode/coffee",["require","exports","module","ace/mode/coffee_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/coffee","ace/range","ace/mode/text","ace/worker/worker_client","ace/lib/oop"],function(r,h,_){"use strict";var x=r("./coffee_highlight_rules").CoffeeHighlightRules,f=r("./matching_brace_outdent").MatchingBraceOutdent,d=r("./folding/coffee").FoldMode,o=(r("../range"),r("./text").Mode),u=r("../worker/worker_client").WorkerClient;function i(){this.HighlightRules=x,this.$outdent=new f,this.foldingRules=new d}r("../lib/oop").inherits(i,o),function(){var s=/(?:[({[=:]|[-=]>|\b(?:else|try|(?:swi|ca)tch(?:\s+[$A-Za-z_\x7f-\uffff][$\w\x7f-\uffff]*)?|finally))\s*$|^\s*(else\b\s*)?(?:if|for|while|loop)\b(?!.*\bthen\b)/;this.lineCommentStart="#",this.blockComment={start:"###",end:"###"},this.getNextLineIndent=function(e,n,t){var l=this.$getIndent(n),c=this.getTokenizer().getLineTokens(n,e).tokens;return!(c.length&&"comment"===c[c.length-1].type)&&"start"===e&&s.test(n)&&(l+=t),l},this.checkOutdent=function(e,n,t){return this.$outdent.checkOutdent(n,t)},this.autoOutdent=function(e,n,t){this.$outdent.autoOutdent(n,t)},this.createWorker=function(e){var n=new u(["ace"],"ace/mode/coffee_worker","Worker");return n.attachToDocument(e.getDocument()),n.on("annotate",function(t){e.setAnnotations(t.data)}),n.on("terminate",function(){e.clearAnnotations()}),n},this.$id="ace/mode/coffee",this.snippetFileId="ace/snippets/coffee"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/scss_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("../lib/lang"),d=r("./text_highlight_rules").TextHighlightRules,g=r("./css_highlight_rules"),o=function(){var u=f.arrayToMap(g.supportType.split("|")),a=f.arrayToMap("hsl|hsla|rgb|rgba|url|attr|counter|counters|abs|adjust_color|adjust_hue|alpha|join|blue|ceil|change_color|comparable|complement|darken|desaturate|floor|grayscale|green|hue|if|invert|join|length|lighten|lightness|mix|nth|opacify|opacity|percentage|quote|red|round|saturate|saturation|scale_color|transparentize|type_of|unit|unitless|unquote".split("|")),i=f.arrayToMap(g.supportConstant.split("|")),s=f.arrayToMap(g.supportConstantColor.split("|")),e=f.arrayToMap("@mixin|@extend|@include|@import|@media|@debug|@warn|@if|@for|@each|@while|@else|@font-face|@-webkit-keyframes|if|and|!default|module|def|end|declare".split("|")),n=f.arrayToMap("a|abbr|acronym|address|applet|area|article|aside|audio|b|base|basefont|bdo|big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|command|datalist|dd|del|details|dfn|dir|div|dl|dt|em|embed|fieldset|figcaption|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|li|link|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|option|output|p|param|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|small|source|span|strike|strong|style|sub|summary|sup|table|tbody|td|textarea|tfoot|th|thead|time|title|tr|tt|u|ul|var|video|wbr|xmp".split("|")),t="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";this.$rules={start:[{token:"comment",regex:"\\/\\/.*$"},{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:'["].*\\\\$',next:"qqstring"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"string",regex:"['].*\\\\$",next:"qstring"},{token:"constant.numeric",regex:t+"(?:ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:"constant.numeric",regex:t},{token:["support.function","string","support.function"],regex:"(url\\()(.*)(\\))"},{token:function(l){return u.hasOwnProperty(l.toLowerCase())?"support.type":e.hasOwnProperty(l)?"keyword":i.hasOwnProperty(l)?"constant.language":a.hasOwnProperty(l)?"support.function":s.hasOwnProperty(l.toLowerCase())?"support.constant.color":n.hasOwnProperty(l.toLowerCase())?"variable.language":"text"},regex:"\\-?[@a-z_][@a-z0-9_\\-]*"},{token:"variable",regex:"[a-z_\\-$][a-z0-9_\\-$]*\\b"},{token:"variable.language",regex:"#[a-z0-9-_]+"},{token:"variable.language",regex:"\\.[a-z0-9-_]+"},{token:"variable.language",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"},{token:"keyword.operator",regex:"<|>|<=|>=|==|!=|-|%|#|\\+|\\$|\\+|\\*"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"},{caseInsensitive:!0}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}],qqstring:[{token:"string",regex:'(?:(?:\\\\.)|(?:[^"\\\\]))*?"',next:"start"},{token:"string",regex:".+"}],qstring:[{token:"string",regex:"(?:(?:\\\\.)|(?:[^'\\\\]))*?'",next:"start"},{token:"string",regex:".+"}]}};x.inherits(o,d),h.ScssHighlightRules=o}),ace.define("ace/mode/scss",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/scss_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/folding/cstyle","ace/mode/css_completions"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./scss_highlight_rules").ScssHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,o=r("./behaviour/css").CssBehaviour,u=r("./folding/cstyle").FoldMode,a=r("./css_completions").CssCompletions,i=function(){this.HighlightRules=d,this.$outdent=new g,this.$behaviour=new o,this.$completer=new a,this.foldingRules=new u};x.inherits(i,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(s,e,n){var t=this.$getIndent(e),l=this.getTokenizer().getLineTokens(e,s).tokens;return l.length&&"comment"==l[l.length-1].type||e.match(/^.*\{\s*$/)&&(t+=n),t},this.checkOutdent=function(s,e,n){return this.$outdent.checkOutdent(e,n)},this.autoOutdent=function(s,e,n){this.$outdent.autoOutdent(e,n)},this.getCompletions=function(s,e,n,t){return this.$completer.getCompletions(s,e,n,t)},this.$id="ace/mode/scss"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/sass_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/scss_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),d=(r("../lib/lang"),r("./scss_highlight_rules").ScssHighlightRules),g=function(){d.call(this);var o=this.$rules.start;"comment"==o[1].token&&(o.splice(1,1,{onMatch:function(u,a,i){return i.unshift(this.next,-1,u.length-2,a),"comment"},regex:/^\s*\/\*/,next:"comment"},{token:"error.invalid",regex:"/\\*|[{;}]"},{token:"support.type",regex:/^\s*:[\w\-]+\s/}),this.$rules.comment=[{regex:/^\s*/,onMatch:function(u,a,i){return-1===i[1]&&(i[1]=Math.max(i[2],u.length-1)),u.length<=i[1]?(i.shift(),i.shift(),i.shift(),this.next=i.shift(),"text"):(this.next="","comment")},next:"start"},{defaultToken:"comment"}])};x.inherits(g,d),h.SassHighlightRules=g}),ace.define("ace/mode/sass",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sass_highlight_rules","ace/mode/folding/coffee"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./sass_highlight_rules").SassHighlightRules,g=r("./folding/coffee").FoldMode,o=function(){this.HighlightRules=d,this.foldingRules=new g,this.$behaviour=this.$defaultBehaviour};x.inherits(o,f),function(){this.lineCommentStart="//",this.$id="ace/mode/sass"}.call(o.prototype),h.Mode=o}),ace.define("ace/mode/less_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,d=r("./css_highlight_rules"),g=function(){var o="@import|@media|@font-face|@keyframes|@-webkit-keyframes|@supports|@charset|@plugin|@namespace|@document|@page|@viewport|@-ms-viewport|or|and|when|not",u=o.split("|"),a=d.supportType.split("|"),i=this.createKeywordMapper({"support.constant":d.supportConstant,keyword:o,"support.constant.color":d.supportConstantColor,"support.constant.fonts":d.supportConstantFonts},"identifier",!0),s="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";this.$rules={start:[{token:"comment",regex:"\\/\\/.*$"},{token:"comment",regex:"\\/\\*",next:"comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:["constant.numeric","keyword"],regex:"("+s+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:"constant.numeric",regex:s},{token:["support.function","paren.lparen","string","paren.rparen"],regex:"(url)(\\()(.*)(\\))"},{token:["support.function","paren.lparen"],regex:"(:extend|[a-z0-9_\\-]+)(\\()"},{token:function(e){return u.indexOf(e.toLowerCase())>-1?"keyword":"variable"},regex:"[@\\$][a-z0-9_\\-@\\$]*\\b"},{token:"variable",regex:"[@\\$]\\{[a-z0-9_\\-@\\$]*\\}"},{token:function(e,n){return a.indexOf(e.toLowerCase())>-1?["support.type.property","text"]:["support.type.unknownProperty","text"]},regex:"([a-z0-9-_]+)(\\s*:)"},{token:"keyword",regex:"&"},{token:i,regex:"\\-?[@a-z_][@a-z0-9_\\-]*"},{token:"variable.language",regex:"#[a-z0-9-_]+"},{token:"variable.language",regex:"\\.[a-z0-9-_]+"},{token:"variable.language",regex:":[a-z_][a-z0-9-_]*"},{token:"constant",regex:"[a-z0-9-_]+"},{token:"keyword.operator",regex:"<|>|<=|>=|=|!=|-|%|\\+|\\*"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"},{caseInsensitive:!0}],comment:[{token:"comment",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]},this.normalizeRules()};x.inherits(g,f),h.LessHighlightRules=g}),ace.define("ace/mode/less",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/less_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/css_completions","ace/mode/folding/cstyle"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./less_highlight_rules").LessHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,o=r("./behaviour/css").CssBehaviour,u=r("./css_completions").CssCompletions,a=r("./folding/cstyle").FoldMode,i=function(){this.HighlightRules=d,this.$outdent=new g,this.$behaviour=new o,this.$completer=new u,this.foldingRules=new a};x.inherits(i,f),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(s,e,n){var t=this.$getIndent(e),l=this.getTokenizer().getLineTokens(e,s).tokens;return l.length&&"comment"==l[l.length-1].type||e.match(/^.*\{\s*$/)&&(t+=n),t},this.checkOutdent=function(s,e,n){return this.$outdent.checkOutdent(e,n)},this.autoOutdent=function(s,e,n){this.$outdent.autoOutdent(e,n)},this.getCompletions=function(s,e,n,t){return this.$completer.getCompletions("ruleset",e,n,t)},this.$id="ace/mode/less"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text_highlight_rules").TextHighlightRules,d=h.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};h.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},h.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},h.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var g=h.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"},o=h.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/},u=h.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/},a=h.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/},i=h.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/},s=h.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/},e=h.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"},n=h.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},t=function(){var w=this.$keywords=this.createKeywordMapper({keyword:"alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend","constant.language":"true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION","variable.language":"$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|$!|root_url|flash|session|cookies|params|request|response|logger|self","support.function":"abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|validates_inclusion_of|validates_numericality_of|validates_with|validates_each|authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|cache|expire_fragment|expire_cache_for|observe|cache_sweeper|has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|private_class_method|remove_method|undef_method","invalid.deprecated":"debugger"},"identifier"),k="\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})",R={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:k},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:k},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(b,y,m){return m.length&&(m=[]),m.unshift(b[b.length-1],y),this.next="qStateWithoutInterpolation",this.token}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(b,y,m){return m.length&&(m=[]),m.unshift(b[b.length-1],y),this.next="qStateWithInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(b,y,m){return m.length&&(m=[]),m.unshift(b[b.length-1],y),this.next="sStateWithoutInterpolation",this.token}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(b,y,m){return m.length&&(m=[]),m.unshift(b[b.length-1],y),this.next="sStateWithInterpolation",this.token}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(b,y,m){return m.length&&(m=[]),m.unshift(b[b.length-1],y),this.next="rState",this.token}}],{token:"punctuation",regex:"::"},n,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+k+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},i,s,d,g,e,o,u,a,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:w,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(b,y,m){var M="-"==b[2]||"~"==b[2]?"indentedHeredoc":"heredoc",C=b.split(this.splitRegex);return m.push(M,C[3]),[{type:"constant",value:C[1]},{type:"string",value:C[2]},{type:"support.class",value:C[3]},{type:"string",value:C[4]}]},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(b,y,m){return b===m[1]?(m.shift(),m.shift(),this.next=m[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(b,y,m){return b===m[1]?(m.shift(),m.shift(),this.next=m[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(b,y){return"heredoc"===y[0]||"indentedHeredoc"===y[0]?y[0]:b}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(b,y,m){return this.next="","}"==b&&m.length>1&&"start"!=m[1]&&(m.shift(),this.next=m.shift()),this.token}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],comment:[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],qStateWithInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(b,y,m){return m.length&&b===m[0]?(m.unshift(b,y),this.token):"string"}},{token:"constant.language.escape",regex:k},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(b,y,m){return m.length&&b===R[m[0]]?(m.shift(),this.next=m.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],qStateWithoutInterpolation:[{token:"string.start",regex:/[(\[<{]/,onMatch:function(b,y,m){return m.length&&b===m[0]?(m.unshift(b,y),this.token):"string"}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(b,y,m){return m.length&&b===R[m[0]]?(m.shift(),this.next=m.shift(),this.token):(this.next="","string")}},{defaultToken:"string"}],sStateWithoutInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(b,y,m){return m.length&&b===m[0]?(m.unshift(b,y),this.token):"constant.other.symbol.ruby"}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(b,y,m){return m.length&&b===R[m[0]]?(m.shift(),this.next=m.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],sStateWithInterpolation:[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(b,y,m){return m.length&&b===m[0]?(m.unshift(b,y),this.token):"constant.other.symbol.ruby"}},{token:"constant.language.escape",regex:k},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(b,y,m){return m.length&&b===R[m[0]]?(m.shift(),this.next=m.shift(),this.token):(this.next="","constant.other.symbol.ruby")}},{defaultToken:"constant.other.symbol.ruby"}],rState:[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(b,y,m){return m.length&&b===m[0]?(m.unshift(b,y),this.token):"constant.language.escape"}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(b,y,m){return m.length&&b[0]===R[m[0]]?(m.shift(),this.next=m.shift(),this.token):(this.next="","constant.language.escape")}},{include:"regex"},{defaultToken:"string.regexp"}],regex:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]},this.normalizeRules()};x.inherits(t,f),h.RubyHighlightRules=t}),ace.define("ace/mode/folding/ruby",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"],function(r,h,_){"use strict";var x=r("../../lib/oop"),f=r("./fold_mode").FoldMode,d=r("../../range").Range,g=r("../../token_iterator").TokenIterator,o=h.FoldMode=function(){};x.inherits(o,f),function(){this.indentKeywords={class:1,def:1,module:1,do:1,unless:1,if:1,while:1,for:1,until:1,begin:1,else:0,elsif:0,rescue:0,ensure:0,when:0,end:-1,case:1,"=begin":1,"=end":-1},this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/,this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/,this.getFoldWidget=function(u,a,i){var t,s=u.getLine(i),e=this.foldingStartMarker.test(s),n=this.foldingStopMarker.test(s);if(e&&!n)if((t=s.match(this.foldingStartMarker))[1]){if(("if"==t[1]||"else"==t[1]||"while"==t[1]||"until"==t[1]||"unless"==t[1])&&("else"==t[1]&&!1===/^\s*else\s*$/.test(s)||!1===/^\s*(?:if|else|while|until|unless)\s*/.test(s))||"when"==t[1]&&!0===/\sthen\s/.test(s))return;if("keyword"===u.getTokenAt(i,t.index+2).type)return"start"}else{if(!t[3])return"start";if("comment.multiline"===u.getTokenAt(i,t.index+1).type)return"start"}if("markbeginend"!=a||!n||e&&n)return"";if("end"===(t=s.match(this.foldingStopMarker))[3]){if("keyword"===u.getTokenAt(i,t.index+1).type)return"end"}else{if(!t[1])return"end";if("comment.multiline"===u.getTokenAt(i,t.index+1).type)return"end"}},this.getFoldWidgetRange=function(u,a,i){var e,s=u.doc.getLine(i);return(e=this.foldingStartMarker.exec(s))?e[1]||e[3]?this.rubyBlock(u,i,e.index+2):this.openingBracketBlock(u,"{",i,e.index):(e=this.foldingStopMarker.exec(s))?"end"===e[3]&&"keyword"===u.getTokenAt(i,e.index+1).type||"=end"===e[1]&&"comment.multiline"===u.getTokenAt(i,e.index+1).type?this.rubyBlock(u,i,e.index+1):this.closingBracketBlock(u,"}",i,e.index+e[0].length):void 0},this.rubyBlock=function(u,C,i,s){var e=new g(u,C,i),n=e.getCurrentToken();if(n&&("keyword"==n.type||"comment.multiline"==n.type)){var t=n.value,l=u.getLine(C);switch(n.value){case"if":case"unless":case"while":case"until":if(!new RegExp("^\\s*"+n.value).test(l))return;var p=this.indentKeywords[t];break;case"when":if(/\sthen\s/.test(l))return;case"elsif":case"rescue":case"ensure":p=1;break;case"else":if(!new RegExp("^\\s*"+n.value+"\\s*$").test(l))return;p=1;break;default:p=this.indentKeywords[t]}var v=[t];if(p){var w=-1===p?u.getLine(C-1).length:u.getLine(C).length,k=C,R=[];if(R.push(e.getCurrentTokenRange()),e.step=-1===p?e.stepBackward:e.stepForward,"comment.multiline"==n.type){for(;n=e.step();)if("comment.multiline"===n.type)if(1==p){if(w=6,"=end"==n.value)break}else if("=begin"==n.value)break}else for(;n=e.step();){var b=!1;if("keyword"===n.type){var y=p*this.indentKeywords[n.value];switch(l=u.getLine(e.getCurrentTokenRow()),n.value){case"do":for(var m=e.$tokenIndex-1;m>=0;m--){var M=e.$rowTokens[m];if(M&&("while"==M.value||"until"==M.value||"for"==M.value)){y=0;break}}break;case"else":(!new RegExp("^\\s*"+n.value+"\\s*$").test(l)||"case"==t)&&(y=0,b=!0);break;case"if":case"unless":case"while":case"until":new RegExp("^\\s*"+n.value).test(l)||(y=0,b=!0);break;case"when":(/\sthen\s/.test(l)||"case"==t)&&(y=0,b=!0)}if(y>0)v.unshift(n.value);else if(y<=0&&!1===b){if(v.shift(),!v.length&&(("while"==t||"until"==t||"for"==t)&&"do"!=n.value||"do"==n.value&&-1==p&&0!=y||"do"!=n.value))break;0===y&&v.unshift(n.value)}}}if(!n)return null;if(s)return R.push(e.getCurrentTokenRange()),R;if(C=e.getCurrentTokenRow(),-1===p){if("comment.multiline"===n.type)var $=6;else $=u.getLine(C).length;return new d(C,$,k-1,w)}return new d(k,w,C-1,u.getLine(C-1).length)}}}}.call(o.prototype)}),ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/ruby"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./ruby_highlight_rules").RubyHighlightRules,g=r("./matching_brace_outdent").MatchingBraceOutdent,o=r("../range").Range,u=r("./behaviour/cstyle").CstyleBehaviour,a=r("./folding/ruby").FoldMode,i=function(){this.HighlightRules=d,this.$outdent=new g,this.$behaviour=new u,this.foldingRules=new a,this.indentKeywords=this.foldingRules.indentKeywords};x.inherits(i,f),function(){this.lineCommentStart="#",this.getNextLineIndent=function(s,e,n){var t=this.$getIndent(e),c=this.getTokenizer().getLineTokens(e,s).tokens;if(c.length&&"comment"==c[c.length-1].type)return t;if("start"==s){var p=e.match(/^.*[\{\(\[]\s*$/),v=e.match(/^\s*(class|def|module)\s.*$/),w=e.match(/.*do(\s*|\s+\|.*\|\s*)$/),k=e.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);(p||v||w||k)&&(t+=n)}return t},this.checkOutdent=function(s,e,n){return/^\s+(end|else|rescue|ensure)$/.test(e+n)||this.$outdent.checkOutdent(e,n)},this.autoOutdent=function(s,e,n){var t=e.getLine(n);if(/}/.test(t))return this.$outdent.autoOutdent(e,n);var l=this.$getIndent(t),c=e.getLine(n-1),p=this.$getIndent(c),v=e.getTabString();p.length<=l.length&&l.slice(-v.length)==v&&e.remove(new o(n,l.length-v.length,n,l.length))},this.getMatching=function(s,e,n){if(null==e){var t=s.selection.lead;n=t.column,e=t.row}var l=s.getTokenAt(e,n);if(l&&l.value in this.indentKeywords)return this.foldingRules.rubyBlock(s,e,n,!0)},this.$id="ace/mode/ruby",this.snippetFileId="ace/snippets/ruby"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/slim",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/slim_highlight_rules","ace/mode/javascript","ace/mode/markdown","ace/mode/coffee","ace/mode/scss","ace/mode/sass","ace/mode/less","ace/mode/ruby","ace/mode/css"],function(r,h,_){"use strict";var x=r("../lib/oop"),f=r("./text").Mode,d=r("./slim_highlight_rules").SlimHighlightRules,g=function(){f.call(this),this.HighlightRules=d,this.createModeDelegates({javascript:r("./javascript").Mode,markdown:r("./markdown").Mode,coffee:r("./coffee").Mode,scss:r("./scss").Mode,sass:r("./sass").Mode,less:r("./less").Mode,ruby:r("./ruby").Mode,css:r("./css").Mode})};x.inherits(g,f),function(){this.$id="ace/mode/slim"}.call(g.prototype),h.Mode=g}),ace.require(["ace/mode/slim"],function(r){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=r)});